{ SNDLIB.PAS : Internal speaker sound routine library for Windows

  title   : SNDLIB
  version : 1.2
  date    : Apr 30,1999
  author  : J R Ferguson
  origin  : Johan Molenaar, Blaise, Jun 1994, p.65
  language: Borland Pascal v7.0 (all targets)
            Delphi 1.0 through 3.0 for Windows
  usage   : Unit

}

{$ifdef WINDOWS} {$define Emulate_Sound} {$endif}
{$ifdef WIN32  } {$define Emulate_Sound} {$endif}

UNIT SNDLIB;


INTERFACE
uses
{$ifdef Emulate_Sound} WinProcs; {$else} Crt; {$endif}

procedure SndSoundOn(f: word);
{ Start internal speaker sound with frequency f Herz }

procedure SndSoundOff;
{ Stop internal speaker sound. }

procedure SndDelay(msec: word);
{ Wait msec milliseconds. }

procedure SndPlayNote(f, msec: word);
{ Play a note with a frequency of f Hertz and a duration
  of msec milliseconds.
}

IMPLEMENTATION

procedure SndSoundOn(f: word);
{$ifndef Emulate_Sound}
begin Sound(f) end;
{$else}
var InitialCount: word;
begin if f<>0 then begin {#JRF# prevent division by 0}
  InitialCount:= 1193180 div f;
  asm
     cli                      { disable interrupts }
     mov  al,$B6              { binary counter, block, channel 2 }
     out  $43,al
     mov  ax,InitialCount
     out  $42,al              { LSB }
     mov  al,ah
     out  $42,al              { MSB }
     in   al,$61              { set lower 2 bits of PPI }
     or   al,$03
     out  $61,al
     sti                      { enable interrupts }
  end;
end end;
{$endif}

procedure SndSoundOff;
{$ifndef Emulate_Sound}
begin NoSound end;
{$else}
assembler;
asm
     cli                      { disable interrupts }
     in   al,$61              { reset lower 2 bits of PPI }
     and  al,$FC
     out  $61,al
     sti                      { enable interrupts }
end;
{$endif}

procedure SndDelay(msec: word);
{$ifndef Emulate_Sound}
begin Delay(msec) end;
{$else}
{ GetTickcount returns the number of milliseconds since
  Windows was started. The value is stored in a longint,
  allowing for approximately 49 days before a wrap around
  to zero occurs.
  By masking off the most significant half we avoid overflow
  and ensure a positive value, while still remaining the
  required word precision.
}
const Mask = $0000FFFF;
var start, current, target: longint;
begin if msec <> 0 then begin {#JRF#}
  start := GetTickCount and Mask;
  target:= start + msec;
  repeat
    current:= GetTickCount and Mask;
    if current < start then Inc(current,$10000);
  until current >= target;
end end;
{$endif}

procedure SndPlayNote(f, msec: word);
begin
  SndSoundOn(f);
  SndDelay(msec);
  SndSoundOff;
end;

END.
