{ SNDTSTW.PAS : Test on SNDLIB unit

  title   : SNDTSTW
  version : 1.1
  date    : Feb 19 2000
  author  : J R Ferguson
  language: Borland Pascal v7.0 with Objects
  usage   : MS-Windows v3.1 application
}


{
--- Compiler options ---
}

{$B-} { Short-circuit Boolean expression evaluation }
{$V-} { Relaxed var-string checking }
{$X+} { Extended syntax }


PROGRAM SNDTSTW;

Uses
  BWCC, WinTypes, WinProcs, ODialogs, OWindows, Strings, SndLib;

{$R SNDTSTW.RES} { Resource file }
{$I SNDTSTW.INC} { Resource file related constants }

const
  C_ProgramIdent    = 'SNDTSTW';
  C_MainWindowClass = 'SNDTSTWMAIN';
  C_MinFreq         = 20;
  C_MaxFreq         = 5000;
  C_DflFreq         = 440;
  C_MinDuration     = 100;
  C_MaxDuration     = 2000;
  C_DflDuration     = 500;

type
  P_Application = ^T_Application;
  P_MainWindow  = ^T_MainWindow;
  P_TestSoundBuf= ^T_TestSoundBuf;
  P_TestSoundDlg= ^T_TestSoundDlg;

  T_Application = Object(TApplication)
    procedure   InitMainWindow; virtual;
  end;

  T_MainWindow  = Object(TWindow)
    function    GetClassName: PChar; virtual;
    procedure   SetupWindow; virtual;
    procedure   Paint(V_DC: HDC; var V_PaintInfo: TPaintStruct); virtual;
  end;

  T_TestSoundBuf= record
    IO_FreqStr  : array[0..10] of char;
    IO_FreqBar  : record LowVal, HighVal, Position: integer; end;
    IO_DuraStr  : array[0..10] of char;
    IO_DuraBar  : record LowVal, HighVal, Position: integer; end;
  end;

  T_TestSoundDlg= Object(TDialog)
    IOBuffer    : T_TestSoundBuf;
    FreqBar     : PScrollBar;
    DurationBar : PScrollBar;
    ControlsOK  : boolean;
    Freq        : word;
    Duration    : word;
    Constructor Init(V_Parent: PWindowsObject; V_Name: PChar);
    Destructor  Done;                virtual;
    procedure   InitControls;        virtual;
    procedure   InitData;            virtual;
    procedure   ImportData;          virtual;
    function    ExportData: boolean; virtual;
    function    CanClose: boolean;   virtual;
    procedure   DispatchScroll(var Msg: TMessage); virtual;
    procedure   DoPlay;              virtual id_First + id_Play;
  end;


{
--- General ---
}

function HzToPos(V_Frequency: word): word;
begin HzToPos:= Round(100.0 * ln(V_Frequency)) end;

function PosToHz(V_Position: word): word;
begin PosToHz:= round(exp(V_Position / 100.0)) end;


{
--- T_Application ---
}

procedure   T_Application.InitMainWindow;
begin
  MainWindow:= New(P_MainWindow,Init(nil,''));
end;


{
--- T_MainWindow ---
}

function    T_MainWindow.GetClassName: PChar;
begin
  GetClassName:= C_MainWindowClass;
end;

procedure   T_MainWindow.SetupWindow;
begin
  Inherited SetupWindow;
  {display testsound dialog immediately}
  Application^.ExecDialog(New(P_TestSoundDlg, Init(@Self, MakeIntResource(Dlg_TestSound))));
end;

procedure   T_MainWindow.Paint(V_DC: HDC; var V_PaintInfo: TPaintStruct);
begin
  {exit as soon as testsound dialog is closed; do not display main window}
  Done;
end;


{
--- T_TestSoundDlg ---
}

Constructor T_TestSoundDlg.Init(V_Parent: PWindowsObject; V_Name: PChar);
begin
  Inherited Init(V_Parent,V_Name);
  ControlsOK:= false;
  InitControls; InitData; ImportData;
  ControlsOK:= true;
end;

Destructor  T_TestSoundDlg.Done;
begin
  Inherited Done;
end;

procedure   T_TestSoundDlg.InitControls;
var p: PControl;
begin
  TransferBuffer:= @IOBuffer;
  p:= New(PStatic,InitResource(@Self,id_SoundFreqStr,11));
  FreqBar:= New(PScrollBar,InitResource(@Self,id_SoundFreqBar));
  FreqBar^.PageMagnitude:= 69;
  with IOBuffer.IO_FreqBar do begin
    LowVal  := HzToPos(C_MinFreq);
    HighVal := HzToPos(C_MaxFreq);
    Position:= HzToPos(C_DflFreq);
  end;
  p:= New(PStatic,InitResource(@Self,id_SoundDurationStr,11));
  DurationBar:= New(PScrollBar,InitResource(@Self,id_SoundDurationBar));
  DurationBar^.PageMagnitude:= 500;
  with IOBuffer.IO_DuraBar do begin
    LowVal  := C_MinDuration;
    HighVal := C_MaxDuration;
  end;
end;

procedure   T_TestSoundDlg.InitData;
begin
  Freq     := C_DflFreq;
  Duration := C_DflDuration;
end;

procedure   T_TestSoundDlg.ImportData;
begin with IOBuffer do begin
  Str(Freq,IO_FreqStr); StrCat(IO_FreqStr,' Hz');
  IO_FreqBar.Position:= HzToPos(Freq);
  Str(Duration,IO_DuraStr); StrCat(IO_DuraStr,' ms');
  IO_DuraBar.Position:= Duration;
  TransferData(tf_SetData);
end; end;

function    T_TestSoundDlg.ExportData: boolean;
begin with IOBuffer do begin
  TransferData(tf_GetData);
  Freq      := PosToHz(IO_FreqBar.Position);
  Duration  := IO_DuraBar.Position;
  ExportData:= true;
end; end;

function    T_TestSoundDlg.CanClose: boolean;
begin
  SndSoundOff;
  CanClose:= Inherited Canclose;
end;

procedure   T_TestSoundDlg.DispatchScroll(var Msg: TMessage);
begin
  if ControlsOK then if ExportData then ImportData;
  Inherited DispatchScroll(Msg);
end;

procedure   T_TestSoundDlg.DoPlay;
begin
  SndPlayNote(Freq,Duration);
end;


{
--- Main progam ---
}

begin { Main program }
  Application:= New(P_Application, Init(C_ProgramIdent));
  Application^.Run;
  Dispose(Application,Done);
end.
