{ NUMTST.PAS : Test NUMLIB Unit

  Title   : NUMTST
  Version : 5.0
  Date    : Dec 21, 1997
  Language: Borland Turbo Pascal 5.5 through 7.0 (all targets)
  Author  : J.R. Ferguson
  Usage   : Test program
}

{$N+} {use or emulate numerical coprocessor}

program NumTst;

uses
{$IFDEF WINDOWS}
  WinCrt,
{$ELSE}
  Crt,
{$ENDIF}
  NumLib, DefLib, ChrLib, ConLib;


var
  i, j : integer;
  x, y : real;
  Ex,Ey: extended;

procedure wrln;  begin writeln end;
procedure wrln2; begin writeln; writeln end;

procedure rdi(prompt: StpTyp; var i: integer);      { read integer }
var err: boolean;
begin
  repeat
    write(prompt);
    {$I-} readln(i); {$I+}
    err:= IOresult <> 0;
    if err then write(chr(AsciiBEL));
  until not err;
 end;

procedure rdr(prompt: StpTyp; var x: real);  { read real }
var err: boolean;
begin
  repeat
    write(prompt);
    {$I-} readln(x); {$I+}
    err:= IOresult <> 0;
    if err then write(chr(AsciiBEL));
  until not err;
end;

procedure rde(prompt: StpTyp; var Ex: extended);  { read extended }
var err: boolean;
begin
  repeat
    write(prompt);
    {$I-} readln(Ex); {$I+}
    err:= IOresult <> 0;
    if err then write(chr(AsciiBEL));
  until not err;
end;

procedure rdi1;  begin wrln2; rdi('i=',i) end;
procedure rdi2;  begin wrln2; rdi('i=',i); rdi('j=',j) end;
procedure rdr1;  begin wrln2; rdr('x=',x) end;
procedure rdr2;  begin wrln2; rdr('x=',x); rdr('y=',y) end;
procedure rde1;  begin wrln2; rde('x=',Ex) end;
procedure rde2;  begin wrln2; rde('x=',Ex); rde('y=',Ey) end;
procedure wri1;  begin writeln('i=',i) end;
procedure wri2;  begin writeln('i=',i); writeln('j=',j) end;

procedure xconst;
begin
  wrln2; wrln;
  writeln('        ','Library constant':27,'Computed value':27,'  ','Difference'    :10);
  writeln('Pi     =',Pi                :27,Pi              :27,'  ',Pi-Pi           :10);
  writeln('DblPi  =',DblPi             :27,Pi*2.0          :27,'  ',Pi*2.0-DblPi    :10);
  writeln('HalfPi =',HalfPi            :27,Pi*0.5          :27,'  ',Pi*0.5-HalfPi   :10);
  writeln('Radian =',Radian            :27,180.0/Pi        :27,'  ',180.0/Pi-Radian :10);
  writeln('Ln2    =',Ln2               :27,ln(2.0)         :27,'  ',ln(2.0)-Ln2     :10);
  writeln('Ln10   =',Ln10              :27,ln(10.0)        :27,'  ',ln(10.0)-Ln10   :10);
 end;


procedure xodd;    begin rdi1;writeln('odd(i)=',odd(i)) end;
procedure xeven;   begin rdi1;writeln('even(i)=',even(i)) end;

procedure xImax;   begin rdi2;writeln('max=',Imax(i,j)) end;
procedure xImin;   begin rdi2;writeln('min=',Imin(i,j)) end;
procedure xRmax;   begin rdr2;writeln('max=',Rmax(x,y)) end;
procedure xRmin;   begin rdr2;writeln('min=',Rmin(x,y)) end;
procedure xEmax;   begin rde2;writeln('max=',Emax(Ex,Ey)) end;
procedure xEmin;   begin rde2;writeln('min=',Emin(Ex,Ey)) end;

procedure xIsign;  begin rdi1;writeln('Isign(i)=',Isign(i)) end;
procedure xRsign;  begin rdr1;writeln('Rsign(x)=',Rsign(x)) end;
procedure xEsign;  begin rde1;writeln('Esign(x)=',Esign(Ex)) end;

procedure xln;     begin rdr1;writeln('ln(x)=',ln(x)) end;
procedure xlog2;   begin rdr1;writeln('log2(x)=',log2(x)) end;
procedure xlog10;  begin rdr1;writeln('log10(x)=',log10(x)) end;
procedure xlogg;   begin rdr2;writeln('logg(x)=y_log(x)=',logg(y,x)) end;

procedure xEln;    begin rde1;writeln('Eln(x)=',Eln(Ex)) end;
procedure xElog2;  begin rde1;writeln('Elog2(x)=',Elog2(Ex)) end;
procedure xElog10; begin rde1;writeln('Elog10(x)=',Elog10(Ex)) end;
procedure xElogg;  begin rde2;writeln('Elogg(x)=y_log(x)=',Elogg(Ey,Ex)) end;

procedure xPostInc;begin rdi1;writeln('PostInc(i)=',PostInc(i));wri1 end;
procedure xPostDec;begin rdi1;writeln('PostDec(i)=',PostDec(i));wri1 end;
procedure xPreInc; begin rdi1;writeln('PreInc(i)=',PreInc(i));wri1 end;
procedure xPreDec; begin rdi1;writeln('PreDec(i)=',PreDec(i));wri1 end;

procedure xIpowerI;begin rdi2;writeln('IpowerI(i,j)=',IpowerI(i,j)) end;
procedure xRpowerR;begin rdr2;writeln('RpowerR(x,y)=',RpowerR(x,y)) end;
procedure xEpowerE;begin rde2;writeln('EpowerE(x,y)=',EpowerE(Ex,Ey)) end;
procedure xRpowerI;begin rdr1;rdi1;writeln('RpowerI(x,i)=',RpowerI(x,i)) end;
procedure xEpowerI;begin rde1;rdi1;writeln('EpowerI(x,i)=',EpowerI(Ex,i)) end;

procedure xrad;    begin rdr1;writeln('rad(x)=',rad(x)/Pi,' * Pi') end;
procedure xdeg;    begin rdr1;writeln('deg(x*Pi)=',deg(x*Pi)) end;
procedure xErad;   begin rde1;writeln('Erad(x)=',Erad(Ex)/Pi,' * Pi') end;
procedure xEdeg;   begin rde1;writeln('Edeg(x*Pi)=',Edeg(Ex*Pi)) end;

procedure xtan;    begin rdr1;writeln('tan(x*Pi)=',tan(x*Pi)) end;
procedure xcot;    begin rdr1;writeln('cot(x*Pi)=',cot(x*Pi)) end;
procedure xsec;    begin rdr1;writeln('sec(x*Pi)=',sec(x*Pi)) end;
procedure xcosec;  begin rdr1;writeln('cosec(x*Pi)=',cosec(x*Pi)) end;

procedure xEtan;   begin rde1;writeln('Etan(x*Pi)=',Etan(Ex*Pi)) end;
procedure xEcot;   begin rde1;writeln('Ecot(x*Pi)=',Ecot(Ex*Pi)) end;
procedure xEsec;   begin rde1;writeln('Esec(x*Pi)=',Esec(Ex*Pi)) end;
procedure xEcosec; begin rde1;writeln('Ecosec(x*Pi)=',Ecosec(Ex*Pi)) end;

procedure xArcSin; begin rdr1;writeln('ArcSin(x)=',ArcSin(x)/Pi,' * Pi') end;
procedure xArcCos; begin rdr1;writeln('ArcCos(x)=',ArcCos(x)/Pi,' * Pi') end;
procedure xArcTan; begin rdr1;writeln('ArcTan(x)=',ArcTan(x)/Pi,' * Pi') end;
procedure xArcCot; begin rdr1;writeln('ArcCot(x)=',ArcCot(x)/Pi,' * Pi') end;

procedure xEArcSin;begin rde1;writeln('EArcSin(x)=',EArcSin(Ex)/Pi,' * Pi') end;
procedure xEArcCos;begin rde1;writeln('EArcCos(x)=',EArcCos(Ex)/Pi,' * Pi') end;
procedure xEArcTan;begin rde1;writeln('EArcTan(x)=',EArcTan(Ex)/Pi,' * Pi') end;
procedure xEArcCot;begin rde1;writeln('EArcCot(x)=',EArcCot(Ex)/Pi,' * Pi') end;

procedure xsinH;   begin rdr1;writeln('sinH(x*Pi)=',sinH(x*Pi)) end;
procedure xcosH;   begin rdr1;writeln('cosH(x*Pi)=',cosH(x*Pi)) end;
procedure xtanH;   begin rdr1;writeln('tanH(x*Pi)=',tanH(x*Pi)) end;
procedure xcotH;   begin rdr1;writeln('cotH(x*Pi)=',cotH(x*Pi)) end;

procedure xEsinH;  begin rde1;writeln('EsinH(x*Pi)=',EsinH(Ex*Pi)) end;
procedure xEcosH;  begin rde1;writeln('EcosH(x*Pi)=',EcosH(Ex*Pi)) end;
procedure xEtanH;  begin rde1;writeln('EtanH(x*Pi)=',EtanH(Ex*Pi)) end;
procedure xEcotH;  begin rde1;writeln('EcotH(x*Pi)=',EcotH(Ex*Pi)) end;


{$I NUMTSTM1.PAS}
{$I NUMTSTM2.PAS}
{$I NUMTSTM3.PAS}
{$I NUMTSTM4.PAS}
{$I NUMTSTM.PAS}


begin
  numtstm;
{$IFDEF WINDOWS}
  DoneWinCrt;
{$ELSE}
  writeln('Exit');
  wrln;
{$ENDIF}
end.
