{ FLTTST1.PAS : Test 1 on FLTLIB.PAS: T_Flt_PipeApp

  title   : FLTTST1
  version : 1.0
  date    : Dec 14,1995
  author  : J R Ferguson
  language: Borland Pascal v7.0 with Objects;
  usage   : Program
}

PROGRAM FLTTST1;

Uses DefLib, StpLib, StfLib, FltLib;

const
  C_ProgIdent   = 'FLTTST1';
  C_ProgVersion = '1.0';
  C_ProgTitle   = 'Test 1 on FLTLIB.PAS: T_Flt_PipeApp';

type
  P_Application = ^T_Application;

  T_Application = Object(T_Flt_PipeApp)
    procedure   DefineOptions; virtual;
    procedure   HelpOptions;   virtual;
    function    ProcessLine(var V_Line: StpTyp): boolean; virtual;
  end;

var
  Application   : P_Application;

procedure   T_Application.DefineOptions;
begin
  Inherited DefineOptions;
  Options^.DefSw('U');
  Options^.DefNm('M',false,0,80,4);
end;

procedure   T_Application.HelpOptions;
begin
  Inherited HelpOptions;
  Wl('         U[+]  Convert to uppercase');
  Wl('         U-    Convert to lowercase');
  Wl('         M[n]  Left margin n spaces (n=0..80, default 4)');
end;

function    T_Application.ProcessLine(var V_Line: StpTyp): boolean;
begin
  if Options^.Scanned('U') then
    if Options^.ValSw('U') then StpUpp(V_Line) else StpLow(V_Line);
  if Options^.Scanned('M') then
    StpIns(V_Line,StfMake(' ',Options^.ValNm('M',1)),1);
  ProcessLine:= true;
end;

begin { Main program }
  New(Application,Init(C_ProgIdent,C_ProgVersion,C_ProgTitle));
  Application^.Run;
  Dispose(Application,Done);
end.
