{ DTMTSTW.PAS : Test DtmLib unit (MS-Windows)

  Title   : DTMTSTW
  Version : 2.0
  Date    : Nov 10,1996
  Author  : J R Ferguson
  Language: Borland Pascal v7.0 with Objects, Windows target
  Usage   : MS-Windows v3.1 application
}


{--- Compiler options ---}

{$B-} { Short-circuit Boolean expression evaluation }
{$V-} { Relaxed var-string checking }
{$X+} { Extended syntax }


PROGRAM DTMTSTW;

Uses BWCC, WinTypes, WinProcs, ODialogs, OWindows, Strings, DtmLib;

{$R DTMTSTW.RES} { Resource file }
{$I DTMTSTW.INC} { Resource file related constants }

const
  C_ProgramIdent    = 'DTMTSTW';
  C_MainWindowClass = 'DTMTSTWMAIN';
  C_DtmCvtTitle     = 'DtmTst: Convert date';
  C_DtmAddTitle     = 'DtmTst: Add days to date';
  C_DtmSubTitle     = 'DtmTst: Subtract dates';

type
  P_Application = ^T_Application;
  P_MainWindow  = ^T_MainWindow;
  P_Dialog      = ^T_Dialog;
  P_DtmCvtDlg   = ^T_DtmCvtDlg;
  P_DtmAddDlg   = ^T_DtmAddDlg;
  P_DtmSubDlg   = ^T_DtmSubDlg;

  T_DlgType     = (C_DtmCvtDlg,C_DtmAddDlg,C_DtmSubDlg);

  T_DtmInfBuf   = record
                    IO_Function: array[DtmFnTyp] of Word;
                    IO_ErrMsg  : array[0..8] of char;
                    IO_IdfDays : array[0..6] of char;
                    IO_JulYear : array[0..6] of char;
                    IO_JulDays : array[0..6] of char;
                    IO_YmdYear : array[0..6] of char;
                    IO_YmdMonth: array[0..6] of char;
                    IO_YmdDay  : array[0..6] of char;
                    IO_CalYear : array[0..6] of char;
                    IO_CalWeek : array[0..6] of char;
                    IO_CalDay  : array[0..6] of char;
                    IO_CalDayNm: array[0..9] of char;
                  end;
  T_DtmCvtBuf   = record
                    IO_Result  : array[0..5] of char;
                    IO_Date    : T_DtmInfBuf;
                  end;
  T_DtmAddBuf   = record
                    IO_Result  : array[0..5] of char;
                    IO_DateBeg : T_DtmInfBuf;
                    IO_DateEnd : T_DtmInfBuf;
                    IO_Days    : array[0..6] of char;
                  end;

  T_Dialog      = Object(TDialog)
    Constructor Init(V_Parent: PWindowsObject; V_Name: Pchar);
    procedure   OK(var Msg: TMessage); virtual id_First + id_OK;
    procedure   InitControls;          virtual;
    procedure   InitData;              virtual;
    procedure   ProcessData;           virtual;
    procedure   ImportData;            virtual;
    function    ExportData: boolean;   virtual;
  end;

  T_DtmCvtDlg   = Object(T_Dialog)
    IOBuffer    : T_DtmCvtBuf;
    Date        : DtmDateRec;
    Result      : boolean;
    procedure   InitControls;          virtual;
    procedure   InitData;              virtual;
    procedure   ProcessData;           virtual;
    procedure   ImportData;            virtual;
    function    ExportData: boolean;   virtual;
  end;

  T_DtmAddDlg   = Object(T_Dialog)
    IOBuffer    : T_DtmAddBuf;
    DateBeg     : DtmDateRec;
    DateEnd     : DtmDateRec;
    Days        : LongInt;
    Result      : boolean;
    procedure   InitControls;          virtual;
    procedure   InitData;              virtual;
    procedure   ProcessData;           virtual;
    procedure   ImportData;            virtual;
    function    ExportData: boolean;   virtual;
  end;

  T_DtmSubDlg   = Object(T_DtmAddDlg)
    procedure   InitData;              virtual;
    procedure   ProcessData;           virtual;
  end;

  T_MainWindow   = Object(TWindow)
    Dialog       : P_Dialog;
    constructor  Init(V_Parent: PWindowsObject; V_Title: PChar);
    destructor   Done; virtual;
    function     GetClassName: PChar; virtual;
    procedure    GetWindowClass(var V_Class: TWndClass); virtual;
    procedure    SetupWindow; virtual;
    procedure    InitDialog(V_DlgType: T_DlgType);
    procedure    ChngDialog(V_DlgType: T_DlgType);
    procedure    DoDtmCvt    (var V_Message: TMessage); virtual cm_First + cm_DtmCvt;
    procedure    DoDtmAdd    (var V_Message: TMessage); virtual cm_First + cm_DtmAdd;
    procedure    DoDtmSub    (var V_Message: TMessage); virtual cm_First + cm_DtmSub;
    procedure    DoHelpAbout (var V_Message: TMessage); virtual cm_First + cm_InfoAbout;
    procedure    DoHelpInfo  (var V_Message: TMessage); virtual cm_First + cm_InfoHelp;
  end;

  T_Application = Object(TApplication)
    procedure    InitMainWindow; virtual;
    procedure    InitInstance; virtual;
  end;

const
  ResultMsg     : array[boolean]  of array[0..5] of char = ('false','true');
  DtmErrMsg     : array[DtmRcTyp] of array[0..8] of char =
                  ('DtmRcOk' ,'DtmRcWrn', 'DtmRcRng', 'DtmRcFun');
  CalDayNm      : array[1..7] of array[0..9] of char =
                  ('Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday');


{--- T_Dialog ---}

Constructor T_Dialog.Init(V_Parent: PWindowsObject; V_Name: Pchar);
begin
  Inherited Init(V_Parent, V_Name);
  InitControls; InitData; ProcessData; ImportData;
end;

procedure   T_Dialog.OK(var Msg: TMessage);
begin if ExportData then begin ProcessData; ImportData; end; end;

procedure   T_Dialog.InitControls;        begin end;
procedure   T_Dialog.InitData;            begin end;
procedure   T_Dialog.ProcessData;         begin end;
procedure   T_Dialog.ImportData;          begin end;
function    T_Dialog.ExportData: boolean; begin ExportData:= true; end;


{--- T_DtmCvtDlg ---}

procedure   T_DtmCvtDlg.InitControls;
var i: DtmFnTyp; p: PControl;
begin
  TransferBuffer:= @IOBuffer;
  p:= New(PStatic,InitResource(@Self,id_Result     , 6));
  for i:= DtmFnCur to DtmFnCal do
    p:= New(PRadioButton,InitResource(@Self,id_Dt1FnCur+ord(i)));
  p:= New(PStatic,InitResource(@Self,id_Dt1RetCod  , 9));
  p:= New(PStatic,InitResource(@Self,id_Dt1IdfDays , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt1JulYear , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt1JulDay  , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt1YmdYear , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt1YmdMonth, 7));
  p:= New(PStatic,InitResource(@Self,id_Dt1YmdDay  , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt1CalYear , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt1CalWeek , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt1CalDay  , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt1CalDayNm,10));
end;

procedure   T_DtmCvtDlg.InitData;
begin Date.Fn:= DtmFnCur; end;

procedure   T_DtmCvtDlg.ProcessData;
begin Result:= DtmConvert(Date); end;

procedure   T_DtmCvtDlg.ImportData;
var i: DtmFnTyp;
begin with IOBuffer do begin
  StrCopy(IO_Result,ResultMsg[Result]);
  with Date, IO_Date do begin
    for i:= DtmFnCur to DtmFnCal do
      if i=Fn then IO_Function[i]:= bf_Checked else IO_Function[i]:= bf_UnChecked;
    StrCopy(IO_ErrMsg,DtmErrMsg[Rc]);
    Str(Idf      ,IO_IdfDays );
    Str(Jul.Year ,IO_JulYear );
    Str(Jul.Day  ,IO_JulDays );
    Str(Ymd.Year ,IO_YmdYear );
    Str(Ymd.Month,IO_YmdMonth);
    Str(Ymd.Day  ,IO_YmdDay  );
    Str(Cal.Year ,IO_CalYear );
    Str(Cal.Week ,IO_CalWeek );
    Str(Cal.Day  ,IO_CalDay  );
    StrCopy(IO_CalDayNm,CalDayNm[Cal.Day]);
  end;
  TransferData(tf_SetData);
end end;

function    T_DtmCvtDlg.ExportData: boolean;
var i: DtmFnTyp; code: integer;
begin with IOBuffer do begin
  TransferData(tf_GetData);
  with Date, IO_Date do begin
    for i:= DtmFnCur to DtmFnCal do if IO_Function[i] = bf_Checked then Fn:= i;
    Val(IO_IdfDays ,Idf      ,code);
    Val(IO_JulYear ,Jul.Year ,code);
    Val(IO_JulDays ,Jul.Day  ,code);
    Val(IO_YmdYear ,Ymd.Year ,code);
    Val(IO_YmdMonth,Ymd.Month,code);
    Val(IO_YmdDay  ,Ymd.Day  ,code);
    Val(IO_CalYear ,Cal.Year ,code);
    Val(IO_CalWeek ,Cal.Week ,code);
    Val(IO_CalDay  ,Cal.Day  ,code);
  end;
  ExportData:= true;
end end;


{--- T_DtmAddDlg ---}

procedure   T_DtmAddDlg.InitControls;
var i: DtmFnTyp; p: PControl;
begin
  TransferBuffer:= @IOBuffer;

  p:= New(PStatic,InitResource(@Self,id_Result     , 6));

  for i:= DtmFnCur to DtmFnCal do
    p:= New(PRadioButton,InitResource(@Self,id_Dt1FnCur+ord(i)));
  p:= New(PStatic,InitResource(@Self,id_Dt1RetCod  , 9));
  p:= New(PStatic,InitResource(@Self,id_Dt1IdfDays , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt1JulYear , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt1JulDay  , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt1YmdYear , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt1YmdMonth, 7));
  p:= New(PStatic,InitResource(@Self,id_Dt1YmdDay  , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt1CalYear , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt1CalWeek , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt1CalDay  , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt1CalDayNm,10));

  for i:= DtmFnCur to DtmFnCal do
    p:= New(PRadioButton,InitResource(@Self,id_Dt2FnCur+ord(i)));
  p:= New(PStatic,InitResource(@Self,id_Dt2RetCod  , 9));
  p:= New(PStatic,InitResource(@Self,id_Dt2IdfDays , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt2JulYear , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt2JulDay  , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt2YmdYear , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt2YmdMonth, 7));
  p:= New(PStatic,InitResource(@Self,id_Dt2YmdDay  , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt2CalYear , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt2CalWeek , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt2CalDay  , 7));
  p:= New(PStatic,InitResource(@Self,id_Dt2CalDayNm,10));

  p:= New(PStatic,InitResource(@Self,id_Days       , 7));
end;

procedure   T_DtmAddDlg.InitData;
begin DateBeg.Fn:= DtmFnCur; Days:= 0; end;

procedure   T_DtmAddDlg.ProcessData;
begin Result:= DtmAdd(DateBeg,Days,DateEnd); end;

procedure   T_DtmAddDlg.ImportData;
var i: DtmFnTyp;
begin with IOBuffer do begin
  StrCopy(IO_Result,ResultMsg[Result]);

  with DateBeg, IO_DateBeg do begin
    for i:= DtmFnCur to DtmFnCal do
      if i=Fn then IO_Function[i]:= bf_Checked else IO_Function[i]:= bf_UnChecked;
    StrCopy(IO_ErrMsg,DtmErrMsg[Rc]);
    Str(Idf      ,IO_IdfDays );
    Str(Jul.Year ,IO_JulYear );
    Str(Jul.Day  ,IO_JulDays );
    Str(Ymd.Year ,IO_YmdYear );
    Str(Ymd.Month,IO_YmdMonth);
    Str(Ymd.Day  ,IO_YmdDay  );
    Str(Cal.Year ,IO_CalYear );
    Str(Cal.Week ,IO_CalWeek );
    Str(Cal.Day  ,IO_CalDay  );
    StrCopy(IO_CalDayNm,CalDayNm[Cal.Day]);
  end;

  with DateEnd, IO_DateEnd do begin
    for i:= DtmFnCur to DtmFnCal do
      if i=Fn then IO_Function[i]:= bf_Checked else IO_Function[i]:= bf_UnChecked;
    StrCopy(IO_ErrMsg,DtmErrMsg[Rc]);
    Str(Idf      ,IO_IdfDays );
    Str(Jul.Year ,IO_JulYear );
    Str(Jul.Day  ,IO_JulDays );
    Str(Ymd.Year ,IO_YmdYear );
    Str(Ymd.Month,IO_YmdMonth);
    Str(Ymd.Day  ,IO_YmdDay  );
    Str(Cal.Year ,IO_CalYear );
    Str(Cal.Week ,IO_CalWeek );
    Str(Cal.Day  ,IO_CalDay  );
    StrCopy(IO_CalDayNm,CalDayNm[Cal.Day]);
  end;

  Str(Days,IOBuffer.IO_Days);

  TransferData(tf_SetData);
end end;

function    T_DtmAddDlg.ExportData: boolean;
var i: DtmFnTyp; code: integer;
begin with IOBuffer do begin
  TransferData(tf_GetData);

  with DateBeg, IO_DateBeg do begin
    for i:= DtmFnCur to DtmFnCal do if IO_Function[i] = bf_Checked then Fn:= i;
    Val(IO_IdfDays ,Idf      ,code);
    Val(IO_JulYear ,Jul.Year ,code);
    Val(IO_JulDays ,Jul.Day  ,code);
    Val(IO_YmdYear ,Ymd.Year ,code);
    Val(IO_YmdMonth,Ymd.Month,code);
    Val(IO_YmdDay  ,Ymd.Day  ,code);
    Val(IO_CalYear ,Cal.Year ,code);
    Val(IO_CalWeek ,Cal.Week ,code);
    Val(IO_CalDay  ,Cal.Day  ,code);
  end;

  with DateEnd, IO_DateEnd do begin
    for i:= DtmFnCur to DtmFnCal do if IO_Function[i] = bf_Checked then Fn:= i;
    Val(IO_IdfDays ,Idf      ,code);
    Val(IO_JulYear ,Jul.Year ,code);
    Val(IO_JulDays ,Jul.Day  ,code);
    Val(IO_YmdYear ,Ymd.Year ,code);
    Val(IO_YmdMonth,Ymd.Month,code);
    Val(IO_YmdDay  ,Ymd.Day  ,code);
    Val(IO_CalYear ,Cal.Year ,code);
    Val(IO_CalWeek ,Cal.Week ,code);
    Val(IO_CalDay  ,Cal.Day  ,code);
  end;

  Val(IO_Days,Days,code);
  ExportData:= true;
end end;


{--- T_DtmSubDlg ---}

procedure   T_DtmSubDlg.InitData;
begin DateBeg.Fn:= DtmFnCur; DateEnd.Fn:= DtmFnCur; end;

procedure   T_DtmSubDlg.ProcessData;
begin Result:= DtmSubtract(DateEnd,DateBeg,Days); end;


{--- T_MainWindow ---}

constructor  T_MainWindow.Init(V_Parent: PWindowsObject; V_Title: PChar);
begin
  inherited Init(V_Parent, V_Title);
  Attr.Menu:= LoadMenu(HInstance,MakeIntResource(Mnu_Main));
  with Attr do begin
    Style:= Style and not (ws_ThickFrame or ws_MaximizeBox)
  end;
end;

destructor   T_MainWindow.Done;
begin
  {PM}
  inherited Done;
end;

function     T_MainWindow.GetClassName: PChar;
begin
  GetClassName:= C_MainWindowClass;
end;

procedure    T_MainWindow.GetWindowClass(var V_Class: TWndClass);
begin
  inherited GetWindowClass(V_Class);
  V_Class.hIcon:= LoadIcon(HInstance,MakeIntResource(Ico_MainWindow));
end;

procedure    T_MainWindow.SetupWindow;
begin
  inherited SetupWindow;
  InitDialog(C_DtmCvtDlg);
end;

procedure    T_MainWindow.DoHelpAbout (var V_Message: TMessage);
begin
  MessageBox(HWindow,
    'DTMTSTW v2.0'#13 +
    'Test DTMLIB unit'#13 +
    'Borland Pascal v7.0'#13 +
    '(MS-Windows v3.1)'#13 +
    '(c)1996, J.R. Ferguson',
    'About this program',
    mb_IconInformation or mb_OK)
end;

procedure    T_MainWindow.InitDialog(V_DlgType: T_DlgType);
var RWindow,RClient,RDialog: TRect;
begin
  case V_DlgType of
    C_DtmCvtDlg: begin
                   Dialog:= New(P_DtmCvtDlg,Init(@Self,MakeIntResource(Dlg_DtmCvt)));
                   SetCaption(C_DtmCvtTitle);
                 end;
    C_DtmAddDlg: begin
                   Dialog:= New(P_DtmAddDlg,Init(@Self,MakeIntResource(Dlg_DtmAdd)));
                   SetCaption(C_DtmAddTitle);
                 end;
    C_DtmSubDlg: begin
                   Dialog:= New(P_DtmSubDlg,Init(@Self,MakeIntResource(Dlg_DtmSub)));
                   SetCaption(C_DtmSubTitle);
                 end;
  end;
  if Application^.MakeWindow(Dialog) <> nil then begin
    GetWindowRect(Dialog^.HWindow,RDialog);
    GetWindowRect(HWindow,RWindow);
    GetClientRect(HWindow,RClient);
    MoveWindow(HWindow,
      {left   :} RWindow.Left,
      {top    :} RWindow.Top,
      {width  :} RDialog.Right-RDialog.Left,
      {height :} (RWindow.Bottom-RWindow.Top) - RClient.Bottom + (RDialog.Bottom-RDialog.Top),
      {repaint:} true);
  end;
end;

procedure    T_MainWindow.ChngDialog(V_DlgType: T_DlgType);
const cm_Cancel = 2;
begin
  if Dialog <> nil then begin
    Dialog^.EndDlg(cm_Cancel);
    Dispose(Dialog,Done); Dialog:= nil;
  end;
  InitDialog(V_DlgType);
end;

procedure    T_MainWindow.DoDtmCvt    (var V_Message: TMessage);
begin ChngDialog(C_DtmCvtDlg); end;

procedure    T_MainWindow.DoDtmAdd    (var V_Message: TMessage);
begin ChngDialog(C_DtmAddDlg); end;

procedure    T_MainWindow.DoDtmSub    (var V_Message: TMessage);
begin ChngDialog(C_DtmSubDlg); end;

procedure    T_MainWindow.DoHelpInfo  (var V_Message: TMessage);
begin Application^.ExecDialog(New(PDialog, Init(@Self, MakeIntResource(Dlg_Help)))); end;


{--- T_Application ---}

procedure    T_Application.InitMainWindow;
begin
  MainWindow:= New(P_MainWindow,Init(nil,C_ProgramIdent))
end;

procedure    T_Application.InitInstance;
begin
  inherited InitInstance;
  HAccTable:= LoadAccelerators(HInstance,MakeIntResource(Acc_Keys));
end;


{--- Main progam ---}

begin { Main program }
  Application:= New(P_Application, Init(C_ProgramIdent));
  Application^.Run;
  Dispose(Application,Done);
end.
