{ DTMTST2.PAS : DTMTST - DtmConvert auto-test

  Title   : DTMTST2
  Version : 2.1
  Date    : Nov 24,1996
  Author  : J R Ferguson
  Language: Borland Pascal 4.0 through 7.0 (all targets)
  Usage   : Include file for DTMTST.PAS
}


procedure Increment(var dt: DtmDateRec);
var MaxFeb: 28..29; MaxJul: 365..366; MaxMonth: 28..31;
begin with dt do begin

  if Ymd.Year mod 4 = 0
  then begin MaxFeb:= 29; MaxJul:= 366 end
  else begin MaxFeb:= 28; MaxJul:= 365 end;

  Idf:= Idf+1;

  with Ymd do begin
    case Month of
      2        : MaxMonth:= MaxFeb;
      4,6,9,11 : MaxMonth:= 30;
      else       MaxMonth:= 31;
    end;
    if Day<MaxMonth then inc(Day)
    else begin
      Day:=1;
      if Month<12 then inc(Month) else begin Month:=1; inc(Year) end
    end;
  end;

  with Jul do
    if Day<MaxJul then inc(Day) else begin Day:= 1; inc(Year) end;

  with Cal do begin
    if Day<7 then inc(Day)
    else begin
      Day:=1;
      if (Jul.Day < MaxJul-2) and (Jul.Day > 4) then inc(Week)
      else begin Week:= 1; inc(Year) end;
    end
  end;

end end; { Increment }

procedure OutDate(dt: DtmDateRec);
begin with dt do begin
  Write(Ymd.Year:4, Ymd.Month:3, Ymd.Day:3,' ',
        Cal.Year:4, Cal.Week :3, Cal.Day:2,' ',
        Jul.Year:4,              Jul.Day:4,'  ');
end end;

procedure Check(var dt0: DtmDateRec);
var dt1: DtmDateRec; Ok: boolean;
    da0: packed array[1..SizeOf(DtmDateRec)] of char absolute dt0;
    da1: packed array[1..SizeOf(DtmDateRec)] of char absolute dt1;
begin
  dt0.Rc:= DtmRcOk; dt1:= dt0;
  Ok:= DtmConvert(dt1);
  if (da1<>da0) then  begin
    WriteLn;
    Write(RcName(dt1.Rc),' ');
    Write('dt0='); OutDate(dt0);
    Write('dt1='); OutDate(dt1);
  end;
end;

procedure Monitor(var dt: DtmDateRec);
begin with dt.Jul do if (Day=1) then begin
  write(Year:5);
  if (Year mod 10 = 0) then WriteLn;
end end;


{--- Main line ---}

procedure xaCvt(Func: DtmFnTyp);

  procedure xaCvtInit;
  begin with dt do begin
    Fn:= Func;
    wrln2;
    writeln('Auto-test DtmConvert ',FnName(Fn));
    Idf     :=694325;
    Jul.Year:=1901;                Jul.Day:=001;
    Ymd.Year:=1901; Ymd.Month:=01; Ymd.Day:= 01;
    Cal.Year:=1901; Cal.Week :=01; Cal.Day:=  2;
    Write('begin: '); OutDate(dt); writeln;
  end end;

  procedure xaCvtTerm;
  begin
    writeln;
    Write('end  : '); OutDate(dt); writeln;
  end;

begin { xaCvt }
  xaCvtInit;
  while dt.Idf < 767008 do begin
    Monitor(dt);
    Check(dt);
    Increment(dt);
  end;
  xaCvtTerm;
end;


procedure xaCvtIdf; begin xaCvt(DtmFnIdf); end;
procedure xaCvtJul; begin xaCvt(DtmFnJul); end;
procedure xaCvtYmd; begin xaCvt(DtmFnYmd); end;
procedure xaCvtCal; begin xaCvt(DtmFnCal); end;
