{ CVTTST.PAS -- Test CvtLib unit

  Title   : CVTTST
  Version : 6.0
  Date    : Dec 22,1997
  Language: Borland Pascal 7.0 (all targets)
  Author  : J.R. Ferguson
  Usage   : Test program
}
{$R-} {range check off}

program CvtTst;

uses
{$IFDEF WINDOWS}
  WinCrt,
{$ELSE}
  Crt,
{$ENDIF}
  CvtLib, DefLib, ConLib, ChrLib;

const
  HexDigit : array[0..15] of char = '0123456789ABCDEF';

var
  s     : StpTyp;
  n,g,l : integer;
  m     : longint;
  w     : word;

{ -- General routies -- }

procedure PutHexByt(b: byte);
begin
  write(HexDigit[b shr 4]);
  write(HexDigit[b and $0F]);
end;

procedure PutHexWrd(w: word);
begin
  PutHexByt(w shr 8);
  PutHexByt(w and $FF);
  write(' ');
end;

procedure PutHexLWrd(lw: longint);
begin
  PutHexWrd(lw shr 16);
  PutHexWrd(lw and $FFFF);
end;

procedure WrLn2; begin writeln; writeln; end;

procedure RdStp;
begin
    write('string . . . . . . . . . : ');
    readln(s);
end;


procedure RdInt;
begin
  repeat
    write('integer (signed decimal) : ');
    {$I-} readln(n) {$I+};
  until IOresult=0;
end;

procedure RdLInt;
begin
  repeat
    write('longint (signed decimal) : ');
    {$I-} readln(m) {$I+};
  until IOresult=0;
end;

procedure RdWrd;
begin
  repeat
    write('word (unsigned decimal)  : ');
    {$I-} readln(w) {$I+};
  until IOresult=0;
end;

procedure RdBase;
begin
  repeat
    write('base . . . . . . . . . . : ');
    {$I-} readln(g) {$I+};
  until IOresult=0;
end;

procedure RdLen;
begin
  repeat
    write('length . . . . . . . . . : ');
    {$I-} readln(l) {$I+};
  until IOresult=0;
end;

procedure WrStp;
begin writeln('"',s,'"') end;

procedure WrInt;
begin write('n = '); PutHexWrd(word(n)); writeln('h,  ',n,' d'); end;

procedure WrLint;
begin write('n = '); PutHexLWrd(m); writeln('h,  ',m,' d'); end;

procedure WrWrd;
var wl: longint;
begin
  wl:= w;
  write('n = '); PutHexWrd(w); writeln('h,  ',wl,' d');
end;


{ -- Testroutines -- }


procedure TstItoA;
begin wrln2; RdInt; ItoA(n,s); WrStp end;

procedure TstItoAB;
begin wrln2; RdInt; RdBase; ItoAB(n,s,g); WrStp end;

procedure TstItoABL;
begin wrln2; RdInt; RdBase; RdLen; ItoABL(n,s,g,l); WrStp end;

procedure TstItoABLS;
begin wrln2; RdInt; RdBase; RdLen; ItoABLS(n,s,g,l); WrStp end;


procedure TstStfItoA;
begin wrln2; RdInt; s:=StfItoA(n); WrStp end;

procedure TstStfItoAB;
begin wrln2; RdInt; RdBase; s:=StfItoAB(n,g); WrStp end;

procedure TstStfItoABL;
begin wrln2; RdInt; RdBase; RdLen; s:=StfItoABL(n,g,l); WrStp end;

procedure TstStfItoABLS;
begin wrln2; RdInt; RdBase; RdLen; s:=StfItoABLS(n,g,l); WrStp end;


procedure TstAtoI;
begin wrln2; RdStp; n:= AtoI(s); WrInt end;

procedure TstAtoIB;
begin wrln2; RdStp; RdBase; n:= AtoIB(s,g); WrInt end;


procedure TstIfAtoI;
begin wrln2; RdStp; writeln(IfAtoI(s,n)); WrInt; end;

procedure TstIfAtoIB;
begin wrln2; RdStp; RdBase; writeln(IfAtoIB(s,g,n)); WrInt; end;


procedure TstGetIfromA;
begin wrln2; RdStp; writeln(GetIfromA(s,n)); WrInt; WrStp; end;

procedure TstGetIBfromA;
begin wrln2; RdStp; RdBase; writeln(GetIBfromA(s,g,n)); WrInt; WrStp; end;




procedure TstWtoA;
begin wrln2; RdWrd; WtoA(w,s); WrStp end;

procedure TstWtoAB;
begin wrln2; RdWrd; RdBase; WtoAB(w,s,g); WrStp end;

procedure TstWtoABL;
begin wrln2; RdWrd; RdBase; RdLen; WtoABL(w,s,g,l); WrStp end;

procedure TstWtoABLS;
begin wrln2; RdWrd; RdBase; RdLen; WtoABLS(w,s,g,l); WrStp end;


procedure TstStfWtoA;
begin wrln2; RdWrd; s:=StfWtoA(w); WrStp end;

procedure TstStfWtoAB;
begin wrln2; RdWrd; RdBase; s:=StfWtoAB(w,g); WrStp end;

procedure TstStfWtoABL;
begin wrln2; RdWrd; RdBase; RdLen; s:=StfWtoABL(w,g,l); WrStp end;

procedure TstStfWtoABLS;
begin wrln2; RdWrd; RdBase; RdLen; s:=StfWtoABLS(w,g,l); WrStp end;


procedure TstAtoW;
begin wrln2; RdStp; w:= AtoW(s); WrWrd end;

procedure TstAtoWB;
begin wrln2; RdStp; RdBase; w:= AtoWB(s,g); WrWrd end;


procedure TstIfAtoW;
begin wrln2; RdStp; writeln(IfAtoW(s,w)); WrWrd; end;

procedure TstIfAtoWB;
begin wrln2; RdStp; RdBase; writeln(IfAtoWB(s,g,w)); WrWrd; end;


procedure TstGetWfromA;
begin wrln2; RdStp; writeln(GetWfromA(s,w)); WrWrd; WrStp; end;

procedure TstGetWBfromA;
begin wrln2; RdStp; RdBase; writeln(GetWBfromA(s,g,w)); WrWrd; WrStp; end;




procedure TstLtoA;
begin wrln2; RdLInt; LtoA(m,s); WrStp end;

procedure TstLtoAB;
begin wrln2; RdLInt; RdBase; LtoAB(m,s,g); WrStp end;

procedure TstLtoABL;
begin wrln2; RdLInt; RdBase; RdLen; LtoABL(m,s,g,l); WrStp end;

procedure TstLtoABLS;
begin wrln2; RdLInt; RdBase; RdLen; LtoABLS(m,s,g,l); WrStp end;


procedure TstStfLtoA;
begin wrln2; RdLInt; s:=StfLtoA(m); WrStp end;

procedure TstStfLtoAB;
begin wrln2; RdLInt; RdBase; s:=StfLtoAB(m,g); WrStp end;

procedure TstStfLtoABL;
begin wrln2; RdLInt; RdBase; RdLen; s:=StfLtoABL(m,g,l); WrStp end;

procedure TstStfLtoABLS;
begin wrln2; RdLInt; RdBase; RdLen; s:=StfLtoABLS(m,g,l); WrStp end;


procedure TstAtoL;
begin wrln2; RdStp; m:= AtoL(s); WrLint end;

procedure TstAtoLB;
begin wrln2; RdStp; RdBase; m:= AtoLB(s,g); WrLInt end;


procedure TstIfAtoL;
begin wrln2; RdStp; writeln(IfAtoL(s,m)); WrLint; end;

procedure TstIfAtoLB;
begin wrln2; RdStp; RdBase; writeln(IfAtoLB(s,g,m)); WrLint; end;


procedure TstGetLfromA;
begin wrln2; RdStp; writeln(GetLfromA(s,m)); WrLint; WrStp; end;

procedure TstGetLBfromA;
begin wrln2; RdStp; RdBase; writeln(GetLBfromA(s,g,m)); WrLint; WrStp; end;

{$I CVTTSTM1.PAS}
{$I CVTTSTM2.PAS}
{$I CVTTSTM3.PAS}
{$I CVTTSTM.PAS}

begin
  cvttstm;
{$IFDEF WINDOWS}
  DoneWinCrt;
{ELSE}
  ClrScr;
{$ENDIF}
end.
