{ ABBREVV.PAS : Abbrevation list maintenance utility - DOS version

  Title   : ABBREVV
  Language: Borland Pascal 7.0 with Objects + Turbo Vision 2.0
  Version : 2.3
  Date    : Feb 06, 2000
  Author  : J R Ferguson
  Download: http://hello.to/ferguson
  E-mail  : j.r.ferguson@iname.com
  Usage   : MS-DOS real or protected mode application

This program and its source may be used and copied freely without charge,
but only for non-commercial purposes. The author is not responsible for 
any damage or loss of data that may be caused by using it.

To compile this source file, you wil need some units from the JRFPAS
Pascal routine library by the same author, which can be downloaded from the
Internet address mentioned above. You will also need Borland's Turbo Vision.
}

{$DEFINE DEBUG}
{$DEFINE AUTOSAVE}


{--- Compiler options ---}

{$B-} { Short-circuit Boolean expression evaluation }
{$V-} { Relaxed var-string checking }
{$X+} { Extended syntax }

PROGRAM ABBREVV;

Uses Objects, App, Dialogs, Drivers, Menus, MsgBox, StdDlg, Validate,
     Views, Dos, DefLib, BpvLib, StpLib, StfLib;

{$I OBJTYPE.INC}

const
  C_PrgTitle    = 'Abbrevations';
  C_PrgVersion  = 'v2.3';
  C_CopyRight   = '(c)1996-2000, J.R. Ferguson';
  C_AuthEmail   = 'j.r.ferguson@iname.com';
  C_AuthURL     = 'http://hello.to/ferguson';
  C_Env_Setting = 'SETTING'; { environment var for Setting Directory }
  C_SettingExt  = '.SET';
  C_DflOpenMask = '*.ABB';
  C_DflSaveMask = '*.ABB';
  C_KeyPos      = 2;
  C_KeyLen      = 7;
  C_DataPos     = 10;
  C_DataLen     = 69;
  C_ColsFirst   = false;     { tile columns first }

  cm_FileNew    = 100;
  cm_FileOpen   = 101;
  cm_FileSave   = 102;
  cm_FileSaveAs = 103;
  cm_FileSaveAll= 104;
  cm_FileChDir  = 105;
  cm_FileMerge  = 106;
  cm_FileDos    = cmDosShell;
  cm_FileExit   = cmQuit;
  cm_EditAdd    = 110;
  cm_EditChange = 111;
  cm_EditDelete = 112;
  cm_FindKey    = 120;
  cm_FindAgain  = 121;
  cm_FindDupl   = 122;
  cm_FindDescr	= 123;
  cm_OptEGA     = 130;
  cm_WinCascade = cmCascade;
  cm_WinTile    = cmTile;
  cm_WinNew     = 142;
  cm_WinClose   = 143;
  cm_WinCloseAll= 144;
  cm_HelpInfo   = 150;
  cm_HelpAbout  = 151;

  hl_FileChDir  = 100;
  hl_FileOpen   = 101;
  hl_FileMerge  = 102;
  hl_FileSave   = 103;

  hc0           = hcNoContext;
  kb0           = kbNoKey;
  kbCtrlA       = $1E01;
  kbCtrlD       = $2004;
  kbCtrlF       = $2106;
  kbCtrlS	= $1F13;

type
  P_StatusLine  = ^T_StatusLine;
  P_MenuBar     = ^T_MenuBar;
  P_UppValidator= ^T_UppValidator;
  P_AbbInfoRec  = ^T_AbbInfoRec;
  P_EditAddDlg  = ^T_EditAddDlg;
  P_EditChgDlg  = ^T_EditChgDlg;
  P_EditDelDlg  = ^T_EditDelDlg;
  P_FindKeyBuf  = ^T_FindKeyBuf;
  P_FindKeyDlg  = ^T_FindKeyDlg;
  P_FindDataBuf = ^T_FindDataBuf;
  P_FindDataDlg = ^T_FindDataDlg;
  P_AbbList     = ^T_AbbList;
  P_FileWindow  = ^T_FileWindow;
  P_Application = ^T_Application;

  T_LastFind = (lf_None,lf_Key,lf_Data);

  T_CommandSet  = set of Byte;
  T_KeyStr      = String[C_KeyLen];
  T_DataStr     = String[C_DataLen];

  T_MenuBar     = Object(TMenuBar)
    procedure   Draw; virtual;
  end;

  T_StatusLine  = Object(TStatusLine)
    procedure   Draw; virtual;
  end;

  T_UppValidator= Object(TFilterValidator)
    Constructor Init;
    function    IsValidInput(var V_String:String; V_NoFill:boolean):
		  boolean; virtual;
    function    IsValid(const V_String: String): boolean; virtual;
  end;

  T_AbbInfoRec  = record
    IO_Key      : T_KeyStr;
    IO_Data     : T_DataStr;
  end;

  T_EditAddDlg  = Object(TDialog)
    Constructor Init;
  end;

  T_EditChgDlg  = Object(TDialog)
    Constructor Init;
  end;

  T_EditDelDlg  = Object(TDialog)
    Constructor Init(V_Buf: P_AbbInfoRec);
  end;

  T_FindKeyBuf  = record
    IO_Key      : T_KeyStr;
  end;

  T_FindKeyDlg  = Object(TDialog)
    Constructor Init;
  end;

  T_FindDataBuf = record
    IO_Data     : T_DataStr;
  end;

  T_FindDataDlg  = Object(TDialog)
    Constructor Init;
  end;

  T_AbbList     = Object(TStringCollection)
    Constructor Init;
    function    InsertNew(V_Item: Pointer): boolean; virtual;
  end;

  T_FileWindow  = Object(T_ListWindow)
    FileName    : PathStr;
    FindKey     : T_KeyStr;
    FindData    : T_DataStr;
    LastFind	: T_LastFind;
    Changed     : boolean;
    Constructor Init(var V_Rect: TRect);
    Destructor  Done; virtual;
    Constructor Load (var V_Stream: TStream);
    procedure   Store(var V_Stream: TStream);
    procedure   FileInit;
    procedure   FileTerm;
    procedure   SetChanged(V_Changed: boolean);
    function    IsChanged: boolean;
    procedure   ProcessItem (V_Row: integer); virtual;
    function    ReadList(V_Name: PathStr): P_AbbList;
    procedure   MergeList(V_Name: PathStr; V_List: P_AbbList);
    procedure   WriteList(V_Name: PathStr; V_List: P_AbbList);
    function    Valid(V_Command: Word): boolean; virtual;
    procedure   Draw; virtual;
    procedure   HandleEvent(var V_Event: TEvent); virtual;
    procedure   DoFileNew;
    procedure   DoFileOpen;
    procedure   DoFileMerge;
    procedure   DoFileSave;
    procedure   DoFileSaveAs;
    procedure   DoEditChange;
    procedure   DoEditAdd;
    procedure   DoEditDelete;
    procedure   DoFindKey;
    procedure   DoFindData;
    procedure   DoFindAgain;
    procedure   DoFindKeyAgain;
    procedure   DoFindDataAgain;
    procedure   DoFindDupl;
  end;

  T_Application = Object(TApplication)
    ChildCount  : integer;
    Constructor Init;
    Destructor  Done; virtual;
    procedure   InitMenuBar; virtual;
    procedure   InitStatusLine; virtual;
    function    CreateChild: P_FileWindow;
    procedure   SaveDeskTop;
    function    LoadDeskTop: boolean;
    procedure   Draw; virtual;
    procedure   HandleEvent(var V_Event: TEvent); virtual;
    procedure   DoFileNew;
    procedure   DoFileOpen;
    procedure   DoFileSaveAll;
    procedure   DoFileChDir;
    procedure   DoOptEGA;
    procedure   DoWinNew;
    procedure   DoWinCloseAll;
    procedure   DoHelpInfo;
    procedure   DoHelpAbout;
  end;


const
  C_WinCommands  : T_CommandSet =
    [cm_WinCascade, cm_WinTile, cm_WinClose, cm_WinCloseAll,
     cm_FileMerge, cm_FileSave, cm_FileSaveAs, cm_FileSaveAll,
     cm_EditAdd ];

  C_EditCommands : T_CommandSet =
    [cm_EditChange,cm_EditDelete,cm_FindKey,cm_FindDescr,cm_FindAgain,cm_FindDupl];

  R_FileWindow  : TStreamRec = (
    ObjType : OT_ABBREVV_FileWindow;
    VmtLink : Ofs(TypeOf(T_FileWindow)^);
    Load    : @T_FileWindow.Load;
    Store   : @T_FileWindow.Store
  );


var
  PrgName   : NameStr;
  PrgDir    : PathStr;
  SettingDir: PathStr;
  SettingTag: StpTyp;


{ --- General --- }

procedure StreamRegistration;
begin
  RegisterObjects;
  RegisterApp;
  RegisterDialogs;
  RegisterMenus;
  RegisterViews;
  RegisterBPVLIB;
  RegisterType(R_FileWindow);
end;

procedure GetDirs;
var
  PrgPath: PathStr; PrgExt: ExtStr; SRec: SearchRec;
  SettingVar: StpTyp;
begin
  PrgPath:= FExpand(ParamStr(0));
  FSplit(PrgPath,PrgDir,PrgName,PrgExt);
{$IFDEF DEBUG}
  SettingDir:= PrgDir;
{$ELSE}
  SettingVar:= GetEnv(C_Env_Setting);
  if SettingVar = '' then SettingDir:= PrgDir
  else begin
    SettingDir:= FExpand(SettingVar);
    if StpCRet(SettingDir,StpLen(SettingDir)) = '\' then
      StpDel(SettingDir,StpLen(SettingDir),1);
    FindFirst(SettingDir,Directory,SRec);
    if DosError = 0 then StpcCat(SettingDir,'\')
		    else SettingDir:= PrgDir;
  end;
{$ENDIF}
end;

function AbbToString(V_AbbInfo: T_AbbInfoRec): String;
begin with V_AbbInfo do
  AbbToString:= ' '+StfFill(IO_Key,' ',C_KeyLen)+' '+StfRTS(IO_Data);
end;

procedure StringToAbb(V_String: String; var V_AbbInfo: T_AbbInfoRec);
begin with V_AbbInfo do begin
  IO_Key := StfRTS(StfSub(V_String,C_KeyPos ,C_KeyLen ));
  IO_Data:= StfRTS(StfSub(V_String,C_DataPos,C_DataLen));
end; end;


{ --- T_MenuBar --- }

procedure   T_MenuBar.Draw;
var R: TRect;
begin
  inherited Draw;
  GetExtent(R);
  WriteStr(R.B.X-StpLen(PrgName+' '+C_PrgVersion)-1,
	   R.A.Y,       PrgName+' '+C_PrgVersion,1);
end;


{ --- T_StatusLine --- }

procedure   T_StatusLine.Draw;
begin inherited Draw; end;


{ --- T_UppValidator --- }

Constructor T_UppValidator.Init;
begin Inherited Init([' '..'~']); end;

function T_UppValidator.IsValidInput(var V_String:String;
	   V_NoFill: boolean): boolean;
var i,n: byte;
begin
  StpUpp(V_String);
  if (Length(V_String) > 0) and (V_String[1] = ' ') then
    IsValidInput:= false
  else
    IsValidInput:= Inherited IsValidInput(V_String,V_NoFill);
end;

function T_UppValidator.IsValid(const V_String: String): boolean;
begin
  IsValid:= Inherited IsValid(V_String) and (Length(V_String) > 0);
end;


{ --- T_EditAddDlg --- }

Constructor T_EditAddDlg.Init;
var R: TRect; p: PView;
begin
  R.Assign(0,0,75,11);
  Inherited Init(R,'Add'); Options:= Options or ofCentered;

  R.Assign(01,01,74,06); p:= New(PStaticText,Init(R,''));
    p^.Options:= p^.Options or ofFramed; Insert(p);

  R.Assign(02,02,11,03); p:= New(PInputLine,Init(R,C_KeyLen));
    PInputLine(p)^.SetValidator(New(P_UppValidator,Init)); Insert(p);

  R.Assign(02,04,73,05); p:= New(PInputLine,Init(R,C_DataLen));
    PInputLine(p)^.SetValidator(New(P_UppValidator,Init)); Insert(p);

  R.Assign(18,08,28,10);
  Insert(New(PButton,Init(R,'~C~ancel',cmCancel,bfNormal)));

  R.Assign(46,08,56,10);
  Insert(New(PButton,Init(R,'O~K~',cmOK,bfDefault)));

  SelectNext(false);
end;


{ --- T_EditChgDlg --- }

Constructor T_EditChgDlg.Init;
var R: TRect; p: PView;
begin
  R.Assign(0,0,75,11);
  Inherited Init(R,'Change'); Options:= Options or ofCentered;

  R.Assign(01,01,74,06); p:= New(PStaticText,Init(R,''));
    p^.Options:= p^.Options or ofFramed; Insert(p);

  R.Assign(02,02,11,03); p:= New(PInputLine,Init(R,C_KeyLen));
    PInputLine(p)^.SetValidator(New(P_UppValidator,Init)); Insert(p);

  R.Assign(02,04,73,05); p:= New(PInputLine,Init(R,C_DataLen));
    PInputLine(p)^.SetValidator(New(P_UppValidator,Init)); Insert(p);

  R.Assign(18,08,28,10);
  Insert(New(PButton,Init(R,'~C~ancel',cmCancel,bfNormal)));

  R.Assign(46,08,56,10);
  Insert(New(PButton,Init(R,'O~K~',cmOK,bfDefault)));

  SelectNext(false);
end;


{ --- T_EditDelDlg --- }

Constructor T_EditDelDlg.Init(V_Buf: P_AbbInfoRec);
var R: TRect; p: PView;
begin
  R.Assign(0,0,75,11);
  Inherited Init(R,'Delete'); Options:= Options or ofCentered;

  R.Assign(01,01,74,06); p:= New(PStaticText,Init(R,''));
    p^.Options:= p^.Options or ofFramed; Insert(p);

  R.Assign(02,02,12,03);
    Insert(New(PStaticText,Init(R,V_Buf^.IO_Key)));
  R.Assign(02,04,73,05);
    Insert(New(PStaticText,Init(R,V_Buf^.IO_Data)));

  R.Assign(18,08,28,10);
  Insert(New(PButton,Init(R,'~C~ancel',cmCancel,bfNormal)));

  R.Assign(46,08,56,10);
  Insert(New(PButton,Init(R,'O~K~',cmOK,bfDefault)));
end;


{ --- T_FindKeyDlg --- }

Constructor T_FindKeyDlg.Init;
var R: TRect; p: PView;
begin
  R.Assign(0,0,36,08);
  Inherited Init(R,'Find'); Options:= Options or ofCentered;

  R.Assign(15,02,24,03); p:= New(PInputLine,Init(R,C_KeyLen));
    PInputLine(p)^.SetValidator(New(P_UppValidator,Init)); Insert(p);
  R.Assign(02,02,14,03); Insert(New(PLabel,Init(R,'Key to find',p)));

  R.Assign(05,05,15,07);
  Insert(New(PButton,Init(R,'~C~ancel',cmCancel,bfNormal)));

  R.Assign(20,05,30,07);
  Insert(New(PButton,Init(R,'O~K~',cmOK,bfDefault)));

  SelectNext(false);
end;


{ --- T_FindDataDlg --- }

Constructor T_FindDataDlg.Init;
var R: TRect; p: PView;
begin
  R.Assign(0,0,51,08);
  Inherited Init(R,'Find Description'); Options:= Options or ofCentered;

  R.Assign(18,02,48,03); p:= New(PInputLine,Init(R,C_DataLen));
    PInputLine(p)^.SetValidator(New(P_UppValidator,Init)); Insert(p);
  R.Assign(02,02,17,03); Insert(New(PLabel,Init(R,'String to find',p)));

  R.Assign(10,05,20,07);
  Insert(New(PButton,Init(R,'~C~ancel',cmCancel,bfNormal)));

  R.Assign(30,05,40,07);
  Insert(New(PButton,Init(R,'O~K~',cmOK,bfDefault)));

  SelectNext(false);
end;


{ --- T_AbbList --- }

Constructor T_AbbList.Init;
begin Inherited Init(100,50); end;

function    T_AbbList.InsertNew(V_Item: Pointer): boolean;
var i: integer;
begin
  if not Search(KeyOf(V_Item),i) or Duplicates then begin
    AtInsert(i,V_Item);
    InsertNew:= true;
  end
  else InsertNew:= false;
end;


{ --- T_FileWindow --- }

Constructor T_FileWindow.Init(var V_Rect: TRect);
begin
  Inherited Init(V_Rect,'',wnNoNumber,New(P_AbbList,Init));
  Options  := Options or ofTileable;
  FileName := ''; Inc(P_Application(Application)^.ChildCount); FileInit;
end;

Destructor  T_FileWindow.Done;
begin
  FileTerm; Dec(P_Application(Application)^.ChildCount); Inherited Done;
end;

Constructor T_FileWindow.Load(var V_Stream: TStream);
begin
  Inherited Load(V_Stream);
  V_Stream.Read(FileName,SizeOf(FileName));
  if FileName = '' then NewList(New(P_AbbList,Init))
		   else NewList(ReadList(FileName));
  Inc(P_Application(Application)^.ChildCount);
  FileInit;
end;

procedure   T_FileWindow.Store(var V_Stream: TStream);
begin
  NewList(nil);
  Inherited Store(V_Stream);
  V_Stream.Write(FileName,SizeOf(FileName));
end;

procedure   T_FileWindow.FileInit;
begin
  FindKey:= ''; FindData:= ''; LastFind:= lf_None; Changed:= false;
  NewTitle(FileName); DrawView;
end;

procedure   T_FileWindow.FileTerm;
begin FileName:= ''; NewList(New(P_AbbList,Init)); FileInit; end;

procedure   T_FileWindow.SetChanged(V_Changed: boolean);
begin if V_Changed <> Changed then begin
  Changed:= V_Changed;
  if Changed then NewTitle('<'+FileName+'>') else NewTitle(FileName);
end; end;

function    T_FileWindow.IsChanged: boolean;
begin IsChanged:= Changed; end;

procedure   T_FileWindow.ProcessItem (V_Row: integer);
begin DoEditChange; end;

function    T_FileWindow.ReadList(V_Name: PathStr): P_AbbList;
var p: P_AbbList;
begin
  p:= New(P_AbbList,Init);
  MergeList(V_Name,p);
  ReadList:= p;
end;

procedure   T_FileWindow.MergeList(V_Name: PathStr; V_List: P_AbbList);
var F: Text; Line: String; ok: boolean; s: PString;
  procedure ErrMsg(V_Msg: String);
  begin
    MessageBox(#3+V_Msg+#13#13#3+V_Name,nil,mfError or mfOKButton);
  end;
begin {T_FileWindow.MergeList}
  Assign(F,V_Name); {$I-} Reset(F); {$I+}
  if IOResult = 0 then begin
    ok:= true;
    while ok and not eof(F) do begin
      {$I-} readln(F,Line); {$I+}
      if IOResult = 0 then begin
	s:= NewStr(Line);
	if not V_List^.InsertNew(s) then DisposeStr(s);
      end
      else begin ok:= false; ErrMsg('Error reading file'); end;
    end;
    System.Close(F);
  end;
end;

procedure   T_FileWindow.WriteList(V_Name:PathStr; V_List:P_AbbList);
var F: Text; Line: String; ok: boolean;
  procedure ErrMsg(V_Msg: String);
  begin
    MessageBox(#3+V_Msg+#13#13#3+V_Name,nil,mfError or mfOKButton);
  end;
  procedure WriteItem(V_Item: Pointer); far;
  begin if ok then begin
    {$I-} Writeln(F,PString(V_Item)^); {$I+}
    ok:= IOResult = 0;
  end; end;
begin {T_FileWindow.WriteList}
  Assign(F,V_Name); {$I-} Rewrite(F); {$I+}
  if IOResult <> 0 then ErrMsg('Open error')
  else begin
    ok:= true; V_List^.ForEach(@WriteItem);
    if ok then SetChanged(false) else ErrMsg('Write error');
    System.Close(F);
  end;
end;

function    T_FileWindow.Valid(V_Command: Word): boolean;
var NameParm: PString; IsOK: boolean;
begin
  IsOK:= true;
  case V_Command of cmClose, cmQuit: if IsChanged then begin
    NameParm:= @FileName;
    case MessageBox(#3'Save changes?'#13#13#3'%s',@NameParm,
      mfWarning or mfYesNoCancel) of
      cmDefault,
      cmYes   : begin DoFileSave; IsOK:= not IsChanged; end;
      cmNo    : IsOK:= true;
      cmCancel: IsOK:= false;
      cmOK    : IsOK:= true;
    end;
  end; end;
  Valid:= IsOK and Inherited Valid(V_Command);
end;

procedure   T_FileWindow.Draw;
begin
  if (List=nil) or (List^.Count = 0) then
    DisableCommands(C_EditCommands)
  else begin
    EnableCommands(C_EditCommands);
    if List^.Count = 1    then DisableCommands([cm_FindDupl]);
    if LastFind = lf_None then DisableCommands([cm_FindAgain]);
  end;
  StatusLine^.Draw;
  Inherited Draw;
end;

procedure   T_FileWindow.HandleEvent(var V_Event: TEvent);
  procedure Clear; begin ClearEvent(V_Event); end;
begin {T_FileWindow.HandleEvent}
  with V_Event do case What of
    evKeyDown  : case Command of
      kbHome   : Command:= kbCtrlPgUp;
      kbEnd    : Command:= kbCtrlPgDn;
    end;
  end;
  Inherited HandleEvent(V_Event);
  with V_Event do case What of
    evCommand  : case Command of
      cm_FileNew     : begin DoFileNew     ; Clear; end;
      cm_FileOpen    : begin DoFileOpen    ; Clear; end;
      cm_FileMerge   : begin DoFileMerge   ; Clear; end;
      cm_FileSave    : begin DoFileSave    ; Clear; end;
      cm_FileSaveAs  : begin DoFileSaveAs  ; Clear; end;
      cm_EditAdd     : begin DoEditAdd     ; Clear; end;
      cm_EditChange  : begin DoEditChange  ; Clear; end;
      cm_EditDelete  : begin DoEditDelete  ; Clear; end;
      cm_FindKey     : begin DoFindKey     ; Clear; end;
      cm_FindDescr   : begin DoFindData    ; Clear; end;
      cm_FindAgain   : begin DoFindAgain   ; Clear; end;
      cm_FindDupl    : begin DoFindDupl    ; Clear; end;
    end;
    evBroadCast: case Command of
      cm_FileSave    : DoFileSave;
      cm_WinClose    : Close;
    end;
  end;
end;

procedure   T_FileWindow.DoFileNew;
begin if Valid(cmClose) then FileTerm; end;

procedure   T_FileWindow.DoFileOpen;
var Name: PathStr;
begin if Valid(cmClose) then begin
  Name:= C_DflOpenMask;
  if Application^.ExecuteDialog(New(PFileDialog,Init(C_DflOpenMask,
       'File Open','~F~ile name',fdOKButton or fdNoLoadDir,
       hl_FileOpen)),@Name) <> cmCancel
  then begin
    FileTerm; FileName:= Name; NewList(ReadList(FileName)); FileInit;
  end;
end; end;

procedure   T_FileWindow.DoFileMerge;
var Name: PathStr; OldCount: integer;
begin
  Name:= C_DflOpenMask;
  if Application^.ExecuteDialog(New(PFileDialog,Init(C_DflOpenMask,
       'File Merge','~F~ile name',fdOKButton or fdNoLoadDir,
       hl_FileMerge)),@Name) <> cmCancel
  then begin
    OldCount:= List^.Count;
    MergeList(Name,P_AbbList(List));
    if List^.Count > OldCount then begin
      SetChanged(true);
      DrawView;
    end;
  end;
end;

procedure   T_FileWindow.DoFileSave;
begin if (List <> nil) and (List^.Count > 0) then begin
  if (FileName='') then DoFileSaveAs
  else begin
    WriteList(FileName,P_AbbList(List));
    DrawView;
  end;
end; end;

procedure   T_FileWindow.DoFileSaveAs;
var Name: PathStr;
begin if (List <> nil) and (List^.Count > 0) then begin
  Name:= FileName;
  if Application^.ExecuteDialog(New(PFileDialog,Init(C_DflSaveMask,
       'File Save As','~F~ile name',fdOKButton or fdNoLoadDir,
       hl_FileSave)),@Name) <> cmCancel
  then begin
    FileName:= Name; WriteList(FileName,P_AbbList(List)); FileInit;
  end;
end; end;

procedure   T_FileWindow.DoEditAdd;
var Buf: T_AbbInfoRec; S: String; PS: Pstring; i: integer;
begin if List <> nil then begin
  StringToAbb('',Buf);
  if Application^.ExecuteDialog(New(P_EditAddDlg,Init),@Buf)
    <> cmCancel
  then with Buf do begin
    S:= AbbToString(Buf); PS:= NewStr(S);
    if not P_AbbList(List)^.InsertNew(PS) then DisposeStr(PS);
    SetMaxRow(List^.Count-1);
    if P_AbbList(List)^.Search(@S,i) then SetCurRow(i)
                                     else SetCurRow(0);
    SetChanged(true); DrawView;
  end;
end; end;

procedure   T_FileWindow.DoEditChange;
var Buf: T_AbbInfoRec; S0,S: String; PS: Pstring; i: integer;
begin if (List <> nil) and (List^.Count > 0) then begin
  S0:= PString(List^.At(CurRow))^;
  StringToAbb(S0,Buf);
  if Application^.ExecuteDialog(New(P_EditChgDlg,Init),@Buf)
    <> cmCancel
  then with Buf do begin
    S:= AbbToString(Buf);
    if S <> S0 then begin
      DisposeStr(PString(List^.At(CurRow)));
      P_AbbList(List)^.AtDelete(CurRow);
      PS:= NewStr(S);
      if not P_AbbList(List)^.InsertNew(PS) then DisposeStr(PS);
      SetMaxRow(List^.Count-1);
      if P_AbbList(List)^.Search(@S,i) then SetCurRow(i)
                                       else SetCurRow(0);
      SetChanged(true); DrawView;
    end;
  end;
end; end;

procedure   T_FileWindow.DoEditDelete;
var Buf: T_AbbInfoRec; S: String; i: integer;
begin if (List <> nil) and (List^.Count > 0) then begin
  StringToAbb(PString(List^.At(CurRow))^,Buf);
  if Application^.ExecuteDialog(New(P_EditDelDlg,Init(@Buf)),nil)
    <> cmCancel
  then begin
    DisposeStr(PString(List^.At(CurRow)));
    P_AbbList(List)^.AtDelete(CurRow);
    SetMaxRow(List^.Count-1);
    SetChanged(true); DrawView;
  end;
end; end;

procedure   T_FileWindow.DoFindKey;
var Buf: T_FindKeyBuf; S: String; i: integer;
begin if (List <> nil) and (List^.Count > 0) then begin
  with Buf do begin IO_Key := ''; end;
  if Application^.ExecuteDialog(New(P_FindKeyDlg,Init),@Buf) <> cmCancel
  then begin
    FindKey:= Buf.IO_Key;
    S:= ' ' + FindKey; P_AbbList(List)^.Search(@S,i);
    SetCurRow(i); DrawView;
    LastFind:= lf_Key;
  end;
end; end;

procedure   T_FileWindow.DoFindData;
var Buf: T_FindDataBuf; S: String; i: integer;
begin if (List <> nil) and (List^.Count > 0) then begin
  with Buf do begin IO_Data := ''; end;
  if Application^.ExecuteDialog(New(P_FindDataDlg,Init),@Buf) <> cmCancel
  then begin
    FindData:= Buf.IO_Data;
    LastFind:= lf_Data;
    DoFindDataAgain;
  end;
end; end;

procedure   T_FileWindow.DoFindAgain;
begin case LastFind of
  lf_None: {do nothing} ;
  lf_Key : DoFindKeyAgain;
  lf_Data: DoFindDataAgain;
end end;


procedure   T_FileWindow.DoFindKeyAgain;
var CurKey: T_KeyStr; Found: boolean; i: integer; FindParam: PString;
begin
  if (List<>nil) and (List^.Count>0) and (FindKey<>'') then begin
    Found:= false; i:= CurRow;
    while (not Found) and (i < List^.Count-1) do begin
      Inc(i);
      Found:= Pos(FindKey,Copy(PString(List^.At(i))^,
                C_KeyPos,C_KeyLen))=1;
    end;
    if Found then begin SetCurRow(i); DrawView; end
    else begin
      FindParam:= @FindKey;
      MessageBox(
        #3'No entries matching "%s" found starting at current row',
	@FindParam,mfInformation or mfOKButton);
    end;
  end;
end;

procedure   T_FileWindow.DoFindDataAgain;
var CurData: T_DataStr; Found: boolean; i: integer; FindParam: PString;
begin
  if (List<>nil) and (List^.Count>0) and (FindData<>'') then begin
    Found:= false; i:= CurRow;
    while (not Found) and (i < List^.Count-1) do begin
      Inc(i);
      Found:= Pos(FindData,Copy(PString(List^.At(i))^,
		C_DataPos,C_DataLen))>0;
    end;
    if Found then begin SetCurRow(i); DrawView; end
    else begin
      FindParam:= @FindData;
      MessageBox(
	#3'No descriptions containing "%s" found starting at current row',
	@FindParam,mfInformation or mfOKButton);
    end;
  end;
end;

procedure   T_FileWindow.DoFindDupl;
var CurKey, PrvKey: T_KeyStr; Found: boolean; i: integer;
begin if (List <> nil) and (List^.Count > 1) then begin
  Found:= false; i:= CurRow;
  PrvKey:= Copy(PString(List^.At(i))^,C_KeyPos,C_KeyLen);
  while (not Found) and (i < List^.Count-1) do begin
    Inc(i);
    CurKey:= Copy(PString(List^.At(i))^,C_KeyPos,C_KeyLen);
    if CurKey=PrvKey then Found:= true else PrvKey:= CurKey;
  end;
  if Found then begin SetCurRow(i); DrawView; end
  else MessageBox(
    #3'No duplicate keys found starting at current row',nil,
    mfInformation or mfOKButton
  );
end; end;



{ --- T_Application --- }

Constructor T_Application.Init;
var R: TRect;
begin
  GetDirs; StreamRegistration;
  SettingTag:= PrgName+' '+C_PrgVersion+' settings'#26;
  Inherited Init;
  if not LoadDeskTop then begin
    DeskTop^.TileColumnsFirst:= C_ColsFirst;
    ChildCount:= 0;
    DoFileNew;
  end;
end;

Destructor T_Application.Done;
begin
  SaveDeskTop;
  Inherited Done;
end;

function    T_Application.LoadDeskTop: boolean;
var
  Stream        : TBufStream;
  InpDeskTop    : PDeskTop;
  InpSettingTag : StpTyp;
  R             : TRect;
  ok            : boolean;
begin
  ok:= false;
{$IFDEF AUTOSAVE}
  Stream.Init(SettingDir+PrgName+C_SettingExt,stOpenRead,1024);
  Stream.Read(InpSettingTag,StpLen(SettingTag)+1);
  InpDeskTop:= PDeskTop(Stream.Get);
  Stream.Done;
  if (Stream.Status = StOK)         and
     (InpSettingTag = SettingTag)   and
     (ValidView(InpDeskTop) <> nil)
  then begin
    Delete(DeskTop); Dispose(DeskTop,Done);
    DeskTop:= InpDeskTop; Insert(DeskTop);
    GetExtent(R); R.Grow(0,-1); DeskTop^.Locate(R);
    ok:= true;
  end;
{$ENDIF}
  LoadDeskTop:= ok;
end;

procedure   T_Application.SaveDeskTop;
var Stream: TBufStream;
begin
{$IFDEF AUTOSAVE}
  Stream.Init(SettingDir+PrgName+C_SettingExt,stCreate,1024);
  Stream.Write(SettingTag,StpLen(SettingTag)+1);
  Stream.Put(DeskTop);
  Stream.Done;
  if Stream.Status <> StOK then begin
    MessageBox(
      #3'Unable to save current settings'#13+
      #3+SettingDir+PrgName+C_SettingExt,
      nil,mfError or mfOKButton);
  end;
{$ENDIF}
end;

procedure   T_Application.InitMenuBar;
var R: TRect;
begin
  GetExtent(R); R.B.Y:= R.A.Y+1;
  MenuBar:= New(P_MenuBar,Init(R,NewMenu(
    NewSubMenu('~F~ile'        ,hc0, NewMenu(
      NewItem('~N~ew'          ,''      ,kb0    ,cm_FileNew     ,hc0,
      NewItem('~O~pen...'      ,'F3'    ,kbF3   ,cm_FileOpen    ,hc0,
      NewItem('~M~erge...'     ,''      ,kb0    ,cm_FileMerge   ,hc0,
      NewItem('~S~ave'         ,'F2'    ,kbF2   ,cm_FileSave    ,hc0,
      NewItem('Save ~a~s...'   ,''      ,kb0    ,cm_FileSaveAs  ,hc0,
      NewItem('Save a~l~l'     ,''      ,kb0    ,cm_FileSaveAll ,hc0,
      NewLine(
      NewItem('~C~hange dir'   ,''      ,kb0    ,cm_FileChDir   ,hc0,
      NewItem('~D~OS shell'    ,''      ,kb0    ,cm_FileDos     ,hc0,
      NewItem('E~x~it'         ,'Alt+X' ,kbAltX ,cm_FileExit    ,hc0,
    nil))))))))))),
    NewSubMenu('~E~dit'        ,hc0, NewMenu(
      NewItem('~A~dd'          ,'Ins'   ,kbIns  ,cm_EditAdd     ,hc0,
      NewItem('~C~hange'       ,'Enter' ,kbEnter,cm_EditChange  ,hc0,
      NewItem('~D~elete'       ,'Del'   ,kbDel  ,cm_EditDelete  ,hc0,
    nil)))),
    NewSubMenu('~S~earch'      ,hc0, NewMenu(
      NewItem('~F~ind Key...'  ,'Ctrl+F',kbCtrlF,cm_FindKey     ,hc0,
      NewItem('Find De~s~cription...','Ctrl+S',kbCtrlS,cm_FindDescr,hc0,
      NewItem('Find ~A~gain'   ,'Ctrl+A',kbCtrlA,cm_FindAgain   ,hc0,
      NewItem('~D~uplicates'   ,'Ctrl+D',kbCtrlD,cm_FindDupl    ,hc0,
    nil))))),
    NewSubMenu('~O~ptions'     ,hc0, NewMenu(
      NewItem('~E~GA lines'    ,''      ,kb0    ,cm_OptEGA      ,hc0,
    nil)),
    NewSubMenu('~W~indow'      ,hc0, NewMenu(
      NewItem('~C~ascade'      ,''      ,kb0    ,cm_WinCascade  ,hc0,
      NewItem('~T~ile'         ,''      ,kb0    ,cm_WinTile     ,hc0,
      NewItem('Cl~o~se all'    ,''      ,kb0    ,cm_WinCloseAll ,hc0,
      NewLine(
      NewItem('~N~ew window'   ,''      ,kb0    ,cm_WinNew      ,hc0,
    nil)))))),
    NewSubMenu('~H~elp'        ,hc0, NewMenu(
      NewItem('~I~nfo'         ,'F1'    ,kbF1   ,cm_HelpInfo    ,hc0,
      NewItem('~A~bout'        ,''      ,kb0    ,cm_HelpAbout   ,hc0,
    nil))),
  nil)))))))));
end;

procedure   T_Application.InitStatusLine;
var R: TRect;
begin
  GetExtent(R); R.A.Y:= R.B.Y-1;
  StatusLine:= New(P_StatusLine,Init(R,
    NewStatusDef($0000,$FFFF,
      NewStatusKey('~F1~ Help'          ,kbF1    ,cm_HelpInfo,
      NewStatusKey('~F2~ Save'          ,kbF2    ,cm_FileSave,
      NewStatusKey('~F3~ Open'          ,kbF3    ,cm_FileOpen,
      NewStatusKey('~Ctrl+F~ Find'      ,kbCtrlF ,cm_FindKey,
      NewStatusKey('~Ctrl+A~ Again'     ,kbCtrlA ,cm_FindAgain,
      NewStatusKey('~Ctrl+D~ Dupl'      ,kbCtrlD ,cm_FindDupl,
      NewStatusKey('~Alt+X~ Exit'       ,kbAltX  ,cm_FileExit,
      StdStatusKeys(
    nil)))))))),
  nil)));
end;

function    T_Application.CreateChild: P_FileWindow;
var R: TRect; p: P_FileWindow;
begin
  GetTileRect(R);
  p:= P_FileWindow(InsertWindow(New(P_FileWindow,Init(R))));
  if p <> nil then Cascade;
  CreateChild:= p;
end;

procedure   T_Application.Draw;
begin
  if ChildCount > 0 then
    EnableCommands(C_WinCommands)
  else
    DisableCommands(C_WinCommands + C_EditCommands);
  Inherited Draw;
end;

procedure   T_Application.HandleEvent(var V_Event: TEvent);
  procedure Clear; begin ClearEvent(V_Event); end;
begin {T_Application.HandleEvent}
  Inherited HandleEvent(V_Event);
  with V_Event do case What of
    evCommand: case Command of
      cm_FileNew    : begin DoFileNew    ; Clear; end;
      cm_FileOpen   : begin DoFileOpen   ; Clear; end;
      cm_FileSaveAll: begin DoFileSaveAll; Clear; end;
      cm_FileChDir  : begin DoFileChDir  ; Clear; end;
      cm_OptEGA     : begin DoOptEGA     ; Clear; end;
      cm_WinCloseAll: begin DoWinCloseAll; Clear; end;
      cm_WinNew     : begin DoWinNew     ; Clear; end;
      cm_HelpInfo   : begin DoHelpInfo   ; Clear; end;
      cm_HelpAbout  : begin DoHelpAbout  ; Clear; end;
    end;
  end;
end;

procedure   T_Application.DoFileNew; begin CreateChild; end;

procedure   T_Application.DoFileOpen;
var p: P_FileWindow;
begin p:= CreateChild; if p<>nil then p^.DoFileOpen; end;

procedure   T_Application.DoFileSaveAll;
begin Message(DeskTop,evBroadCast,cm_FileSave,nil); end;

procedure   T_Application.DoFileChDir;
begin
  ExecuteDialog(New(PChDirDialog, Init(cdNormal,hl_FileChDir)),nil);
end;

procedure   T_Application.DoOptEGA;
begin SetScreenMode(ScreenMode xor smFont8x8); end;

procedure   T_Application.DoWinCloseAll;
begin Message(DeskTop,evBroadCast,cm_WinClose,nil); end;

procedure   T_Application.DoWinNew; begin CreateChild; end;

procedure   T_Application.DoHelpInfo;
begin
  MessageBox(
   #3'View and maintain a list of abbrevations',
   nil,mfInformation or mfOKButton);
end;

procedure   T_Application.DoHelpAbout;
var R: TRect;
begin
  R.Assign(20,5,60,17);
  MessageBoxRect(R,
   #3+PrgName+' '+C_PrgVersion+#13+
   #3'Borland Pascal + Turbo Vision'#13#13+
   #3+C_CopyRight+#13+
   #3+C_AuthEmail+#13+
   #3+C_AuthURL,
   nil,mfInformation or mfOKButton);
end;


{ --- Main program --- }

begin
  Application:= New(P_Application,Init);
  Application^.Run;
  Dispose(Application,Done);
end.
