; *******************************************************
; *                                                     *
; *     Turbo Pascal Runtime Library Version 6.0/7.0    *
; *     x87 Hardware Emulator                           *
; *                                                     *
; *     Copyright (C) 2000-2002 Robert AH Prins         *
; *                                                     *
; *******************************************************

        TITLE   EM87

        INCLUDE SE.ASM

  ifndef x8087

        .386
        .387

  else

        .86
        .87

  endif

  if DPMIVersion

        EXTRN   __AHIncr:ABS

  endif

CODE    SEGMENT BYTE PUBLIC USE16
        ASSUME  CS:CODE

        PUBLIC  E087_ENTRY
        PUBLIC  E087_SHORTCUT

pi_4:   dt      03ffec90fdaa22168c235r
pi_2:   dt      03fffc90fdaa22168c235r
_1_2:   dd      03f000000h
_nan_1: dd      0ffc04200h
_nan_2: dd      0ffc04800h
_nan_3: dd      0ffc04A00h
_inf:   dd      07f800000h
sqrt_2: dt      03fffb504f333f9de6485r

;-------------------------------------------------------------------------------
; Shortcut code 0xEE
;
; Cosine shortcut routine - replace by FCOS in F87H.ASM
;-------------------------------------------------------------------------------
_cos:   mov     cl, 2
        jmp     @@01

;-------------------------------------------------------------------------------
; Shortcut code 0xEC
;
; Sine shortcut routine - replace by FSIN in F87H.ASM
;-------------------------------------------------------------------------------
_sin:   mov     cl, 0

@@01:   fxam
        push    bp
        mov     bp, sp
        lea     sp, [bp - 2]
        fstsw   word ptr [bp - 2]
        wait
        mov     ah, [bp - 1]
        sahf
        jc      @@02

        jnz     @@05

        cmp     cl, 2
        jne     @@04

        fstp    st(0)
        fld1
        jmp     @@04

@@02:   jz      @@04

        jnp     @@04

        fstp    st(0)
        fld     dword ptr cs:_nan_1
        ftst
        jmp     @@04

@@03:   fcompp
        fld     dword ptr cs:_nan_1
        ftst

@@04:   mov     sp, bp
        pop     bp
        ret

@@05:   fabs
        fld     tbyte ptr cs:pi_4
        fxch    st(1)
        fprem
        mov     ch, 2
        and     ch, ah
        shr     ch, 1
        fstsw   word ptr [bp - 2]
        wait
        mov     ah, [bp - 1]
        sahf
        jp      @@03

        mov     al, 3
        and     al, ah
        shl     ah, 2
        rcl     al, 1
        add     al, 0FCh
        rcl     al, 1
        cmp     cl, 2
        jne     @@06

        add     al, cl
        mov     ch, 0

@@06:   and     al, 07h
        test    al, 01h
        jz      @@07

        fsubp   st(1), st
        jmp     @@08

@@07:   fstp    st(1)

@@08:   fptan
        cmp     cl, 4
        jz      @@11

        test    al, 03h
        jp      @@09

        fxch    st(1)

@@09:   fld     st(1)
        fmul    st, st(0)
        fxch    st(1)
        fmul    st, st(0)
        faddp   st(1), st
        fsqrt
        shr     al, 2
        xor     al, ch
        jz      @@10

        fchs

@@10:   fdivp   st(1), st
        jmp     @@04

@@11:   mov     ah, al
        shr     ah, 1
        and     ah, 01h
        xor     ah, ch
        jz      @@12

        fchs

@@12:   test    al, 03h
        jp      @@13

        fxch    st(1)
        ftst
        fstsw   word ptr [bp - 2]
        wait
        test    byte ptr [bp - 1], 40h
        jz      @@13

        fcompp
        fld     dword ptr cs:_inf
        jmp     @@04

@@13:   fdivp   st(1), st
        jmp     @@04

;-------------------------------------------------------------------------------
; Shortcut code 0xF2
;
; Arctan shortcut routine - replace by FPATAN in F87H.ASM
;-------------------------------------------------------------------------------
_arctan:fxam
        push    bp
        mov     bp, sp
        lea     sp, [bp - 2]
        fstsw   word ptr [bp - 2]
        wait
        mov     ah, [bp - 1]
        sahf
        xchg    ax, cx
        jc      @@14

        jnz     @@16

        jmp     @@19

@@14:   jz      @@19

        jnp     @@19

        fstp    st(0)
        fld     tbyte ptr cs:pi_2
        jmp     @@18

@@15:   fcompp
        fld     tbyte ptr cs:pi_4
        jmp     @@18

@@16:   fabs
        fld1
        fcom    st(1)
        fstsw   word ptr [bp - 2]
        wait
        mov     ah, [bp - 1]
        sahf
        jz      @@15

        jnc     @@17

        fxch    st(1)

@@17:   fpatan
        jnc     @@18

        fld     tbyte ptr cs:pi_2
        fsubp   st(1), st
        xor     ch, 02h

@@18:   test    ch, 02h
        jz      @@19

        fchs

@@19:   mov     sp, bp
        pop     bp
        ret

;-------------------------------------------------------------------------------
; Shortcut code 0xF4
;
; Ln shortcut routine - move into F87H.ASM?
;
; Morten Welinder's (terra@diku.dk) SPO120.EXE uses fldln2/fxch/fyl2x
;-------------------------------------------------------------------------------
_ln:    fldln2

@@20:   fxch    st(1)
        push    bp
        mov     bp, sp
        fxam
        lea     sp, [bp - 10]
        fstsw   word ptr [bp - 10]
        wait
        mov     ah, [bp - 9]
        sahf
        jc      @@22

        jz      @@21

        test    ah, 02h
        jz      @@25

@@21:   fstp    st(0)
        jmp     @@23

@@22:   fstp    st(0)                   ; added in BP7
        jz      @@24

        jnp     @@24

@@23:   fstp    st(0)
        fld     dword ptr cs:_nan_2

@@24:   ftst
        jmp     @@27

@@25:   fld     st(0)
        fstp    tbyte ptr [bp - 10]
        wait

        cmp     word ptr [bp - 2], 3FFFh
        jne     @@26

        cmp     word ptr [bp - 4], 8000h
        jne     @@26

        fld1
        fsubp   st(1), st
        fyl2xp1
        jmp     @@27

@@26:   fyl2x

@@27:   mov     sp, bp
        pop     bp
        ret

;-------------------------------------------------------------------------------
; Shortcut code 0xFA
;
; Exp (e**x) shortcut routine - move into F87H.ASM?
;-------------------------------------------------------------------------------
_exp:   fldl2e
        mov     cl, 1

@@28:   fxch    st(1)

@@29:   fxam
        push    bp
        mov     bp, sp
        lea     sp, [bp - 6]
        fstsw   word ptr [bp - 6]
        jcxz    @@30                    ; not...

        fxch    st(1)

@@30:   wait
        mov     ah, [bp - 5]
        sahf
        xchg    ax, bx
        jc      @@32

        jnz     @@36

        fstp    st(0)
        jcxz    @@31                    ; not...

        fstp    st(0)

@@31:   fld1
        jmp     @@41

@@32:   jcxz    @@33                    ; not...

        fstp    st(0)

@@33:   jz      @@35

        jnp     @@35

@@34:   fstp    st(0)
        fld     dword ptr cs:_nan_3

@@35:   ftst
        jmp     @@41

@@36:   jcxz    @@37                    ; not...

        fmulp   st(1), st

@@37:   fabs
        fcom    dword ptr cs:_1_2
        fstsw   word ptr [bp - 6]
        wait
        test    byte ptr [bp - 5], 41h
        jz      @@38

        f2xm1
        fld1
        faddp   st(1), st
        jmp     @@40

@@38:   fld1
        fld     st(1)
        fstcw   [bp - 6]
        fscale
        or      byte ptr [bp - 5], 0Fh
        fldcw   [bp - 6]
        frndint
        and     byte ptr [bp - 5], 0F3h
        fldcw   [bp - 6]
        fist    dword ptr [bp - 4]
        fxch    st(1)
        fchs
        fxch    st(1)
        fscale
        fstp    st(1)
        fsubp   st(1), st
        cmp     word ptr [bp - 2], 0
        jg      @@34

        f2xm1
        fld1
        faddp   st(1), st
        shr     word ptr [bp - 4], 1
        jnc     @@39

        fld     tbyte ptr cs:sqrt_2
        fmulp   st(1), st

@@39:   fild    word ptr [bp - 4]
        fxch    st(1)
        fscale
        fstp    st(1)

@@40:   test    bh, 02h
        jz      @@41

        fld1
        fdivrp  st(1), st

@@41:   mov     sp, bp
        pop     bp
_nop:   ret

;-------------------------------------------------------------------------------
; E087_ENTRY:
;
; This interrupt routine is used to translate the original, emulated through
; interrupts 34-3E, floating point code into real FPU instructions.
;
; The code below is a slightly modified version of the code in Norbert Juffa's
; replacement libraries, TPL60N19 & BPL70N16. In the original Borland supplied
; SYSTEM.TPU for both TP6 & BP7, the emulator replaces the emulated instructions
; with an FWAIT followed by the real instruction. However, the FWAIT is only
; necessary on the 8087 and Norbert patched the original EM87.OBJ to insert NOPs
; if the code is run on anything over a 8087.
;
; As the 8086/87/88 are nowadays quite dead, the code to detect a 8086/88 has
; been conditionally excluded.
;-------------------------------------------------------------------------------
E087_ENTRY:
        push    bp
        mov     bp, sp
        push    ax
        push    si
        push    ds
        test    byte ptr [bp + 7], 02h  ; ???
        jz      @@42

        sti

  if DPMIVersion

@@42:   mov     si, [bp + 2]
        mov     ax, [bp + 4]
        add     ax, __AHIncr
        mov     ds, ax

  else

@@42:   lds     si, [bp + 2]

  endif

        dec     si
        mov     ax, [si]
        dec     si
        sub     al, 34h
        cmp     al, 09h
        ja      @@45

        jz      @@46

        cmp     al, 8
        jz      @@47

        add     al, 0D8h

@@43:   mov     ah, al
        mov     al, 90h                 ; NOP

  ifdef x8087
        push    sp
        pop     bp
        cmp     sp, bp
        je      @@44

        mov     al, 9Bh                 ; FWAIT
  endif

@@44:   mov     [si], ax
        mov     bp, sp
        mov     [bp + 8], si

@@45:   pop     ds
        pop     si
        pop     ax
        pop     bp
        iret

@@46:   mov     ax, 9B90h               ; NOP + FWAIT
        jmp     @@44

@@47:   test    ah, 20h
        jnz     @@45

        mov     al, ah
        and     ax, 07C0h
        shr     al, 3
        xor     al, 18h
        add     ax, 0D826h
        mov     [si + 2], ah
        jmp     @@43

        INCLUDE ALIGN.ASM

;-------------------------------------------------------------------------------
; From Ralf Brown's Interrupt list:
;
; INT 3E - FLOATING POINT EMULATION - Borland LANGUAGES "SHORTCUT" CALL
; Notes: the two bytes following the INT 3E instruction are the subcode
;        and a NOP (90h), except for subcodes DCh and DEh, where the
;        second byte is a register count (01h-08h)
;
; Values for Borland floating-point shortcut subcode:
;
; Subcode  Function
;
;  0DCh    load 8086 stack with 8087 registers; overwrites the 10*N bytes at the
;            top of the stack prior to the INT 3E with the 8087 register contents
;
;  0DEh    load 8087 registers from top of 8086 stack; ST0 is furthest from top
;            of 8086 stack
;
;  0E0h    round TOS and R1 to single precision, compare, pop twice
;            returns AX=8087 status word, FLAGS=8087 condition bits
;
;  0E2h    round TOS and R1 to double precision, compare, pop twice
;            returns AX=8087 status word, FLAGS=8087 condition bits
;
;          Note: buggy in TPas 5.5 & TPas 6.0, because it sets the 8087
;            precision control field to the undocumented value 01h; this
;            results in actually rounding to single precision
;
;  0E4h    compare TOS/R1 with two POP's
;            returns FLAGS=8087 condition bits
;
;  0E6h    compare TOS/R1 with POP
;            returns FLAGS=8087 condition bits
;
;  0E8h    FTST (check TOS value)
;            returns FLAGS=8087 condition bits
;
;  0EAh    FXAM (check TOS value)
;            returns AX=8087 status word
;
;  0ECh    sine(ST0)
;  0EEh    cosine(ST0)
;  0F0h    tangent(ST0)
;  0F2h    arctangent(ST0)
;  0F4h    ST0 = ln(ST0)
;  0F6h    ST0 = log2(ST0)
;  0F8h    ST0 = log10(ST0)
;  0FAh    ST0 = e**ST0
;  0FCh    ST0 = 2**ST0
;  0FEh    ST0 = 10**ST0
;-------------------------------------------------------------------------------
        dw      CODE:_sin               ; >> can use FSIN in F87H.ASM
        dw      CODE:_cos               ; >> can use FCOS in F87H.ASM
        dw      CODE:_nop               ; not used in SYSTEM.TPU
        dw      CODE:_arctan            ; >> can use FPATAN in F87H.ASM
        dw      CODE:_ln                ; >> make inline code in F87H.ASM
        dw      CODE:_nop               ; not used in SYSTEM.TPU
        dw      CODE:_nop               ; not used in SYSTEM.TPU
        dw      CODE:_exp               ; >> make inline code in F87H.ASM
        dw      CODE:_nop               ; not used in SYSTEM.TPU
        dw      CODE:_nop               ; not used in SYSTEM.TPU

;-------------------------------------------------------------------------------
;
;-------------------------------------------------------------------------------
E087_SHORTCUT:
        sti
        cld
        push    ax
        push    si
        push    es
        push    bp
        mov     bp, sp
        les     si, [bp + 8]
        lods    word ptr es:[si]
        mov     [bp + 8], si
        cmp     al, 0ECh                ; zapped 8 entries?
        jb      @@48                    ; not a valid shortcut

        mov     si, ax
        cbw
        xchg    ax, si
        call    word ptr cs:[si + E087_SHORTCUT]

@@48:   pop     bp
        pop     es
        pop     si
        pop     ax
        iret

        INCLUDE ALIGN.ASM

CODE    ENDS

        END