{********************************************}
{*               EXAMPLE.PAS                *}
{* Sample application using the DOSINI unit *}
{********************************************}

Uses
  DosIni, {<-- Easy INI file manipulation}
  Dos;

Const
  IniFile : String = 'EXAMPLE.INI';
  GrSection : String = 'Graphics';
  SndSection : String = 'Sound';

Var
  No : Integer;
  Day, Month, Year, WeekDay : Word;
  Hour, Minute, Sec, Sec100 : Word;
  S, Date, Time : String;

Begin
  {First extract information from the INI file :}

  {First the setting in the 'Graphics' section...}
  WriteLn('------- Initializing graphics -------');
  Write('Using graphics driver : ');
  WriteLn(GetProfileStr(IniFile,GrSection,'Driver','egavga.bgi'));
  Write('Resolution : ');
  Write(GetProfileInt(IniFile,GrSection,'HorzRes',640));
  Write('x',GetProfileInt(IniFile,GrSection,'VertRes',480));
  WriteLn('x',GetProfileInt(IniFile,GrSection,'Colors',16));

  {Then the settings in the 'Sound' section...}
  WriteLn('-------- Initializing sound ---------');
  Write('Using sound driver : ');
  WriteLn(GetProfileStr(IniFile,SndSection,'Driver','ibm.drv'));

  {And finally the settings in the 'Control' section...}
  WriteLn('------- Initializing controls -------');
  Write('Using joystick : ');
  WriteLn(GetProfileStr(IniFile,'Control','Joystick','No'));
  Write('Using mouse : ');
  WriteLn(GetProfileStr(IniFile,'Control','Mouse','Yes'));
  Write('Using keyboard : ');
  WriteLn(GetProfileStr(IniFile,'Control','Keyboard','No'));
  WriteLn('-------------------------------------'#10#13);

  {Now lets get some user info, and place it in the INI file:}

  {First a new graphic resolution...}
  WriteLn('Select new graphic resolution :');
  WriteLn(' 1) 320x200x16');
  WriteLn(' 2) 320x200x255');
  WriteLn(' 3) 640x480x16');
  WriteLn(' 4) 640x480x255');
  Write('Type 1-4 for selection : ');
  ReadLn(No);
  Case No Of
    1 : Begin
          If WriteProfileStr(IniFile,GrSection,'Driver','egavga.bgi') <> 0 Then
            WriteLn('Error setting new driver');
          If WriteProfileInt(IniFile,GrSection,'HorzRes',320) <> 0 Then
            WriteLn('Error setting initialization data 1');
          If WriteProfileInt(IniFile,GrSection,'VertRes',200) <> 0 Then
            WriteLn('Error setting initialization data 2');
          If WriteProfileInt(IniFile,GrSection,'Colors',16) <> 0 Then
            WriteLn('Error setting initialization data 3');
        End;
    2 : Begin
          If WriteProfileStr(IniFile,GrSection,'Driver','svga.bgi') <> 0 Then
            WriteLn('Error setting new driver');
          If WriteProfileInt(IniFile,GrSection,'HorzRes',320) <> 0 Then
            WriteLn('Error setting initialization data 1');
          If WriteProfileInt(IniFile,GrSection,'VertRes',200) <> 0 Then
            WriteLn('Error setting initialization data 2');
          If WriteProfileInt(IniFile,GrSection,'Colors',255) <> 0 Then
            WriteLn('Error setting initialization data 3');
        End;
    3 : Begin
          If WriteProfileStr(IniFile,GrSection,'Driver','egavga.bgi') <> 0 Then
            WriteLn('Error setting new driver');
          If WriteProfileInt(IniFile,GrSection,'HorzRes',640) <> 0 Then
            WriteLn('Error setting initialization data 1');
          If WriteProfileInt(IniFile,GrSection,'VertRes',480) <> 0 Then
            WriteLn('Error setting initialization data 2');
          If WriteProfileInt(IniFile,GrSection,'Colors',16) <> 0 Then
            WriteLn('Error setting initialization data 3');
        End;
    4 : Begin
          If WriteProfileStr(IniFile,GrSection,'Driver','svga.bgi') <> 0 Then
            WriteLn('Error setting new driver');
          If WriteProfileInt(IniFile,GrSection,'HorzRes',640) <> 0 Then
            WriteLn('Error setting initialization data 1');
          If WriteProfileInt(IniFile,GrSection,'VertRes',480) <> 0 Then
            WriteLn('Error setting initialization data 2');
          If WriteProfileInt(IniFile,GrSection,'Colors',255) <> 0 Then
            WriteLn('Error setting initialization data 3');
        End;
  End;

  {Then a new sound'driver...}
  WriteLn(#10#13'Select sound device :');
  WriteLn(' 1) Sound Blaster');
  WriteLn(' 2) Adlib Gold');
  WriteLn(' 3) PC speaker');
  Write('Type 1-3 for selection : ');
  ReadLn(No);
  Case No Of
    1 : If WriteProfileStr(IniFile,SndSection,'Driver','sblast.drv') <> 0 Then
          WriteLn('Error setting driver info');
    2 : If WriteProfileStr(IniFile,SndSection,'Driver','adlib.drv') <> 0 Then
          WriteLn('Error setting driver info');
    3 : If WriteProfileStr(IniFile,SndSection,'Driver','ibm.drv') <> 0 Then
          WriteLn('Error setting driver info');
  End;

  {Now, let's add a new section to the INI file...}
  GetDate(Year,Month,Day,WeekDay);
  Str(Day,S);
  Date := S;
  Str(Month,S);
  Date := Date + '/'+S;
  Str(Year,S);
  Date := Date + '/'+S;
  If WriteProfileStr(IniFile,'Modified','Date',Date) <> 0 Then
    WriteLn('Error writing date');

  GetTime(Hour,Minute,Sec,Sec100);
  Str(Hour,S);
  Time := s;
  Str(Minute,S);
  Time := Time + ':'+ S;
  Str(Sec,S);
  Time := Time + ':' + S;
  If WriteProfileStr(IniFile,'Modified','Time',Time) <> 0 Then
    WriteLn('Error writing time');
End.