{***************************************************************************}
{                                                                           }
{  File: BPR.PAS                                                            }
{  Word list object (Borland Pascal 7.0 Auto corrector)                     }
{                                                                           }
{  Copyright (c) 1994                                                       }
{     Alexander Petrosyan (General idea+BP reverse engineering+programming) }
{     Slava Gostrenko (Fast subwords searching algorithm)                   }
{                                                                           }
{***************************************************************************}

{$A+,B-,D+,E-,F+,G+,I-,L+,N-,P-,Q-,R-,S-,T-,V-,X+,Y+}

unit
  WRDList;

interface

uses
  Objects;

const
  MinWordLen = 2;
  MaxWordLen = 64;

type
  PWordList = ^TWordList;
  TWordList = object (TStringCollection)
    function Compare (Key1, Key2: Pointer): Integer; virtual;
  end;

function LowCase (C: Char): Char;
function ValidStr (const S: string): Boolean;

implementation

function LowCase;
begin
  if C in ['A'..'Z']
  then LowCase := Char (Byte (C) + Byte (' '))
  else LowCase := C;
end;

function ValidStr;
var
  B: Byte;
begin
  for B := 1 to Length (S) do
    if not (LowCase (S [B]) in ['a'..'z']) then
    begin
      ValidStr := False;
      Exit;
    end;
  ValidStr :=
    (Length (S) >= MinWordLen) and
    (Length (S) <= MaxWordLen);
end;

{ TTWordList }

function TWordList.Compare;
var
  K1, K2: string;
  I: Integer;
begin
  if Length (PString (Key1)^) < Length (PString (Key2)^)
  then
    Compare := +1
  else
    if Length (PString (Key1)^) = Length (PString (Key2)^)
    then
    begin
      K1 [0] := PString (Key1)^ [0];
      for I := 1 to Length (PString (Key1)^) do
        K1 [I] := LowCase (PString (Key1)^ [I]);
      K2 [0] := PString (Key2)^ [0];
      for I := 1 to Length (PString (Key2)^) do
        K2 [I] := LowCase (PString (Key2)^ [I]);
      Compare := inherited Compare (@K1, @K2);
    end
    else
      Compare := -1;
end;

end.
