{ Created : 1991-09-05

Functions and procedures used by the PtGen created application

$Author: Berend_de_Boer $
$Date: 93/05/20 23:00:55 $
$Revision: 1.1 $

Last changes :
93-02-01  Made completely TV2.0 aware
93-03-06  Renamed to PREAPP.PAS
          Internationalized by making use of string resources
93-12-21  Added support for the Clock and HeapViewer from the Gadgets unit in
          /bp/examples/dos/tvdemo
94-06-28  Added support for TVToys when compiler switch TVToys is defined
}

{$I DEFINES.DEF}

{$F+,O+,X+,R-,Q-,S-,V-,D+}
unit PreApp;

interface

uses Objects, Drivers, Views, Menus,
     {$IFDEF Editor}
     Editors,
     {$ENDIF}

     {$IFDEF TVTool}         {* if TVTool is defined in DEFINES.DEF then   *}
     TVApp,                  {* you can only compile PreApp if you have    *}
     {$ENDIF}                {* the shareware TVTool pack of               *}
                             {* Richard Hansen <70242.3367@compuserve.com> *}

     {$IFDEF TVToys}         {* if TVToys is defined in DEFINES.DEF then   *}
     ToyApp,                 {* you can only compile PreApp if you have    *}
     {$ENDIF}                {* the shareware TVToys package of            *}
                             {* Peter Brandstrm <d91-pbr@nada.kth.se>     *}

     {$IFDEF Clock}
     Gadgets,                {* use the clock in /bp/examples/dos/tvdemo   *}
     {$ELSE}
     {$IFDEF HeapViewer}
     Gadgets,                {* use heapviewer in /bp/examples/dos/tvdemo  *}
     {$ENDIF}
     {$ENDIF}

     App;


{$IFDEF Editor}
const
  hcEditor = 2700;
{$ENDIF}

type
  PPreAppStatusLine = ^TPreAppStatusLine;
  TPreAppStatusLine = object(TStatusLine)
    function Hint(AHelpCtx : word) : string;  virtual;
  end;

  PPreApp = ^TPreApp;
{$IFDEF TVTool}
  TPreApp = object(TbxApplication)
{$ELSE}
{$IFDEF TVToys}
  TPreApp = object(TToyApp)
{$ELSE}
  TPreApp = object(TApplication)
{$ENDIF}
{$ENDIF}
{$IFDEF Clock}
    Clock : PClockView;
{$ENDIF}
{$IFDEF HeapViewer}
    Heap : PHeapView;
{$ENDIF}
    constructor Init;
{$IFDEF BufferedPrinter}
    procedure Idle;  virtual;
{$ELSE}
{$IFDEF Clock}
    procedure Idle;  virtual;
{$ELSE}
{$IFDEF HeapViewer}
    procedure Idle;  virtual;
{$ENDIF}
{$ENDIF}
{$ENDIF}
{$IFDEF Help}
{$IFNDEF TVToys}
    procedure GetEvent(var Event : TEvent);  virtual;
{$IFNDEF TVTool}
    function  GetPalette : PPalette;  virtual;
{$ENDIF}
{$ENDIF}
{$ENDIF Help}
    procedure OutOfMemory;  virtual;
  end;

{$IFDEF Help}
{$IFNDEF TVToys}
var
  HFileName : FNameStr;
{$ENDIF}
{$ENDIF}

{$IFDEF Editor}
var
  ClipWindow : PEditWindow;

function OpenEditor(FileName: FNameStr; Visible: Boolean) : PEditWindow;
{$ENDIF}


implementation

uses Dialogs,
     {$IFDEF Editor}
     StdDlg,
     {$ENDIF}
     {$IFDEF Help}
     HelpFile,
     {$ENDIF}
     {$IFDEF BufferedPrinter}
     BufPrinter,
     {$ENDIF}
     Dos, BBFile, BBUtil, BBDlg, BBStrRes;


{$I STRINGS.INC}


function TPreAppStatusLine.Hint(AHelpCtx : word) : string;
begin
  Hint := Strings^.Get(AHelpCtx);
end;


{$IFDEF Editor}
function CreateFindDialog: PDialog;
var
  D: PDialog;
  Control: PView;
  R: TRect;
begin
  R.Assign(0, 0, 38, 12);
  D := New(PDialog, Init(R, rsGet(seFind)));
  with D^ do
  begin
    Options := Options or ofCentered;

    R.Assign(3, 3, 32, 4);
    Control := New(PInputLine, Init(R, 80));
    Insert(Control);
    R.Assign(2, 2, 15, 3);
    Insert(New(PLabel, Init(R, rsGet(seTextToFind), Control)));
    R.Assign(32, 3, 35, 4);
    Insert(New(PHistory, Init(R, PInputLine(Control), 10)));

    R.Assign(3, 5, 35, 7);
    Insert(New(PCheckBoxes, Init(R,
      NewSItem(rsGet(seCase),
      NewSItem(rsGet(seWholeWords), nil)))));

    R.Assign(14, 9, 24, 11);
    Insert(New(PButton, Init(R, 'O~K~', cmOk, bfDefault)));
    Inc(R.A.X, 12); Inc(R.B.X, 12);
    Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));

    SelectNext(False);
  end;
  CreateFindDialog := D;
end;


function CreateReplaceDialog: PDialog;
var
  D: PDialog;
  Control: PView;
  R: TRect;
begin
  R.Assign(0, 0, 40, 16);
  D := New(PDialog, Init(R, rsGet(seReplace)));
  with D^ do
  begin
    Options := Options or ofCentered;

    R.Assign(3, 3, 34, 4);
    Control := New(PInputLine, Init(R, 80));
    Insert(Control);
    R.Assign(2, 2, 15, 3);
    Insert(New(PLabel, Init(R, rsGet(seTextToFind), Control)));
    R.Assign(34, 3, 37, 4);
    Insert(New(PHistory, Init(R, PInputLine(Control), 10)));

    R.Assign(3, 6, 34, 7);
    Control := New(PInputLine, Init(R, 80));
    Insert(Control);
    R.Assign(2, 5, 12, 6);
    Insert(New(PLabel, Init(R, rsGet(seNewText), Control)));
    R.Assign(34, 6, 37, 7);
    Insert(New(PHistory, Init(R, PInputLine(Control), 11)));

    R.Assign(3, 8, 37, 12);
    Insert(New(PCheckBoxes, Init(R,
      NewSItem(rsGet(seCase),
      NewSItem(rsGet(seWholeWords),
      NewSItem(rsGet(sePromptOnReplace),
      NewSItem(rsGet(seReplaceAll), nil)))))));

    R.Assign(17, 13, 27, 15);
    Insert(New(PButton, Init(R, 'O~K~', cmOk, bfDefault)));
    R.Assign(28, 13, 38, 15);
    Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));

    SelectNext(False);
  end;
  CreateReplaceDialog := D;
end;


function DoEditDialog(Dialog: Integer; Info: Pointer): Word; far;
var
  R: TRect;
  T: TPoint;
begin
  case Dialog of
    edOutOfMemory:
      DoEditDialog := MessageBox(rsGet(sMemory),
        nil, mfError + mfOkButton, hcNoContext);
    edReadError:
      DoEditDialog := MessageBox(rsGet(seErrReading),
        @Info, mfError + mfOkButton, hcNoContext);
    edWriteError:
      DoEditDialog := MessageBox(rsGet(seErrWriting),
        @Info, mfError + mfOkButton, hcNoContext);
    edCreateError:
      DoEditDialog := MessageBox(rsGet(seErrCreating),
        @Info, mfError + mfOkButton, hcNoContext);
    edSaveModify:
      DoEditDialog := MessageBox(rsGet(seSave),
        @Info, mfInformation + mfYesNoCancel, hcNoContext);
    edSaveUntitled:
      DoEditDialog := MessageBox(rsGet(seSaveUntitled),
        nil, mfInformation + mfYesNoCancel, hcNoContext);
    edSaveAs:
      DoEditDialog := ExecDialog(New(PFileDialog, Init('*.*',
        rsGet(seSaveAs), rsGet(sName), fdOkButton, 101)), Info);
    edFind:
      DoEditDialog := ExecDialog(CreateFindDialog, Info);
    edSearchFailed:
      DoEditDialog := MessageBox(rsGet(seStringNotFound),
        nil, mfError + mfOkButton, hcNoContext);
    edReplace:
      DoEditDialog := ExecDialog(CreateReplaceDialog, Info);
    edReplacePrompt:
      begin
        { Avoid placing the dialog on the same line as the cursor }
        R.Assign(0, 1, 40, 8);
        R.Move((Desktop^.Size.X - R.B.X) div 2, 0);
        Desktop^.MakeGlobal(R.B, T);
        Inc(T.Y);
        if TPoint(Info).Y <= T.Y then
          R.Move(0, Desktop^.Size.Y - R.B.Y - 2);
        DoEditDialog := MessageBoxRect(R, rsGet(seReplaceThis),
          nil, mfYesNoCancel + mfInformation, hcNoContext);
      end;
  end;
end;


function OpenEditor(FileName: FNameStr; Visible: Boolean): PEditWindow;
var
  P: PView;
  R: TRect;
begin
  DeskTop^.GetExtent(R);
  P := Application^.ValidView(New(PEditWindow,
    Init(R, FileName, wnNoNumber)));
  P^.HelpCtx := hcEditor;
  if not Visible then P^.Hide;
  DeskTop^.Insert(P);
  OpenEditor := PEditWindow(P);
end;
{$ENDIF}

constructor TPreApp.Init;
var
  R : TRect;
begin
  if Strings = nil then  begin
    PrintStr('You should load the resource strings first using BBStrRes.LoadStrings. Program halts.');
    Halt(1);
  end;
  inherited Init;

{$IFDEF Clock}
  GetExtent(R);
  R.A.X := R.B.X - 9; R.B.Y := R.A.Y + 1;
  Clock := New(PClockView, Init(R));
  Insert(Clock);
{$ENDIF}

{$IFDEF HeapViewer}
  GetExtent(R);
  Dec(R.B.X);
  R.A.X := R.B.X - 9; R.A.Y := R.B.Y - 1;
  Heap := New(PHeapView, Init(R));
  Insert(Heap);
{$ENDIF}

{$IFDEF Editor}
  DisableCommands([cmSave, cmSaveAs, cmCut, cmCopy, cmPaste, cmClear,
    cmUndo, cmFind, cmReplace, cmSearchAgain]);
  EditorDialog := DoEditDialog;
  ClipWindow := OpenEditor('', False);
  if ClipWindow <> nil then
  begin
    Clipboard := ClipWindow^.Editor;
    Clipboard^.CanUndo := False;
  end;
{$ENDIF}

end;


{$IFNDEF TVToys}
{$IFDEF Help}
procedure TPreApp.GetEvent(var Event : TEvent);
var
  W : PWindow;
  HFile : PHelpFile;
  HelpStrm : PBufStream;
  D : DirStr;
  N : NameStr;
  E : ExtStr;
  FileName : string;
const
  HelpInUse: Boolean = False;
begin
  inherited GetEvent(Event);
  case Event.What of
    evCommand : if (Event.Command = cmHelp) and not HelpInUse then  begin
        HelpInUse := TRUE;
        FSplit(ParamStr(0), D,N,E);
        FileName := FSearch(HFileName, D+';'+';'+GetEnv('PATH'));
        if FileName = ''
         then  PrintError(rsGet1(sHelpFileNotFound, longint(@HFileName)), hcNoContext)
         else  ShowHelpWindow(FileName, GetHelpCtx);
        ClearEvent(Event);
        HelpInUse := FALSE;
      end;
  end; { of case }
end;

{$IFNDEF TVTool}
{$IFNDEF TVToys}
function TPreApp.GetPalette: PPalette;
const
  CNewColor = CAppColor + CHelpColor;
  CNewBlackWhite = CAppBlackWhite + CHelpBlackWhite;
  CNewMonochrome = CAppMonochrome + CHelpMonochrome;
  P: array[apColor..apMonochrome] of string[Length(CNewColor)] =
    (CNewColor, CNewBlackWhite, CNewMonochrome);
begin
  GetPalette := @P[AppPalette];
end;
{$ENDIF TVToys}
{$ENDIF TVTool}
{$ENDIF Help}
{$ENDIF TVToys}


{$IFDEF BufferedPrinter}
procedure TPreApp.Idle;
begin
  inherited Idle;
  if StandardPrinter <> nil then  StandardPrinter^.PrintFromBuffer;
end;
{$ENDIF}
{$IFDEF Clock}
procedure TPreApp.Idle;
begin
  inherited Idle;
  Clock^.Update;
{$IFDEF HeapViewer}
  Heap^.Update;
{$ENDIF}
end;
{$ELSE}
{$IFDEF HeapViewer}
procedure TPreApp.Idle;
begin
  inherited Idle;
  Heap^.Update;
end;
{$ENDIF}
{$ENDIF}


procedure TPreApp.OutOfMemory;
begin
  PrintError(rsGet(sMemory), hcNoContext);
end;


end.  { of unit PreApp }
