unit Lines;

{$F+,O-,X+,S-}

interface

uses Interf, GePaint, DemoCmds, Objects, App, Views, Drivers;

const
 cmLines=1100;
 X_max=256;
 Y_max=160;

type
  myLine=record x1,y1,x2,y2:Integer; end;
  
  PLines = ^TLines;
  
  TLines = object(TView)
    Rct:Array[0..3] of myLine;
    dx1,dy1,dx2,dy2:integer;
    LinesStart:Integer;
    NextLines:PLines;
    constructor Init(R:Trect);
    procedure GraphRepaint; virtual;
    procedure Draw; virtual;
    destructor Done;virtual;
  end;

  PLinesDemo = ^TLinesDemo;
  TLinesDemo = object(TWindow)
    constructor Init;
  end;

procedure DoLinesUpdates;

implementation


const
   FirstLines:Pointer=Nil;
   CurLines:Integer=0;
   Skip:Integer=0;

var
   TotalLines,WinLines:Integer;

{ Call to DoLinesUpdates is inserted into TTVDEmo.Idle. That is all to
  get animations done. Read READ.ME about Skip and lazy mouse.}
        
procedure DoLinesUpdates;

var
  PC:PLines;
  
begin
   if MouseIntFlag=1 then begin
      MouseIntFlag:=0;
      Skip:=500;
      Exit;
   end;
   if Skip>0 then
      Dec(Skip);   
   if Skip=0 then begin
      PC:=FirstLines;
      while PC<>nil do begin
         PC^.GraphRepaint;
         PC:=PC^.NextLines;
      end;
   end;
end;

procedure ChangeLines(var x,y:Integer;n:Integer);

begin
   x:=x+y;
   if x<=0 then begin
      x:=1;
      y:=-y;
   end else if x>=n then begin
      x:=n-2;
      y:=-y;
   end;        
end;      
        
constructor TLines.Init(R:TRect);
var
 C:word;

begin
 inherited Init(R);
 dx1:=4*(random(9)-4);
 if dx1=0 then 
    dx1:=4;
 dx2:=4*(random(9)-4);
 if dx2=0 then 
    dx2:=-4;
 dy1:=4*(random(9)-4);
 if dy1=0 then 
    dy1:=4;
 dy2:=4*(random(9)-4);
 if dy2=0 then 
    dy2:=4;

 for C:=0 to 3 do begin
    Rct[C].x1:=random(X_max);
    Rct[C].y1:=random(Y_max);
    Rct[C].x2:=random(X_max);
    Rct[C].y2:=random(Y_max);
    ChangeLines(Rct[C].x1,dx1,X_max);
    ChangeLines(Rct[C].y1,dy1,Y_max);
    ChangeLines(Rct[C].x2,dx2,X_max);
    ChangeLines(Rct[C].y2,dy2,Y_max);
 end; 
 LinesStart:=CurLines;
 if LinesStart>=TotalLines then begin
    CurLines:=0;
    LinesStart:=0;
 end else   
    Inc(CurLines,WinLines);
 GraphRepaint;
end;

{ Draw method for painted views is trivial }

procedure TLines.Draw;

begin
   Paint(@Self,0,LinesStart);
end;

procedure PaintHeader(y:Integer);

var
   i:Integer;

begin
   BWriteChar(10,y+10,Ord('D'));
   BWriteChar(10,y+25,Ord('E'));
   BWriteChar(10,y+40,Ord('M'));
   BWriteChar(10,y+55,Ord('O'));
   for i:=1 to 50 do
      BWritePixel(Random(X_Max),Random(Y_Max)+y,BDraw)
end;   

procedure TLines.GraphRepaint;
var
  Cnt:byte;
  S:Word;

begin
 for Cnt:=0 to 3 do begin 
 with Rct[Cnt] do
   begin
      BLine(x1,y1+LinesStart*CharHeight,x2,y1+LinesStart*CharHeight,BErase);
      BLine(x2,y1+LinesStart*CharHeight,x2,y2+LinesStart*CharHeight,BErase);
      BLine(x2,y2+LinesStart*CharHeight,x1,y2+LinesStart*CharHeight,BErase);
      BLine(x1,y2+LinesStart*CharHeight,x1,y1+LinesStart*CharHeight,BErase);
      BLine(x1,y1+LinesStart*CharHeight,x2,y2+LinesStart*CharHeight,BErase);
      BLine(x1,y2+LinesStart*CharHeight,x2,y1+LinesStart*CharHeight,BErase);
      ChangeLines(x1,dx1,X_max);
      ChangeLines(y1,dy1,Y_max);
      ChangeLines(x2,dx2,X_max);
      ChangeLines(y2,dy2,Y_max);
      BLine(x1,y1+LinesStart*CharHeight,x2,y1+LinesStart*CharHeight,BDraw);
      BLine(x2,y1+LinesStart*CharHeight,x2,y2+LinesStart*CharHeight,BDraw);
      BLine(x2,y2+LinesStart*CharHeight,x1,y2+LinesStart*CharHeight,BDraw);
      BLine(x1,y2+LinesStart*CharHeight,x1,y1+LinesStart*CharHeight,BDRaw);
      BLine(x1,y1+LinesStart*CharHeight,x2,y2+LinesStart*CharHeight,BDraw);
      BLine(x1,y2+LinesStart*CharHeight,x2,y1+LinesStart*CharHeight,BDraw);
   end;
 end;
 PaintHeader(LinesStart*CharHeight);
 UpdatePaint(@Self); { So simple it is }
end;

destructor TLines.Done;

var
   P,V:PLines;
   
begin
   V:=Nil;
   P:=FirstLines;
   while P<>nil do begin
      if @Self=P then begin
         if V<>Nil then
            V^.NextLines:=P^.NextLines
         else
            FirstLines:=P^.NextLines;
         inherited Done;
         Exit;
      end;
      V:=P;
      P:=P^.NextLines;
   end;
   inherited Done;
end;

constructor TLinesDemo.Init;
var
  R  : TRect;
  PB : PLines;
  
begin
  if CharHeight=8 then begin
     WinLines:=20;
     TotalLines:=120;
  end else begin
     WinLines:=10;
     TotalLines:=60;
  end;        
  R.Assign(0, 0, 34, 2+WinLines);
  TWindow.Init(R, 'L I N E S', wnNoNumber);
  Flags := Flags and not (wfGrow + wfZoom);
  GetExtent(R);
  R.Grow(-1,-1);
  InitPaint(32,TotalLines,$3f); 
  FillChar(Ptr(PaintSeg,0)^,64*(TotalLines DIV 2)*CharHeight,Chr(0));
  PB:=New(PLines,Init(R));
  if  (PB=nil) then
     Dispose(PB,Done);
  with PB^ do
  begin
    Options := Options or ofSelectable;
  end;
  Insert(PB);
  PB^.Select;
  PB^.NextLines:=FirstLines;
  FirstLines:=PB;  
end;

end.
