unit interf;

interface

uses Objects {$IFDEF DPMI} ,WinAPI {$ENDIF};

{ 
  All definitions are used to tie implementation parts of the 
  DRIVERS.PAS, VIEWS.PAS and GEPAINT.PAS.
}

{ 
  Typical PaintProc is 

    procedure Paint(P:Pointer;x,y:Integer);far;
    
  where P is pointer to TView object and x,y are upper-left cell coordinates 
  in GEPAINT buffer. The dimensions of the area to be painted are determined
  from P.      

  UpdatePaint forces repainting of the TView from GEPAINT buffer. 
}  

type
   Proc=Procedure;
   PaintProc=Procedure(P:Pointer;x,y:Integer);   
   UpdatePaintProc=Procedure(P:Pointer);

const

{  Dimensions of characters in pixels }
      
   CharHeight    : Word=8;
   CharWidth     : Word=8;

{  All the graphics with GEPAINT is drawn with fore/background colors from }

   GraphicsAttr  : Byte=$70;

{  True if mouse is painted in DRIVERS.PAS (SVGA modes) }

   BGIMouse      : Boolean=False;

{  True for SVGA mode -2 }

   BankSwitching : Boolean=False;

{  Check inside the interrupts }

   ScreenBusy    : Boolean=False;
{
   If BufferLimit=0 then GEPAINT is not initialized and all text attribute
   values work as usually. If BufferLimit>0 then the attribute which is
   greater than 127 indicates that attribute-character pair form a
   cell number in the GEPAINT buffer. Buffer is organized as row of lines.
   Length of lines is CharWidth*BufferWidth pixels, and there are
   CharHeight*BufferHeight lines in total. In protected mode buffer
   can be larger than 64K. All routines in GEPAINT check for segment
   borders. The first bit of the attribute-character pair indicates
   buffer address, so that there can be maximum 32768 cells in buffer. 
}    

   BufferLimit   : Word=0;   
            
var

{
   For mouse events Where and MouseWhere analog with pixel
   addresses. ( WhereG is not part of the TEvent record! )
   MouseImage is used by Mouse, Cursor and Screen painters.
   If you work with interrupts all things change and all three
   points can be different.
}

   WhereG        : TPoint;
   MouseWhereG   : TPoint;
   MouseImage    : TPoint;

{
   Screen dimensions and selector ( Ptr(ScreenSeg,0) points to screen)   
   There are actually two screen buffers. One for actual image. Other
   one for updates to be done. When writing out from ScreenLimit you
   get GPE for protected mode. 
}   
   
   ScreenRect    : TRect;
         
   ScreenSeg     : Word;
   VisibleSeg    : Word;

   ScreenLimit   : Word;

{  Dimensions (in cells) of the GEPAINT buffer and its selector }

   BufferHeight  : Word;
   BufferWidth   : Word; 
   
   PaintSeg      : Word;

{  
   The character code tables for different resolutions are linked 
   into DRIVERS.TPU.
}
         
   CharCodeTable : Pointer;

{  Probably you do not need them }
   
   RemoveCursor  :Proc;
   RestoreCursor :Proc;

{  Optimize complex updates by bracketing updates }

   PushRefresh   :Proc;
   PopRefresh    :Proc;

{  See LINES.PAS how to use }

   Paint         :PaintProc;
   UpdatePaint   :UpdatePaintProc;
      
implementation

end.   