unit GePaint;

{$O+,X+,I-,S-}

interface

uses Graph, Interf, Objects, Drivers, Views {$IFDEF DPMI} ,WinAPI {$ENDIF};

{   Mode values }

const
    BDraw   = 0;
    BErase  = 1;
    BXor    =-1;

{ Number of Columns and Rows and GraphicsAttr for GEPAINT buffer }

procedure InitPaint(Columns,Rows:Word;Attr:Byte);

{ Coordinates in pixels! }

procedure BLine(x1,y1,x2,y2,Mode:Integer);
procedure BWritePixel(x,y,Mode:Integer);
function  BReadPixel(x,y:Integer):Integer;

{ Ordinal value of the character to be painted is cd. }

procedure BWriteChar(x,y,cd:Integer);

implementation

const
   IsPaint:Boolean=False;

{$L PAINT.OBJ}

procedure BLine(x1,y1,x2,y2,Mode:Integer);
external; 

procedure BWritePixel(x,y,Mode:Integer);
external;

function  BReadPixel(x,y:Integer):Integer;
external;

procedure BWriteChar(x,y,cd:Integer);
external;

{ Quick and dirty initialization procedure. Rewrite it with
  checks and appropriate warnings }
  
procedure InitPaint(Columns,Rows:Word;Attr:Byte);

var
   Lng:LongInt;
{$IFDEF DPMI}
   Handle:THandle;
{$ENDIF}
   Pt:Pointer;
       
begin
   GraphicsAttr:=attr;
   if IsPaint then
      Exit;
   Lng:=LongInt(Rows)*Columns*CharHeight;
   if Lng=0 then
      Exit;   
{$IFDEF DPMI}
   Handle:=GlobalAlloc(gmem_Moveable,Lng);
   Pt:=GlobalLock(Handle);
   PaintSeg:=Seg(Pt^);
{$ELSE}
   if Lng>65504 then
      Exit;
   Lng:=Lng+16;
   GetMem(Pt,Lng);
   Pt:=Ptr(Seg(Pt^)+1,0);
   PaintSeg:=Seg(Pt^);
{$ENDIF}
   BufferWidth:=Columns;
   BufferHeight:=Rows;
   BufferLimit:=Columns*Rows;
   IsPaint:=True;
end;

end.
