{ **********************************************************************
  *                          Program VF.PAS                            *
  *                            Version 1.1                             *
  *                    (c) J. Debord, April 1997                       *
  **********************************************************************
  This program displays an ASCII file (with lines truncated to 80 char.)
  The amount of lines that may be viewed depends on the amount of memory
  available and the compiler used. The default is 3000 lines. See the
  comments in INTERFAC.PAS on how to increase this limit.
  ********************************************************************** }

program VF;

{ ----------------------------------------------------------------------
  The following compiler directive specifies a maximal size for the
  heap, to allow the use of the ShellDOS procedure. These settings
  correspond to a default value of 3000 for the maximum number of lines
  to be viewed.

  Note: This directive may be removed if the program is compiled in
  protected mode.
  ---------------------------------------------------------------------- }

{$M 16000, 0, 300000}

uses
  Crt, Matrices, InterFac;

const
  NOPT = 4;  { Number of options in menu }

var
  Menu   : PMenu;
  Select : Integer;  { Index of selected option }

procedure InitMenu(var Menu : PMenu; Nopt : Integer);
{ ----------------------------------------------------------------------
  Initializes menu
  ---------------------------------------------------------------------- }
begin
  DimMenu(Menu, NOPT);

  { Set menu title }
  InitMenuElem('ASCII File Viewer', '', Menu^[0]);

  { Set menu options }
  InitMenuElem('Directory', 'Change default directory', Menu^[1]);
  InitMenuElem('Read file', 'Read an ASCII file',       Menu^[2]);
  InitMenuElem('Shell DOS', 'Access DOS',               Menu^[3]);
  InitMenuElem('Quit',      'Exit program',             Menu^[4]);
end;

procedure ReadFile;
{ ----------------------------------------------------------------------
  Reads and displays an ASCII file
  ---------------------------------------------------------------------- }
var
  FileName : String;
begin
  FileName := '*';
  if ReadFileName(FileName) then
    ViewFile(FileName);
end;

begin
  InitMenu(Menu, NOPT);
  repeat
    ClrScr;
    Frame('', 1, 4, 80, 24, 2, $03, True);
    if ReadMenu(NOPT, Menu, Select) then
      case Select of
        1 : ChangeDir;
        2 : ReadFile;
        3 : ShellDOS;
      end;
  until Select = NOPT;
  FlatCursor;
  ClrScr;
end.