{ **********************************************************************
  *                         Program PICK2.PAS                          *
  *                            Version 1.0                             *
  *                     (c) J. Debord, April 1997                      *
  **********************************************************************
  This program demonstrates the use of a pick list to choose several
  elements.
  ********************************************************************** }

program Pick2;

uses
  Crt, Matrices, InterFac;

const
  NELEM     = 6;  { Number of elements in the pick list }
  NCOL      = 6;  { Number of columns. May vary from 1 to NELEM }
  FIRSTLINE = 5;  { First line of list on screen }

var
  List   : PPickList;
  Select : PBoolVector;  { Saves the selection status of each element }
  I      : Integer;      { Loop variable }

begin
  { Dimension arrays (Select has its elements initialized to FALSE) }
  DimPickList(List, NELEM);
  DimBoolVector(Select, NELEM);

  { Define list title }
  List^[0] := 'Choose options';

  { Define options }
  List^[1] := 'Option1';
  List^[2] := 'Option2';
  List^[3] := 'Option3';
  List^[4] := 'Option4';
  List^[5] := 'Option5';
  List^[6] := 'Option6';

  { Clear screen }
  ClrScr;

  { Choose one or several options }
  if MPick(NELEM, NCOL, FIRSTLINE, List, Select) then
    begin
      GotoXY(1, 25);
      Write('You chose option(s): ');
      for I := 1 to NELEM do
        if Select^[I] then
          Write(I, ' ');
    end;

  DelPickList(List, NELEM);
end.