{ **********************************************************************
  *                         Program PICK1.PAS                          *
  *                            Version 1.0                             *
  *                     (c) J. Debord, April 1997                      *
  **********************************************************************
  This program demonstrates the use of a pick list to choose a single
  element.
  ********************************************************************** }

program Pick1;

uses
  Crt, Matrices, InterFac;

const
  NELEM     = 6;  { Number of elements in the pick list }
  NCOL      = 6;  { Number of columns. May vary from 1 to NELEM }
  FIRSTLINE = 5;  { First line of list on screen }

var
  List   : PPickList;
  Select : Integer;

begin
  { Dimension options list }
  DimPickList(List, NELEM);

  { Define list title }
  List^[0] := 'Choose an option';

  { Define options }
  List^[1] := 'Option1';
  List^[2] := 'Option2';
  List^[3] := 'Option3';
  List^[4] := 'Option4';
  List^[5] := 'Option5';
  List^[6] := 'Option6';

  { Clear screen }
  ClrScr;

  { Choose an option }
  if Pick(NELEM, NCOL, FIRSTLINE, List, Select) then
    begin
      GotoXY(32, 25);
      Write('You chose option ', Select);
    end;

  DelPickList(List, NELEM);
end.