{ **********************************************************************
  *                         Program MASK2.PAS                          *
  *                            Version 1.0                             *
  *                     (c) J. Debord, April 1997                      *
  **********************************************************************
  This program demonstrates the use of an entry mask to read a series of
  (X, Y) coordinates.
  ********************************************************************** }

uses
  Crt, FMath, Matrices, PaString, Interfac;

const
  NOBS    = 4;  { Number of observations }
  NFIELDS = 2;  { Number of fields }

var
  X, Y : PVector;     { Vectors to read }
  Mask : PEntryMask;  { Entry mask }
  I    : Integer;     { Loop variable }
  Ch   : Char;        { Key pressed to validate entry }

begin
  DimVector(X, NOBS);
  DimVector(Y, NOBS);
  DimEntryMask(Mask, NFIELDS);

  { Clear screen }
  ClrScr;

  { Don't display non-significant zero's }
  NSZero := False;

  I := 1;  { Index of observation }
  REPEAT
    { Initialize the two fields of the mask }
    InitFloatField(33, 4, 'X', 0, 0, X^[I], Mask^[1]);
    InitFloatField(33, 6, 'Y', 0, 0, Y^[I], Mask^[2]);

    { Draw a frame around the mask }
    Frame('Observation ' + LTrim(IntToStr(I)),
          25, 2, 55, 8, 1, ATT_FB, True);

    { Input data }
    Ch := ReadMask(Mask, NFIELDS);

    { Retrieve data from mask }
    if Ch <> ESCAPE then
      begin
        X^[I] := Mask^[1].F;
        Y^[I] := Mask^[2].F;
      end;

    { Go to next entry }
    CASE Ch OF
      PAGE_UP   : IF I = 1 THEN I := NOBS ELSE I := Pred(I);
      PAGE_DOWN : IF I = NOBS THEN I := 1 ELSE I := Succ(I);
      ENTER     : I := Succ(I);
      CTRL_HOME : I := 1;
      CTRL_END  : I := NOBS;
    END;
  UNTIL ((Ch = ENTER) AND (I > NOBS)) OR (Ch = ESCAPE);

  GotoXY(29, 10); Write('    X            Y    ');
  GotoXY(29, 11); Write('----------------------');

  for I := 1 to NOBS do
    begin
      GotoXY(25, 11 + I);
      Write(X^[I]:13:4, Y^[I]:13:4);
    end;

  DelVector(X, NOBS);
  DelVector(Y, NOBS);
  DelEntryMask(Mask, NFIELDS);
end.