{ **********************************************************************
  *                        File REG_PLOT.INC                           *
  *                           Version 1.1                              *
  *                     (c) J. Debord, July 1997                       *
  **********************************************************************
   Include file used by several linear or nonlinear regression programs
  ********************************************************************** }

{ ----------------------------------------------------------------------
  The following routine plots the regression function
  ---------------------------------------------------------------------- }

  procedure PlotGraph;
  var
    Ch : Char;
  begin
    { Determine scale automatically }
    AutoScale(X, 1, N, XAxis);
    AutoScale(Y, 1, N, YAxis);

    { Plot graph }
    if GraphOk then
      begin
        WriteLegend(0);
        SetClipping(True);

        { Plot points }
        PlotCurve(X, Y, 1, N, 1, 0);

        { Plot fitted function }
        PlotFunc(XAxis.Min, XAxis.Max, 1);

        { Leave graphic mode }
        Ch := ReadKey;
        CloseGraph;
      end;
  end;


