{ **********************************************************************
  *                          File REG_NL.INC                           *
  *                            Version 1.1                             *
  *                     (c) J. Debord, July 1997                       *
  **********************************************************************
        Include file used by several nonlinear regression programs
  ********************************************************************** }

{ ----------------------------------------------------------------------
  The next two routines are used by the minimization procedure. They must
  be compiled in FAR mode ($F+). Don't modify the parameter list or the
  function type : they must match the definitions in OPTIM.PAS
  ---------------------------------------------------------------------- }

  {$F+}
  function LS_ObjFunc(B : PVector) : Float;
  { Defines the objective function to be minimized }
  var
    K : Integer;
  begin
    for K := 1 to N do
      Ycalc^[K] := RegFunc(X^[K], B);
    LS_ObjFunc := SumWSqrDifVect(Y, Ycalc, W, 1, N);
  end;

  procedure LS_HessGrad(B : PVector; Lbound, Ubound : Integer;
                        G : PVector; H : PMatrix);
  { Computes Gradient and Hessian of objective function }
  var
    I, J, K : Integer;  { Loop variables }
    R       : Float;    { Residual }
    D       : PVector;  { Derivatives of regression function }
    WD      : Float;    { Weighted derivative }
  begin
    DimVector(D, Ubound);

    { Initialize arrays }
    for I := Lbound to Ubound do
      begin
        G^[I] := 0.0;
        for J := I to Ubound do
          H^[I]^[J] := 0.0;
      end;

    { Compute Gradient and Hessian }
    for K := 1 to N do
      begin
        R := Y^[K] - Ycalc^[K];
        DerivProc(X^[K], B, D);
        for I := Lbound to Ubound do
          begin
            WD := W^[K] * D^[I];
            G^[I] := G^[I] - WD * R;
            for J := I to Ubound do
              H^[I]^[J] := H^[I]^[J] + WD * D^[J];
          end;
      end;

    { Fill in symmetric matrix }
    for I := Succ(Lbound) to Ubound do
      for J := Lbound to Pred(I) do
        H^[I]^[J] := H^[J]^[I];
    DelVector(D, Ubound);
  end;
  {$F-}

{ ----------------------------------------------------------------------
  The next routine fits the model to the data
  ---------------------------------------------------------------------- }

  procedure FitModel;
  var
    K     : Integer;
    F_min : Float;    { Objective function at minimum }
    Ch    : Char;
  begin
    { Dimension arrays }
    Lbound := FirstParam;
    Ubound := LastParam;
    DimVector(B, Ubound);
    DimMatrix(V, Ubound, Ubound);
    WriteLn(#10, 'Nonlinear least squares fit of function :');
    WriteLn(FuncName);
    WriteLn('to the data in file : ', InFName);

    { Compute initial parameter estimates and stop if estimation fails }
    ErrCode := ApproxFit;
    if ErrCode <> MAT_OK then
      begin
        WriteLn('Unable to compute initial parameter estimates !');
        Exit;
      end;

    { Compute weights }
    for K := 1 to N do
      W^[K] := 1.0 / VarFunc(Y^[K]);

    { Set the addresses of the procedures used by Marquardt's method }
    ObjFuncAddr := @LS_ObjFunc;
    HessProcAddr := @LS_HessGrad;

    { Refine parameters by Marquardt's method }
    ErrCode := Marquardt(B, Lbound, Ubound, ITMARQ, TOLMARQ, F_min, V);

    case ErrCode of
      MAT_OK     : for K := 1 to N do
                     Ycalc^[K] := RegFunc(X^[K], B);  { Update Ycalc values }
      MAT_SINGUL : WriteLn('Singular matrix !');
      BIG_LAMBDA : WriteLn('Lambda too high !');
      NON_CONV   : WriteLn('Non-convergence !');
    end;

    Write(#10'Press a key...');
    Ch := ReadKey;
  end;