{ **********************************************************************
  *                         Program RANTEST.PAS                        *
  *                             Version 1.2                            *
  *                     (c) J. Debord, August 1997                     *
  **********************************************************************
  This program picks 20000 random numbers and displays the next
  six, together with the correct values obtained with the default
  initialization, i.e. RMarIn(1802, 9373).
  ********************************************************************** }

program RanTest;

uses
  Crt, FMath;

const
  Correct : array[1..6] of LongInt
  = (6533892, 14220222, 7275067, 6172232, 8354498, 10633180);

var
  I : Integer;
  R : LongInt;
begin
  ClrScr;
  Writeln('Test of Marsaglia random number generator');
  WriteLn('-----------------------------------------');
  WriteLn('     Correct         Actual');
  WriteLn('-----------------------------------------');

  { Pick 20000 random numbers }
  for I := 1 to 20000 do
    R := IRanMar;

  { Display 6 more numbers with correct values }
  for I := 1 to 6 do
    begin
      R := IRanMar;
      Write('  ', Correct[I]:10, '     ', R:10, '           ');
      if Correct[I] = R then WriteLn('OK') else WriteLn('BAD');
    end;
  WriteLn('-----------------------------------------');
end.

