{ **********************************************************************
  *                        Program EIGENVAL.PAS                        *
  *                             Version 1.0                            *
  *                     (c) J. Debord, January 1997                    *
  **********************************************************************
  This program computes the eigenvalues of a general square matrix (see
  EIGENSYM.PAS for a symmetric matrix). The matrix is stored in a data
  file with the following structure :

    Line 1             : dimension of the matrix (N)
    Lines 2 to (N + 1) : matrix

  The file MATRIX1.DAT is an example data file with N = 4
  ********************************************************************** }

uses
  Crt, FMath, Matrices, Eigen;

var
  A         : PMatrix;  { Matrix }
  N         : Integer;  { Dimension of matrix }
  Lambda_Re,
  Lambda_Im : PVector;  { Real and imaginary part of eigenvalues }
  Ch        : Char;     { Key pressed to exit program }

  procedure ReadMatrix(FileName : String; var A : PMatrix;
                       var N : Integer);
{ ----------------------------------------------------------------------
  Reads matrix from file. Note that A is passed as a VAR parameter
  because it is dimensioned inside the procedure.
  ---------------------------------------------------------------------- }
  var
    F    : Text;     { Data file }
    I, J : Integer;  { Loop variable }
  begin
    Assign(F, FileName);
    Reset(F);
    Read(F, N);
    DimMatrix(A, N, N);
    for I := 1 to N do
      for J := 1 to N do
        Read(F, A^[I]^[J]);
    Close(F);
  end;

  procedure WriteMatrix(Title : String; A : PMatrix; N : Integer);
{ ----------------------------------------------------------------------
  Writes matrix on screen
  ---------------------------------------------------------------------- }
  var
    I, J : Integer;
  begin
    WriteLn(Title, ' :', #10);
    for I := 1 to N do
      begin
        for J := 1 to N do
          Write(A^[I]^[J]:12:6);
        WriteLn;
      end;
    WriteLn;
  end;

  procedure WriteEigenValues(Lambda_Re, Lambda_Im : PVector; N : Integer);
{ ----------------------------------------------------------------------
  Writes eigenvalues on screen
  ---------------------------------------------------------------------- }
  var
    I : Integer;
  begin
    WriteLn('Eigenvalues :', #10);
    WriteLn('    Real        Imag.');
    for I := 1 to N do
      WriteLn(Lambda_Re^[I]:12:6, Lambda_Im^[I]:12:6);
    WriteLn;
  end;

begin
  ClrScr;

  { Read matrix from file }
  ReadMatrix('MATRIX1.DAT', A, N);
  WriteMatrix('Original matrix', A, N);

  { Dimension the vectors containing the eigenvalues }
  DimVector(Lambda_Re, N);
  DimVector(Lambda_Im, N);

  { Compute eigenvalues }
  case EigenVals(A, 1, N, Lambda_Re, Lambda_Im) of
    MAT_OK       : WriteEigenValues(Lambda_Re, Lambda_Im, N);
    MAT_NON_CONV : Write('Too many iterations!');
  end;

  GotoXY(1, 25);
  Write('Press a key ... ');
  Ch := ReadKey;
end.

