; TUBRO Pascal version 4.0   EXTERNAL FUNCTION        87/12/13 ...red }
; =================================================================== }
; Copyright 1996 Roger E. Donais              <rdonais@southeast.net> }
; May be used freely as long as due credit is given                   }
; ------------------------------------------------------------------- }

; FUNCTION Zfill(S: String): String;
; { =================================================================== }
; { Return "S" with all spaces replaced with ascii zero's               }
; { =================================================================== }
; VAR i: Integer;
; BEGIN{Zfill}
;     i := Pos(' ',S);
;     While i <> 0 Do Begin
;        s[i] := '0';
;        i := Pos(' ',S);
;     End;
;     Zfill := s;
; END{Zfill};

; ---------------------------------------------------------------------

CODE     SEGMENT   BYTE
ASSUME   CS:CODE,DS:CODE,ES:CODE,SS:CODE

         PUBLIC ZFILL

frame    struc
BPreg    dw ?
DSreg    dw ?
caller   dd ?
string   dd ?
result   dd ?
frame    ends

ZFILL    PROC FAR

         push DS
         push BP
         mov  BP,SP
         lds  SI,[BP+string]
         les  DI,[BP+result]
         cld
         lodsb
         stosb
         mov  CL,AL
         xor  CH,CH
         jcxz exit

         mov  AH,' '

REPEAT:  lodsb
         cmp  AL,AH
         jnz  skip
         mov  AL,'0'
skip:    stosb
         loop REPEAT

exit:    pop  BP
         pop  DS
         ret  4

ZFILL    ENDP
CODE     ENDS
         END

