; Turbo Pascal Version 4.0 Functions                  88/10/12 ...red }
; =================================================================== }
; Copyright 1996 Roger E. Donais              <rdonais@southeast.net> }
; May be used freely as long as due credit is given                   }
; ------------------------------------------------------------------- }
;
; FUNCTION UpperCase(S: String): String;                              }
; FUNCTION LowerCase(S: String): String;                              }
; ------------------------------------------------------------------- }

CODE    SEGMENT
ASSUME  CS:CODE

        PUBLIC  UpperCase, LowerCase

frame   struc

old_bp  dw ?
caller  dd ?
string  dd ?
result  dd ?

frame   ends

; ---------------------------------------------
; Case conversion ...

Case    PROC    FAR

LowerCase:  mov   BX,0415Bh      ; load 'A' and 'Z'+1 for conversion tests
            mov   DX,0FF20h      ; load lower case (AND/OR) conversion values
            jmp   SHORT case0

UpperCase:  mov   BX,0617Bh      ; load 'a' and 'z'+1 for conversion tests
            mov   DX,05F00h      ; load upper case (AND/OR) conversion values

Case0:  push BP
        mov  BP,SP
        push DS
        lds  SI,string[BP]      ; String to convert
        les  DI,result[BP]      ; Return string
        cld                     ; set forward direction

        lodsb                   ; get string length
        stosb                   ; store to result
        mov CL,AL
        xor CH,CH
        jcxz case9

case1:  lodsb
        cmp AL,BH            ; check for 'a' (or 'A')
        jc  case2            ; and skip if below ...

        cmp AL,BL            ; check for 'z'+1 (or 'Z'+1)
        jnc case2            ; and skip if above

        and AL,DH            ; perform appropriate
        or  AL,DL            ; case conversion ...

case2:  stosb                ; copy character to destination
        loop case1           ; and repeat until nul delimiter

case9:  pop DS
        pop BP
        ret 4                ; Discard paramter

Case    ENDP
CODE    ENDS
        END
