; TUBRO Pascal version 4.0   EXTERNAL FUNCTIONS       87/12/13 ...red }
; =================================================================== }
; Copyright 1996 Roger E. Donais              <rdonais@southeast.net> }
; May be used freely as long as due credit is given                   }
; ------------------------------------------------------------------- }

; FUNCTION Trim(s: String): String;
; { =================================================================== }
; { Returns "s" with all leading and trailing charatcers that are       }
; { less than or equal to a space removed                               }
; { =================================================================== }
;
; FUNCTION Ltrim(s: String): String;
; { =================================================================== }
; { Returns "s" with all leading charatcers that are less than or equal }
; { to a space removed                                                  }
; { =================================================================== }
;
; FUNCTION Rtrim(s: String): String;
; { =================================================================== }
; { Returns "s" with all trailing charatcers that are less than or      }
; { equal to a space removed                                            }
; { =================================================================== }
;
; FUNCTION Ftrim(s: String): String;
; { =================================================================== }
; { Returns "s" with all leading and trailing charatcers that are       }
; { less than or equal to a space removed, all characters less than a   }
; { are space converted to a space, and all duplicate spaces removed.   }
; { =================================================================== }
;
; FUNCTION StrOf(VAR S; Len: Integer): String;
; { =================================================================== }
; { Returns string starting at "s" for "len" characters                 }
; { <Returns null string if "len" is less than 1 or greater than 255>   }
; { =================================================================== }
;
; FUNCTION TrimStrOf(VAR S; Len: Integer): String;
; { =================================================================== }
; { Returns the trimmed string starting at "s" for "len" characters     }
; { <Returns null string if "len" is less than 1 or greater than 255>   }
; { =================================================================== }


CODE     SEGMENT   BYTE
ASSUME   CS:CODE,DS:CODE,ES:CODE,SS:CODE

         PUBLIC TRIM, LTRIM, RTRIM, FTRIM, STRIM, CTRIM
         PUBLIC STROF, TRIMSTROF, TRIMMED, COMPRESS


PROCESS  PROC  NEAR
; ---------------------------------------------------------------------
STROF:      xor   AX,AX               ; No trimming ...
            db    0B9h                ; mov CX, imm16  (e.g. jmp Str2)

TRIMSTROF:  mov   AH,090h             ; Leading and trailing trim
; continue w/ Str2 ...

; ---------------------------------------------------------------------
Str2:     mov   BX,SP                 ; Common entry for StrOf & TrimStrOf
          push  DS
          les   DI,SS:[BX+10]
          lds   SI,SS:[BX+ 6]
          mov   DX,SS:[BX+ 4]

          mov   BYTE PTR ES:[DI],0
          or    DH,DH                 ; Return null string
          jnz   str9                  ; if length < 1 or > 255

          mov   AL,DL
          call  Trimmer

str9:     pop   DS

          retf  6

; ---------------------------------------------------------------------
COMPRESS: mov   AH,060h
          mov   BX,SP             ; duplicate TRIMS entry...
          push  DS

          les   DI,SS:[BX+4]      ; VAR target
          jmp   SHORT Trims1

TRIM:     mov   AH,090h
          jmp   SHORT trims

LTRIM:    mov   AH,080h
          jmp   SHORT trims

RTRIM:    mov   AH,010h
          jmp   SHORT trims

FTRIM:    mov   AH,0B0h
          jmp   SHORT trims

STRIM:    mov   AH,060h
          jmp   SHORT trims

CTRIM:    mov   AH,040h
          jmp   SHORT trims

TRIMMED:  pop   DI
          pop   ES
          pop   AX
          push  ES
          push  DI
; continue w/ trims...

; ---------------------------------------------------------------------
Trims:    mov   BX,SP             ; Entry for TRIM, LTRIM, RTRIM, FTRIM
          push  DS

          les   DI,SS:[BX+8]
Trims1:   lds   SI,SS:[BX+4]
          cld
          lodsb
          call Trimmer
          pop  DS
          retf 4


; ---------------------------------------------------------------------
; Used by TRIMSTROF, TRIM, LTRIM, RTRIM, and FTRIM
;
; ES:DI --> Length byte of Result string
; DS:SI --> First character beyond length byte of Source string
; AL    === Source string length
; AH    === Trim options
;       Left       $80 remove all leading characters .LE. space
;       Compress   $60 remove all characters .LE. space
;       Control    $40 change all characters .LT. space to a space
;       Extraneous $20 change ctrl to space & remove extraneous spaces
;       Right      $10 remove all trailing characters .LE. space


Trimmer:  push DI
          mov  CL,AL
          xor  CH,CH
          jcxz trim9

          cld
          stosb
          mov  DX,2020h      ; Quick spaces for comparison
          xor  BX,BX
          shl  AH, 1
          jnc  trim3         ; no left trim


trim1:    lodsb
          cmp  AL,DL
          ja   trim4
          loop trim1

trim9:    pop  DI
          mov  ES:[DI],CL
          ret

trim3:    lodsb
trim4:    cmp  AL,DL           ; Check for .LE. space
          ja   trim4b          ; .ge. space is taken "as-is"

          test AH, 0C0h        ; Check type of center trim
          jz   trim4a          ; 00=no center trims
          jpe  trim4c          ; 11=(60) remove all (compress)
          js   trim4d          ; 01=(40) change ctrl to space
         ;jns                  ; 10=(20) change and remove extraneuos spaces

trim4e:   cmp  DH,DL           ; Check for previous space
          jz   trim4c

trim4d:   mov  AL,DL           ; Replace with a space
trim4b:   mov  DH,AL           ; Update last character
trim4a:   stosb
          inc  BX
trim4c:   loop trim3

          mov  CX,BX          ; Reset string length
          shl  AH,1           ; Discard center trim & flag for right
          shl  AH,1
          jns  trim9          ; no right trim

trim5:    jcxz trim9
          dec  DI
          cmp  ES:[DI],DL
          ja   trim9
          dec  CX
          jmp  SHORT trim5

PROCESS   ENDP

CODE     ENDS
         END

