; Turbo Pascal Version 4.0 Functions                  88/10/06 ...red }
; =================================================================== }
; Copyright 1996 Roger E. Donais              <rdonais@southeast.net> }
; May be used freely as long as due credit is given                   }
; ------------------------------------------------------------------- }

; FUNCTION StringOf(C; Char; N: Integer): String;                       }
; { ------------------------------------------------------------------- }
; { Returns a string containing "count" characters of "c"               }
; { <Returns null string if count is less than 1 or greater than 255>   }
; { =================================================================== }
; VAR s: String;
; Begin
;    If (Hi(n) <> 0) or Lo(n) = 0) Then
;       s := ''
;    Else Begin
;       FillChar(s[1], c, n);
;       s[0] := Char(n);
;    End;
;    StringOf := s;
; End;
;
; FUNCTION Spaces(Count: Integer): String;
; { ================================================================== }
; { Returns a string containing "count" characters of spaces           }
; { <Returns null string if count is less than 1 or greater than 255>  }
; { ================================================================== }
; Begin  Spaces := StringOf(' ', Count);  End;
;
; FUNCTION Lset(const s: String; Width: Integer): String;
; { =================================================================== }
; { Returns "S" left justified or truncated to "width                   }
; { <Returns null string if width is less than 1 or greater than 255>   }
; { =================================================================== }
; Begin  Lset := Copy(s + Spaces(Width), 1, Width);  End;

CODE    SEGMENT
ASSUME  CS:CODE

        PUBLIC  StringOf, Spaces, Lset
; STRING ----
Ostack   struc
Ocaller  dd ?
Ocount   dw ?
Ochar    db ?
Ofiller  db ?
Oresult  dd ?
Ostack   ends

; SPACE -----
Sstack   struc
Scaller  dd ?
Scount   dw ?
Sresult  dd ?
Sstack   ends

; LSET ------
Lstack   struc
Lframe   dw ?
LDSreg   dw ?
Lcaller  dd ?
Lcount   dw ?
Lsource  dd ?
Lresult  dd ?
Lstack   ends

StringOf        PROC    FAR

        mov  BX,SP
        les  DI,SS:[BX+Oresult]     ; Return string
        mov  AL,SS:[BX+Ochar];      ; Fill Character
        mov  CX,SS:[BX+Ocount]      ; Number of characters
        call FillStr
        ret  4

StringOf    ENDP

Spaces      PROC FAR

        mov  BX,SP
        les  DI,SS:[BX+Sresult]
        mov  CX,SS:[BX+Scount]
        mov  AL,' '
        call FillStr
        ret  2

Spaces      ENDP

Lset        PROC FAR

        push DS
        push BP
        mov  BP,SP
        les  DI,[BP+Lresult]
        mov  CX,[BP+Lcount]
        mov  AL,' '
        call FillStr
        mov  CX,[BP+Lcount]
        jcxz ls2

        lds  SI,[BP+Lsource]
        les  DI,[BP+Lresult]
        inc  DI
        cld
        lodsb
        cmp  AL,CL
        jnc  ls1
        mov  CL,AL
ls1:    rep  movsb

ls2:    pop  BP
        pop  DS
        ret  6

Lset    ENDP

FillStr PROC NEAR

        cld                 ; set forward direction
        or   CH,CH          ; Check if over range
        jnz  null
        jcxz null

        mov  ES:[DI],CL
        inc  DI

        rep stosb
        ret

null:   mov ES:[DI],BYTE PTR 0
        ret

FillStr ENDP

CODE    ENDS
        END
