; TUBRO Pascal version 4.0   EXTERNAL FUNCTION                 ...red }
; =================================================================== }
; Copyright 1996 Roger E. Donais              <rdonais@southeast.net> }
; May be used freely as long as due credit is given                   }
; ------------------------------------------------------------------- }
;
; FUNCTION SignOf(Number: LongInt): Integer; Assembler;
; =====================================================================

model TPascal

.CODE

LSW = WORD PTR 0
MSW = WORD PTR 2

PUBLIC SignOf

SignOf PROC FAR Number:DWORD

       mov  AX, 1
       shl  [ Number.MSW ], 1
       ja   @Exit                    ; Above means C=0, Z=0, thus AX=1
       jc   @@1                      ; Carry signals negative

       cmp  [ Number.LSW ], AX       ; High word was zero, if low word
       jnc  @Exit                    ; > 0, then valid result in AX
       cmc                           ; setup to return zero

@@1:   sbb    AX, AX                 ; Below or Equal makes AX=-1 or 0

@Exit: ret

SignOf  ENDP
CODE    ENDS

END
