; TUBRO Pascal version 4.0   EXTERNAL FUNCTION        89/05/15 ...red }
; =================================================================== }
; Copyright 1996 Roger E. Donais              <rdonais@southeast.net> }
; May be used freely as long as due credit is given                   }
; ------------------------------------------------------------------- }
;
; FUNCTION Scomp({const} String1, String2: String): Integer;
; { =================================================================== }
; { Returns a signed integer value of  -1, 0, +1 based upon the numeric }
; { weight of String1 less String2  (e.g. String1 - String2)            }
; { =================================================================== }

       MODEL  Tpascal

       .CODE

       PUBLIC Scomp

Scomp     PROC FAR String1:DWORD, String2:DWORD

          cld
          push  DS
          lds   SI, [ String1 ]
          les   DI, [ String2 ]

          lodsb
          mov   AH, ES:[ DI ]
          inc   DI
          mov   CL, AL
          cmp   CL, AH
          jbe   @@1

          mov   CL, AH

@@1:      or    CL, CL
          je    @@2

          xor   CH, CH
          rep   CMPSB
          jne   @@3

@@2:      sub   AL, AH
          je    @@4

@@3:      sbb   AX, AX
          or    AL, 1

@@4:      cbw                      ; Extend signed byte to integer }
          pop   DS
          ret

Scomp    ENDP
CODE     ENDS
         END



