; TUBRO Pascal version 5.0   EXTERNAL FUNCTIONS                ...red }
; =================================================================== }
; Copyright 1996 Roger E. Donais              <rdonais@southeast.net> }
; May be used freely as long as due credit is given                   }
; ------------------------------------------------------------------- }

        TITLE   PUSH&POP

CODE    SEGMENT BYTE PUBLIC
        ASSUME CS:CODE

        LOCALS @@

LSW = WORD PTR 0
MSW = WORD PTR 2

LSB = BYTE PTR 0
MSB = BYTE PTR 1

; Publics

    PUBLIC  PushByte,PopByte,PushFlag,PopFlag,PushChar,PopChar
    PUBLIC  PushWord,PopWord,PushInteger,PopInteger
    PUBLIC  PushLong,PopLong,PushPtr,PopPtr


; PROCEDURE PushChar(VAR Parameter: Char; NewValue: Char);
; PROCEDURE PushByte(VAR Parameter: Byte; NewValue: Byte);
; PROCEDURE PushFlag(VAR Parameter: Boolean; NewValue: Boolean);
; =====================================================================
PushChar:
PushByte:
PushFlag:   db 0Ch      ; or AL, imm8

PopChar:
PopByte:
PopFlag:    stc         ; 1-Byte opcode

Param = BX+6
Value = BX+4

            mov  BX,SP
            les  SI,SS:[Param]
            mov  AL,SS:[Value]
            xchg AL,ES:[SI]
            jmp  SHORT WParam

; PROCEDURE PushWord(VAR Parameter: Word; NewValue: Word);
; PROCEDURE PushIntger(VAR Parameter: Integer; NewValue: Integer);
; =====================================================================
PushInteger:
PushWord:   db 0Ch      ; or AL, imm8

PopInteger:
PopWord:    stc         ; 1-Byte opcode

Param = BX+6
Value = BX+4

            mov  BX,SP
            les  SI,SS:[Param]
            mov  AX,SS:[Value]

            xchg AX,ES:[SI]

WParam:     jc   @@Pop

            mov  SS:[Value], AX
            RETF                   ; Parameters are left on the stack!
@@Pop:      RETF 6                 ; Parameters removed from the stack!




; PROCEDURE PushPtr(VAR Parameter: Pointer; NewValue: Pointer);
; PROCEDURE PushLong(VAR Parameter: Longint; NewValue: Longint);
; =====================================================================
PushPtr:
PushLong:   db 0Ch      ; or AL, imm8

PopPtr:
PopLong:    stc         ; 1-Byte opcode

Param = BP+10
Value = BP+6

            push BP
            mov  BP, SP

            les  SI, [Param]
            mov  AX, [Value.LSW]
            mov  DX, [Value.MSW]
            xchg AX, ES:[SI.LSW]
            xchg DX, ES:[SI.MSW]
            jc   @@Pop

            mov  [Value.LSW], AX
            mov  [Value.MSW], DX
            pop  BP
            RETF                   ; Parameters are left on the stack!

@@Pop:      pop  BP
            RETF 8                 ; Parameters removed from the stack!

CODE    ENDS
        END

