; TUBRO Pascal version 4.0   EXTERNAL FUNCTION        89/05/15 ...red }
; =================================================================== }
; Copyright 1996 Roger E. Donais              <rdonais@southeast.net> }
; May be used freely as long as due credit is given                   }
; ------------------------------------------------------------------- }

; FUNCTION Npos(SubString,MainString: String; Occurance: Integer): Integer;
; { =================================================================== }
; { Returns 0 when occurance is less than 1, otherwise Returns 1 when   }
; { substring is null,  otherwise Returns the position of the N-th      }
; { occurance of "SubString" in "MainString", or string length plus +1  }
; { if the N-th occurance is not found.                                 }
; { =================================================================== }
; VAR i,j: Integer;
;
; BEGIN{Npos}
;
;    If Occurance > 0 Then Begin
;       i := 0; j := 0;
;       REPEAT
;          i := Pos(SubString,Copy(MainString,Succ(j),255));
;          Inc(j,i); Dec(Occurance);
;       UNTIL (Occurance = 0) or (i = 0);
;       If (i=0) Then Npos := Succ(Ord(MainString[0])) Else Npos := j;
;    End Else Npos := 0;
;
; END{Npos};

        MODEL  Tpascal

        .CODE

        PUBLIC Npos
Npos    PROC FAR SubString:DWORD, MainString:DWORD, Occurance:WORD

        xor    AX,AX
        mov    CX,[Occurance]
        jcxz   @@9
        or     CH,CH
        js     @@9

        cld
        mov    BX,DS
        mov    AX,1

        lds    SI,[SubString]
        les    DI,[MainString]
        mov    CL,[SI]
        xor    CH,CH
        mov    DL,ES:[DI]
        xor    DH,DH
        sub    DX,CX
        jb     @@2              ; Null string never
        jcxz   @@2              ; matches an occurance

        inc    SI

@@1:    inc    DI
        push   CX
        push   SI
        push   DI
        rep    CMPSB
        pop    DI
        pop    SI
        pop    CX
        jne    @@4

        dec    Occurance        ; Decrement occurance
        jz     @@2              ; and exit when found

@@4:    inc    AX
        dec    DX
        jns    @@1

@@2:    mov    DS,BX
@@9:    ret

Npos    ENDP
CODE    ENDS
        END

