; TUBRO Pascal version 4.0   EXTERNAL FUNCTIONS       89/05/15 ...red }
; =================================================================== }
; Copyright 1996 Roger E. Donais              <rdonais@southeast.net> }
; May be used freely as long as due credit is given                   }
; ------------------------------------------------------------------- }

; FUNCTION Min(i,j: Longint): Longint;
; { =================================================================== }
; { Returns the smaller of two longints                                 }
; { =================================================================== }
; BEGIN
;     If i < j Then Min := i Else Min := j;
; END;
;
; FUNCTION Max(i,j: Longint): Longint;
; { =================================================================== }
; { Returns the larger of two longints                                  }
; { =================================================================== }
; BEGIN
;     If i > j Then Max := i Else Max := j;
; END;

CODE    SEGMENT
ASSUME  CS:CODE

      PUBLIC MIN, MAX, AbsMin

LSW = WORD PTR 0
MSW = WORD PTR 2

  i = BP+10
  j = BP+6


MAX      LABEL FAR
         db   0B9h              ; mov CX, imm16

MIN      LABEL FAR
         xor  CX, CX            ; 2-byte opcode

         push BP
         mov  BP, SP
         mov  AX, [ i.LSW ]     ; DX:AX
         mov  DX, [ i.MSW ]
         mov  SI, [ j.LSW ]     ; DI:SI
         mov  DI, [ j.MSW ]
         pop  BP

         cmp  DX, DI
         je   @Small

         jcxz @Min
         jge  @Exit

@Swap:   mov  DX, DI
         mov  AX, SI
         retf 8

@Small:  cmp  AX, SI
         rcr  CX, 1
         jno  @Swap
         retf 8

@Min:    jg   @Swap
@Exit:   retf 8


_ABS_LONG LABEL NEAR
         or    DX, DX
         jns   @Abs

         neg   AX
         adc   DX,0
         neg   DX

@Abs:    retn


AbsMin LABEL FAR

      mov   AX, [ i.LSW ]
      mov   DX, [ i.MSW ]
      call  _ABS_LONG
      push  DX
      push  AX
      mov   AX, [ j.LSW ]
      mov   DX, [ j.MSW ]
      call  _ABS_LONG
      push  DX
      push  AX
      call  Min
      retf  8

CODE ENDS
END
