; TUBRO Pascal version 4.0   EXTERNAL FUNCTION        89/05/15 ...red }
; =================================================================== }
; Copyright 1996 Roger E. Donais              <rdonais@southeast.net> }
; May be used freely as long as due credit is given                   }
; ------------------------------------------------------------------- }

; FUNCTION Lpos(SubString,MainString: String): Integer;
; { =================================================================== }
; { Returns the position of the last occurance of "SubString"           }
; { within "MainString", or zero if "SubString" does not occur          }
; { =================================================================== }
; VAR i,j: Integer;
; BEGIN{Lpos}
;     i := 0; j := 0;
;     REPEAT
;        i := Pos(SubString,Copy(MainString,Succ(i),255));
;        If i <> 0 Then j := i;
;     UNTIL i = 0;
;     Lpos := j;
; END{Lpos};

        MODEL  Tpascal

        .CODE

        PUBLIC Lpos
Lpos    PROC   FAR  SubString:DWORD, MainString:DWORD

        cld
        push    DS
        lds     SI,[SubString]
        les     DI,[MainString]
        lodsb
        xor     AH,AH
        mov     CX,AX
        jcxz    @@3               ; Null pattern returns zero position

        mov     DL,ES:[DI]
        xor     DH,DH
        inc     DX
        sub     DX,CX
        jb      @@3               ; Can't match a pattern larger than target

        add     DI,DX             ; Step to pattern at end of target
@@1:    push    CX
        push    SI
        push    DI
        rep     CMPSB
        pop     DI
        pop     SI
        pop     CX
        je      @@2

        dec     DI                 ; Step back one position in target
        dec     DX                 ; Decrement target position
        jne     @@1

@@2:    mov     AX,DX
@@3:    pop     DS
        ret

Lpos    ENDP
CODE    ENDS
        END
