; TUBRO Pascal version 4.0   EXTERNAL FUNCTION        89/05/15 ...red }
; =================================================================== }
; Copyright 1996 Roger E. Donais              <rdonais@southeast.net> }
; May be used freely as long as due credit is given                   }
; ------------------------------------------------------------------- }
;
; FUNCTION HasNumber({const} s: String): Boolean; Assembler;
; =====================================================================
; Returns TRUE if string contains any numeric characters
; ---------------------------------------------------------------------

model TPascal

.CODE

PUBLIC HasNumber

HasNumber PROC FAR s:DWORD

        les    DI, [ s ]
        mov    CL, ES:[ DI ]
        xor    CH, CH            ; init length and clear carry
        jcxz   @Exit             ; exit w/ CARRY CLEAR

@@1:    inc    DI
        mov    AL, ES:[ DI ]
        cmp    AL, '0'
        jc     @@2               ; NON-Numeric, continue checking
        cmp    AL, '9'+1
        jc     @Exit             ; Numeric, exit w/ CARRY SET
@@2:    LOOP   @@1


@Exit:  sbb    AL,AL
        and    AL,1
        ret

HasNumber ENDP
CODE ENDS
END



