; ******************************************************************* }
; Turbo Pascal Version 4.0 -> 7.0   64-Bit IEEE Double conversions    }
; ------------------------------------------------------------------- }
; Copyright 1992 Roger E. Donais                    <RDonais@gnn.com> }
; May be used freely as long as due credit is given                   }
; ------------------------------------------------------------------- }

MODEL TPascal

.CODE
		PUBLIC  FLOAT2STR, STR2FLOAT

		LOCALS  @@
; ---------------------------------------------------------------------
; type  Float = array[0.. 7] of byte;
;       dLong = array[0.. 7] of byte;
;
; TYPE dLong = array[0.. 7] of byte;   { Double long }
;      qLong = Array[0..1] of dLong;
;      tInternal = RECORD
;         number: qLong;
;         Sign  : Boolean;
;      End;

tInternal struc
   Numb db 16 DUP(?)
   Sign db ?
tInternal ENDS

; Function  Str2Float(var Number: Float; const Str: String): Boolean;
; ===================================================================
; Converts an integer or decimal string in the form of 123, or 123.45
; to a 64-Bit ieee double. Does not handle exponent notation (123E4)
; Returns TRUE if conversion was successful
; ===================================================================

; Function  Float2Str(var Number: Float; Precision : integer ) : string;
; ===================================================================
; Converts a 64-Bit ieee double to an ascii string with the specified
; number of decimal places.
; ===================================================================


; Routines assume ES == SS, forward direction (CLD)
; which is established upon entry into the above routines    ...red


lmul10:
; -------------------------------------------------------------------
; Multiplies a 64-Bit (dLong) integer at [ES:DI] by ten
; RETURNS    DI
; ALTERS     AX, BX, CX, DX, SI
; PRESERVES  DI, ES, DS, BP
; -------------------------------------------------------------------

      push  DI
      mov   CX, 4
      mov   BX, 10
      xor   SI, SI

@@1:  mov   AX, [ ES:DI ]
      mul   BX
      add   AX, SI
      adc   DX, 0
      stosw
      mov   SI, DX
      loop  @@1

      pop   DI
      ret
; ----


ldiv10:
; -------------------------------------------------------------------
; Divides a 64-Bit (dLong) integer at [ ES:DI ] by ten
; RETURNS    DI, Remainder in DX, AX = 0 when the dividend is zero
; ALTERS     AX, BX, CX, DX, SI
; PRESERVES  DI, ES, DS, BP
; -------------------------------------------------------------------

      push  DI
      add   DI, 6                ; Step to msw
      mov   CX, 4
      mov   BX, 10
      xor   SI, SI
      xor   DX, DX
      std

@@1:  mov   AX, [ ES:DI ]
      div   BX
      stosw
      or    SI, AX
      loop  @@1
      mov   AX, SI

      pop   DI
      cld                 ; restore fwd direction
      ret
; ----


Increment:
; -------------------------------------------------------------------
; Increments a 64-Bit (dLong) integer at [ES:DI] by amonut in AX
; RETURNS    DI
; ALTERS     AX, CX, DX
; PRESERVES  BX, SI, DI, ES, DS, BP
; -------------------------------------------------------------------

       push  DI
       xor   DX, DX             ; Clear carry for first add
       mov   CX, 4

@@1:   adc    [ ES:DI ], AX
       lea    DI, [ DI +2 ]
       mov    AX, DX
       loop   @@1

       pop    DI
       retn
; ----


rshift:
; -------------------------------------------------------------------
; Shift a 128-Bit (qLong) integer at [SS:DI] right by Count in AX
; RETURNS    DI
; ALTERS     AX, CX, DX, SI
; PRESERVES  BX, DI, ES, DS, BP
; -------------------------------------------------------------------

        cmp     AX, 0
		jna     @@Exit

		mov     DX, AX
		push    DI

		cmp     DX, 128
		jc      @@1

		mov     DX, 128

@@1:    lea     SI, [ DI+14 ]
		std

@@2:    mov     DI, SI
		xor     AX, AX
		mov     CX, 8

@@3:    mov     AX, ES:[ DI ]
		rcr     AX, 1
		stosw
		loop    @@3
		dec     DX
		jnz     @@2

		pop     DI
        cld                 ; restore fwd direction

@@exit: retn
; -----


lshift:
; -------------------------------------------------------------------
; Shift a 128-Bit (qLong) integer at [SS:DI] left by Count in AX
; RETURNS    DI
; ALTERS     AX, CX, DX, SI
; PRESERVES  BX, DI, ES, DS, BP
; -------------------------------------------------------------------

		cmp     AX, 0
		jna     @@Exit

		mov     DX, AX
		push    DI

		cmp     DX, 128
		jc      @@1

		mov     DX, 128

@@1:    mov     SI, DI

@@2:    mov     DI, SI
		xor     AX, AX
		mov     CX, 8

@@3:    mov     AX, ES:[ DI ]
		rcl     AX, 1
		stosw
		loop    @@3
		dec     DX
		jnz     @@2

		pop     DI

@@Exit: retn
; -----


; Function Float2Str(VAR Number : Float; Precision : integer ): String;
; ---------------------------------------------------------------------
Float2Str PROC FAR Number:DWORD, Precision:WORD RETURNS @Result:DWORD
          LOCAL DSreg:WORD, Temp:tInternal

      mov   [ DSreg ], DS
      push  SS
      pop   ES
      cld

      xor   AX, AX
      lds   SI, [ @Result ]
      mov   [ SI ], AL

      ; -------------------------------------------------------------------
      ; Convert float to internal representation
      ; -------------------------------------------------------------------

      ; capture mantissa}

      lds   SI, [ Number ]
      lea   DI, [ Temp   ]

      stosw
      stosw
      stosw
      stosw

      movsw                     ; Copy mantissa to whole number
      movsw
      movsw
      mov   AX, [ SI ]
      push  AX
      and   AX, 000Fh
      or    AL, 0010h          ; adjust mantissa and add in the high bit
      stosw                    ; tfraction[6] := tfraction[6] or 10h

      ; capture sign and exponent

      pop   AX

      shl   AX, 1
      sbb   DL, DL
      mov   [ ES:DI ], DL      ; Store sign to intermediate representation

      shr   AX, 1
      shr   AX, 1
      shr   AX, 1
      shr   AX, 1
      shr   AX, 1
      sub   AX, 03FFh
      js    @@2x

@@1x: cmp  AX, 52
      jge  @@4x

@@2x: neg    AX
      add    AX, 52

      lea    DI, [ Temp ]
      call   rshift

      xor    AX, AX

@@4x: or     AX, AX
      jnz    @@V0

      cmp   [ Temp.Sign ], 0
      jz    @@2

      mov   AL, '-'
      call  @PutC

@@2:  ; Punch out the whole number
      xor   CX, CX

@@L1: push  CX
      lea   DI, [ Temp + 8 ]
      call  lDiv10
      pop   CX

      inc   CX
      push  DX
      or    AX, AX
      jnz   @@L1

@@L2: pop   AX
      call  @PutN
      loop  @@L2

      mov   CX, [ Precision ]
      jcxz  @@9

      mov   AL,'.'
      call  @PutC

@@3:  push  CX
      lea   DI, [ Temp ]
      call  lmul10
      push  DX

      lea   DI, [ Temp+8 ]
      call  lmul10

      pop   AX
      call  Increment

      pop   CX
      loop  @@3

      lea   DI, [ Temp ]
      call  lmul10
      cmp   DX, 5
      jc    @@4

      lea   DI, [ Temp+8 ]
      mov   AX, 1
      call  Increment

@@4:  mov   CX, [ Precision ]

@@5:  push  CX
      lea   DI, [ Temp + 8 ]
      call  lDiv10
      pop   CX
      push  DX    ; save remainder
      loop  @@5

      mov   CX, [ Precision ]

@@6:  pop   AX
      call  @PutN
      loop  @@6
      jmp   SHORT @@9

@@V0: mov   AL,'*'
      mov   CX, 8

@@V1: call  @PutC
      loop  @@V1

@@9:  mov   DS, [ DSreg ]
      ret

; ---------------------------------------------
; Local routine: stores Hi.Temp at @Result[i]

@PutN: or AL, '0'
@PutC: lds   BX, [ @Result ]
       inc   BYTE PTR [ BX ]
       add   BL, [ BX ]
       adc   BH, 0
       mov   [ BX ], AL
       retn

Float2Str ENDP


; Function Str2Float(var Number: Float; const S: String): Boolean;
; -------------------------------------------------------------------
Str2Float PROC FAR Number:DWORD, S:DWORD
    LOCAL DSreg:Word, Exp10:WORD, Exp2:WORD, Temp:tInternal, @Sign:BYTE, @Tic:BYTE, @Okay:BYTE

      mov   [ DSreg ], DS
      push  SS
      pop   ES
      cld

      xor    AX, AX
      mov    [ Exp10 ], AX
      mov    [ Exp2  ], AX
      mov    [ @Tic  ], AL
      mov    [ @Sign ], AL

      call   @Clear             ; retunrs w/ CX == 0

      lds    SI, [ S ]
      lodsb
      mov    CL, AL             ; Can't reach @@99, so goto @Zero
      jcxz   @Bad

      inc    CX

@@1:  call   @Char
      cmp    AL,' '+1
      jc     @@1

@@2:  cmp    AL,'+'
      jz     @2a

      cmp    AL,'-'
      jnz    @2x

      inc    [ @Sign ]

@2a:
@3a:  call   @Char
@2x:

@@3:  cmp    AL,'0'
      jc     @3x
      cmp    AL,'9'+1
      jnc    @3x
      call   @Bump
      jmp    SHORT @3a

@3x:  cmp    AL,'.'     ; bad number if non-digit is not a decimal
      jnz    @Bad

@4a:  call   @Char

@@4:  cmp    AL,'0'
      jc     @4x
      cmp    AL,'9'+1
      jnc    @4x

      call   @Bump
      dec    [ Exp10 ]
      jmp    SHORT @4a

; ---------------------------------------------
; RETURN w/ CX == 0
@Clear: lea    DI, [ Temp ]
        xor    AX, AX
        mov    [ @Sign ], AL
        mov    [ @Okay ], 1
        mov    CX, 8
        REP    stosw
        stosb
        retn

; ---------------------------------------------
@Bump:  push   DS
        push   SI
        push   CX
        and    AX, 000Fh
        or     [ @Tic ], AL
        push   AX
        lea    DI, [ Temp ]
        call   lMul10
        pop    AX
        call   Increment
        pop    CX
        pop    SI
        pop    DS
        retn


@Bad: mov    [ @Okay ], 0

@4x:
@Zero:
      call   @Clear
      jmp    @@99

     ; at this point we have a de-normalized mantissa in temp
     ; We now need to right justify the fraction

@Ch:  lodsb
      retn

@Char:
      loop   @Ch
      pop    AX                 ; remove caller

      ;mov    DS, [ DSreg ]
      cmp    [ @Tic ], 0
      jz     @Bad              ; return zero on bad number

     ; at this point we have a de-normalized mantissa in temp
     ; We now need to right justify the fraction

      jmp    SHORT @@6

@6b:  lea    DI, [ Temp ]
      mov    AX, 1
      call   rshift
      inc    [ Exp2 ]

@6a:  test   [ WORD PTR Temp +6 ], 0FFF0h
      jnz    @6b

      lea    DI, [ Temp ]
      call   lMul10
      dec    [ Exp10 ]

@@6:  cmp    [ Exp10 ], 0
      jg     @6a

      xor    DX, DX             ; Remainder = 0
      jmp    SHORT @@7

@7b:  lea    DI, [ Temp ]
      mov    AX, 1
      call   lshift
      dec    [ Exp2 ]

@7a:  test   [ BYTE PTR Temp+6 ], 80h
      jz     @7b

      lea    DI, [ Temp ]
      call   lDiv10
      inc    [ Exp10 ]

@@7:  cmp    [ Exp10 ], 0
      jl     @7a

      lea    DI, [ Temp ]
      mov    AX, DX
      call   Increment

      jmp    SHORT @@8

@8a:  lea    DI, [ Temp ]
      mov    AX, 1
      call   lshift
      dec    [ Exp2 ]

@@8:  test   [ BYTE PTR Temp +6 ], 10h
      jz     @8a

      and    [ WORD PTR Temp +6 ], 0Fh
      mov    AX, [ Exp2 ]
      add    AX, 1023 + 52
      shl    AX, 1
      shl    AX, 1
      shl    AX, 1
      shl    AX, 1
      or     [ WORD PTR Temp+6 ], AX

      cmp    [ @Sign ], 0
      jz     @@99

      xor    [ BYTE PTR Temp +7 ], 80h

@@99: lea    SI, [ Temp ]
      push   SS
      pop    DS
      les    DI, [ Number ]
      movsw
      movsw
      movsw
      movsw

      mov    DS, [ DSreg ]
      mov    AL, [ @Okay ]
      ret

Str2Float ENDP

CODE  ENDS
      END
