; TUBRO Pascal version 4.0   EXTERNAL FUNCTION                 ...red }
; =================================================================== }
; Copyright 1996 Roger E. Donais              <rdonais@southeast.net> }
; May be used freely as long as due credit is given                   }
; ------------------------------------------------------------------- }
;
; PROCEDURE Normalize(VAR p: Pointer);
; FUNCTION  FarPtr(p: Pointer): Pointer;
; ---------------------------------------------------------------------

CODE    SEGMENT
ASSUME  CS:CODE

      PUBLIC Normalize, FarPtr

; -----------------------------------------------
Normalize:  db   0B9h              ; mov CX, imm16
FarPtr:     xor  CX, CX            ; 2-byte opcode

            mov  BX, SP
            les  DI, SS:[BX+4]
            jcxz @Adj

            les  DI, ES:[DI]       ; Dereference VAR Parameter

@Adj:       mov  DX,DI             ; Convert offset
            shr  DX,1              ;   to segment value
            shr  DX,1
            shr  DX,1
            shr  DX,1
            mov  AX,ES             ; Retrieve current segment
            add  DX,AX             ;   and combine w/adjusted ofs
            mov  AX,0Fh            ; Get paragraph mask
            and  AX,DI             ;   normalize offset 0..15
            jcxz @Exit

            les  DI, SS:[BX+4]     ; Retrieve VAR parameter
            mov  ES:[DI+0], AX     ;   and store result
            mov  ES:[DI+2], DX

@Exit:      retf 4

CODE ENDS
END
