; TUBRO Pascal version 4.0   EXTERNAL FUNCTION        89/05/15 ...red }
; =================================================================== }
; Copyright 1996 Roger E. Donais              <rdonais@southeast.net> }
; May be used freely as long as due credit is given                   }
; ------------------------------------------------------------------- }

; FUNCTION Count(SubString,MainString: String): Integer;
; { =================================================================== }
; { Returns the count of the number of occurances of "SubString" in     }
; { "MainString".                                                       }
; { =================================================================== }

CODE     SEGMENT   BYTE
ASSUME   CS:CODE,DS:CODE,ES:CODE,SS:CODE

         PUBLIC Count,Dcount
PROCESS  PROC FAR

MainStr = DWORD PTR BP+8
Fence   = DWORD PTR BP+12

COUNT   LABEL FAR
         db 0Ch    ; Clear carry   (or AL,imm8)

DCOUNT  LABEL FAR
         stc       ; Set carry     (1-Byte opcode)

         push   DS
         push   BP
         mov    BP,SP

         mov    AX, 0            ; preserve carry flag

         cld
         lds    SI,[Fence]
         les    DI,[MainStr]
         mov    CL,ES:[DI]
         mov    CH,0
         jcxz   @@2              ; Null MainStr returns 0 Count, 0 Field

         pushf
         mov    DX,CX
         mov    CL,[SI]
         jcxz   @@3              ; No SubStr retuns 0 Count, or 1 Field

         sub    DX,CX
         jb     @@3              ; No match retuns 0 Count, or 1 Field

         inc    SI

@@1:     inc    DI
         push   CX
         push   SI
         push   DI
         rep    CMPSB
         pop    DI
         pop    SI
         pop    CX
         jne    @@4

         inc    AX               ; Increment occurance

@@4:     dec    DX
         jns    @@1

@@3:     popf                    ; DCOUNT returns number of fields
         adc    AX,0             ; Count  returns number of occurances

@@2:     pop    BP
         pop    DS
exit:    retf   8

PROCESS  ENDP
CODE     ENDS
         END

