; TUBRO Pascal version 4.0   EXTERNAL FUNCTION                 ...red }
; =================================================================== }
; Copyright 1996 Roger E. Donais              <rdonais@southeast.net> }
; May be used freely as long as due credit is given                   }
; ------------------------------------------------------------------- }
;
; FUNCTION LChar(const s: String): Char;
; FUNCTION IdxAt(const s: String;  Idx: Byte): Integer;
; FUNCTION CharAt(const s: String; Idx: Integer): Char;
; =====================================================================

        MODEL  Tpascal

        .CODE

        PUBLIC IdxAT, CharAt, LChar

; FUNCTION IdxAt(const s: String;  Idx: Byte): Integer;
; ---------------------------------------------------------------------
IdxAt PROC FAR S:DWORD, Idx:WORD

        les    BX, [ s ]
        mov    AX, [ idx ]

        SegES
        xlat

        xor    AH, AH
        ret

IdxAt ENDP


; FUNCTION CharAt(const s: String; Idx: Integer): Char;
; ---------------------------------------------------------------------
CharAt PROC FAR S:DWORD, Idx:WORD

        push   DS
        xor    AX, AX           ; assume failure
        lds    BX, [ s ]
        mov    CX, [ idx ]

        or     CH, CH
        jnz    @Exit            ; idx > 256, or idx < 0
        jcxz   @Exit            ; idx = 0 }

        cmp    [ BX ], CL
        jc     @Exit            ; idx > length(s)

        add    BX, CX
        mov    AL, [ BX ]

@Exit:  pop    DS
        ret

CharAt  ENDP


; FUNCTION LChar(const s: String): Char;
; ---------------------------------------------------------------------
LChar  PROC FAR S:DWORD

       push   DS
       lds    BX, [ s ]
       mov    AL, [ BX ]

       XLAT

       pop    DS
       ret

LChar  ENDP

CODE   ENDS
       END
