; TUBRO Pascal version 4.0   EXTERNAL FUNCTION        89/05/15 ...red }
; =================================================================== }
; Copyright 1996 Roger E. Donais              <rdonais@southeast.net> }
; May be used freely as long as due credit is given                   }
; ------------------------------------------------------------------- }

; FUNCTION BeforeLast(SubStr,MainStr: String): String;
; { =================================================================== }
; { Returns the portion of "MainStr" to the left of the last occurance  }
; { of "SubStr", or all of "MainStr" if "SubStr" does not occur         }
; { =================================================================== }
; VAR i: Integer;
;
; BEGIN{BeforeLast}
;
;     i := Lpos(SubStr,MainStr);
;     If i = 0 Then
;        BeforeLast := MainStr
;     Else BeforeLast := Copy(MainStr,1,Pred(i));
;
; END{BeforeLast};

       MODEL  Tpascal

       .CODE

       EXTRN  Lpos:FAR

       PUBLIC BeforeLast

LSW = WORD PTR 0
MSW = WORD PTR 2

BeforeLast PROC FAR SubString:DWORD, MainString:DWORD RETURNS Result:DWORD

         push    DS

         push    [ SubString.MSW ]
         push    [ SubString.LSW ]

         push    [ MainString.MSW ]
         push    [ MainString.LSW ]
         call    Lpos
         mov     CX,AX

         CLD
         lds     SI,[ MainString ]
         les     DI,[ Result ]
         lodsb
         jcxz    @@1

         ; Result := Copy(MainStr,1,Pred(i));

         dec     CX
         jmp     SHORT @@2

         ; Result := MainStr
@@1:     mov     CL,AL
@@2:     mov     AL,CL
         stosb
         rep     movsb

         pop     DS
         ret

BeforeLast ENDP
CODE       ENDS
           END

