%pushlctl
%nolist

; *******************************************************
; *                                                     *
; *     VERSION CONTROL EQUATES                         *
; *                                                     *
; *******************************************************

; Boolean values

FALSE           EQU     0
TRUE            EQU     NOT FALSE

; Version equates

    IFDEF _Windows_
WindowsVersion  EQU     TRUE
DPMIVersion     EQU     FALSE
    ELSE
    IFDEF _DPMI_
WindowsVersion  EQU     FALSE
DPMIVersion     EQU     TRUE
    ELSE
WindowsVersion  EQU     FALSE
DPMIVersion     EQU     FALSE
    ENDIF
    ENDIF

; *******************************************************
; *                                                     *
; *     MACROS                                          *
; *                                                     *
; *******************************************************

        LOCALS  @@

; Public variable definition macro

VAR MACRO Symbol,SType,Count
  PUBLIC Symbol
  Symbol LABEL SType
  IF Count
    DB SType * Count DUP(?)
  ENDIF
ENDM

; Parameter definition macro

ARG MACRO Symbol,SType,Count
  LOCAL Offset
  @AP = @AP + SType * Count
  Offset = @AP
  Symbol EQU (SType PTR [BP+@AF-Offset])
ENDM

@AP = 0
@AF = 0

; Local variables definition macro

LOC MACRO Symbol,SType,Count
  LOCAL Offset
  @LP = @LP + SType * Count
  Offset = @LP
  Symbol EQU (SType PTR [BP+@LF-Offset])
ENDM

@LP = 0
@LF = 0

; Stack frame modifiers

sfFar           EQU     01H            ; FAR frame
sfMarkBP        EQU     02H            ; Make saved BP odd
sfSaveDS        EQU     04H            ; Save DS at [BP-2]
sfInitDS        EQU     08H            ; Init DS using SS

; Default stack frame type

sfDefault = 0

; Stack frame types

    IF WindowsVersion
WINFAR          EQU     sfFar+sfMarkBP+sfSaveDS
    ELSE
WINFAR          EQU     sfFar
    ENDIF

; Entry code generation macro

ENTRY MACRO FrameType
  IFB <FrameType>
    @SF = sfDefault
  ELSE
    IFIDNI <FrameType>,<NEAR>
      @SF = 0
    ELSE
      IFIDNI <FrameType>,<FAR>
        @SF = sfFar
      ELSE
        @SF = FrameType
      ENDIF
    ENDIF
  ENDIF
  IF @SF AND sfMarkBP
    INC   BP
  ENDIF
    PUSH  BP
    MOV   BP, SP
  IF @SF AND sfFar
    @AF = @AP + 6
  ELSE
    @AF = @AP + 4
  ENDIF
  IF @SF AND sfSaveDS
    PUSH  DS
    @LF = -2
  ELSE
    @LF = 0
  ENDIF
  IF @LP
    SUB   SP, @LP
  ENDIF
  IF @SF AND sfInitDS
    PUSH  DS
    PUSH  SS
    POP   DS
  ENDIF
ENDM

; Exit code generation macro

EXIT MACRO ArgSize
  IF @SF AND sfInitDS
    POP   DS
  ENDIF
  IF @LF - @LP
    MOV   SP, BP
  ENDIF
    POP   BP
  IF @SF AND sfMarkBP
    DEC   BP
  ENDIF
  IFNB <ArgSize>
    @AP = ArgSize
  ENDIF
  IF @SF AND sfFar
    RETF  @AP
  ELSE
    RETN  @AP
  ENDIF
  @AP = 0
  @LP = 0
ENDM

; *******************************************************
; *                                                     *
; *     EQUATES                                         *
; *                                                     *
; *******************************************************

; 10-Byte record

b0              EQU   (BYTE PTR 0)
b1              EQU   (BYTE PTR 1)
b2              EQU   (BYTE PTR 2)
b3              EQU   (BYTE PTR 3)
b4              EQU   (BYTE PTR 4)
b5              EQU   (BYTE PTR 5)
b6              EQU   (BYTE PTR 6)
b7              EQU   (BYTE PTR 7)
b8              EQU   (BYTE PTR 8)
b9              EQU   (BYTE PTR 9)

; 5-Word record

w0              EQU   (WORD PTR 0)
w2              EQU   (WORD PTR 2)
w4              EQU   (WORD PTR 4)
w6              EQU   (WORD PTR 6)
w8              EQU   (WORD PTR 8)

; Pointer record

ofs             EQU   (WORD PTR 0)
seg             EQU   (WORD PTR 2)

; 8087 status word masks

mIE             EQU   0001H            ; invalid operation exception
mDE             EQU   0002H            ; denormal exception
mZE             EQU   0004H            ; zero-divide exception
mOE             EQU   0008H            ; overflow exception
mUE             EQU   0010H            ; underflow exception
mPE             EQU   0020H            ; precision exception
mSF             EQU   0040H            ; stack fault
mAE             EQU   0080H            ; any exception

mC0             EQU   0100H            ; carry
mC1             EQU   0200H            ; no flag, sign of arg for FXAM
mC2             EQU   0400H            ; parity
mC3             EQU   4000H            ; zero

mTOS            EQU   3800H            ; TOS

mBUSY           EQU   8000H            ; FPU busy

; 8087 rounding and precision control

mRC             EQU   F3H              ; AND to set round control
mrcNE           EQU   00H              ; round to nearest or even
mrcDN           EQU   04H              ; round down
mrcUP           EQU   08H              ; round up
mrcTR           EQU   0CH              ; truncate

mPC             EQU   FCH              ; AND to set precision control
mpc24           EQU   00H              ; 24 bit
mpcRES          EQU   01H              ; reserved
mpc53           EQU   02H              ; 53 bits
mpc64           EQU   03H              ; 64 bits

; ASCII equates

bell            EQU   07H
bs              EQU   08H
tab             EQU   09H
lf              EQU   0AH
cr              EQU   0DH
eof             EQU   1AH
esc             EQU   1BH
del             EQU   7FH

; CRT Coordinate record

CrtX            EQU   (BYTE PTR 0)
CrtY            EQU   (BYTE PTR 1)

; DOS interrupt vector number

DOS             EQU   21H

; DOS function codes

dosSetDrive     EQU   0EH

dosGetDrive     EQU   19H
dosSetDTA       EQU   1AH

dosSetInt       EQU   25H
dosCreatePSP    EQU   26H
dosParse        EQU   29H
dosGetDate      EQU   2AH
dosSetDate      EQU   2BH
dosGetTime      EQU   2CH
dosSetTime      EQU   2DH
dosSetVerify    EQU   2EH
dosGetDTA       EQU   2FH

dosGetVersion   EQU   30H
dosTSR          EQU   31h
dosGetBreak     EQU   3300h
dosSetBreak     EQU   3301h
dosGetBoot      EQU   3305h
dosTrueVersion  EQU   3306h
dosGetInDOS     EQU   34h
dosGetInt       EQU   35H
dosGetSpace     EQU   36H
dosGetCountry   EQU   38H
dosCreateDir    EQU   39H
dosRemoveDir    EQU   3AH
dosSetDir       EQU   3BH
dosCreate       EQU   3CH
dosOpen         EQU   3DH
dosClose        EQU   3EH
dosRead         EQU   3FH

dosWrite        EQU   40H
dosDelete       EQU   41H
dosSeek         EQU   42H
dosSeekStart    EQU   4200H
dosSeekCurrent  EQU   4201H
dosSeekEnd      EQU   4202H
dosAttrib       EQU   43H
dosGetAttr      EQU   4300h
dosSetAttr      EQU   4301h
dosIOCtl        EQU   44H
dosDupHandle    EQU   45h
dosFDupHandle   EQU   46h
dosGetDir       EQU   47H
dosGetMem       EQU   48H
dosFreeMem      EQU   49H
dosSetMem       EQU   4AH
dosExec         EQU   4BH
dosExit         EQU   4CH
dosGetExit      EQU   4DH
dosFindFirst    EQU   4EH
dosFindNext     EQU   4FH

dosSetPSP       EQU   50H
dosGetPSP       EQU   51H
dosGetList      EQU   52H
dosGetVerify    EQU   54H
dosMakePSP      EQU   55H
dosRename       EQU   56H
dosFDate        EQU   57H
dosGetAlloc     EQU   5800h
dosSetAlloc     EQU   5801h
dosGetUMBAlloc  EQU   5802h
dosSetUMBAlloc  EQU   5803h
dosCreateTemp   EQU   5Ah
dosTruename     EQU   60h

; Program segment prefix variables

pspMemTop       EQU   (WORD PTR 02H)
pspFileTab      EQU   (BYTE PTR 18H)
pspEnvSeg       EQU   (WORD PTR 2CH)
pspFCB1         EQU   (BYTE PTR 5CH)
pspFCB2         EQU   (BYTE PTR 6CH)
pspCmdLine      EQU   (BYTE PTR 80H)

; Free-list memory record layout

mNext           EQU   (DWORD PTR 0)
mSize           EQU   (DWORD PTR 4)
mRecSize        EQU   8

; File record layout

fHandle         EQU   (WORD PTR 0)
fMode           EQU   (WORD PTR 2)
fBufSize        EQU   (WORD PTR 4)
fPrivate        EQU   (WORD PTR 6)
fBufPos         EQU   (WORD PTR 8)
fBufEnd         EQU   (WORD PTR 10)
fBufPtr         EQU   (DWORD PTR 12)
fOpenProc       EQU   (DWORD PTR 16)
fInOutProc      EQU   (DWORD PTR 20)
fFlushProc      EQU   (DWORD PTR 24)
fCloseProc      EQU   (DWORD PTR 28)
fUserData       EQU   (BYTE PTR 32)
fName           EQU   (BYTE PTR 48)
fBuffer         EQU   (BYTE PTR 128)
fRecSize        EQU   256

; fMode values

fmClosed        EQU   0D7B0H
fmInput         EQU   0D7B1H
fmOutput        EQU   0D7B2H
fmInOut         EQU   0D7B3H

; Overlay header record

ovSignature     EQU   (WORD PTR 0)
ovSaveReturn    EQU   (WORD PTR 2)
ovFilePos       EQU   (WORD PTR 4)
ovCodeSize      EQU   (WORD PTR 8)
ovFixupSize     EQU   (WORD PTR 10)
ovJumpCount     EQU   (WORD PTR 12)
ovLink          EQU   (WORD PTR 14)
ovSegment       EQU   (WORD PTR 16)
ovRetryCount    EQU   (WORD PTR 18)
ovNext          EQU   (WORD PTR 20)
ovEmsPage       EQU   (WORD PTR 22)
ovEmsOffset     EQU   (WORD PTR 24)
ovUserData      EQU   (BYTE PTR 26)
ovVectors       EQU   (BYTE PTR 32)
ovRecSize       EQU   32

; Windows data segment variables

pPtrCount       EQU   (WORD PTR DS:04H)
pLocalHeap      EQU   (WORD PTR DS:06H)
pAtomTable      EQU   (WORD PTR DS:08H)
pStackTop       EQU   (WORD PTR DS:0AH)
pStackBot       EQU   (WORD PTR DS:0CH)
pStackMin       EQU   (WORD PTR DS:0EH)

; DPMI interrupt vector

DPMI            EQU   31H

; DPMI function codes

dpmiGetDesc     EQU   0000H            ; Allocate descriptors
dpmiFreeDesc    EQU   0001H            ; Free descriptor
dpmiSegToDesc   EQU   0002H            ; Map segment to descriptor
dpmiGetSelInc   EQU   0003H            ; Get selector increment value
dpmiGetSegBase  EQU   0006H            ; Get segment base address
dpmiSetSegBase  EQU   0007H            ; Set segment base address
dpmiSetSegSize  EQU   0008H            ; Set segment size
dpmiGetRealInt  EQU   0200H            ; Get real mode int handler
dpmiSetRealInt  EQU   0201H            ; Set real mode int handler
dpmiGetExcept   EQU   0202H            ; Get exception handler
dpmiSetExcept   EQU   0203H            ; Set exception handler
dpmiGetInt      EQU   0204H            ; Get interrupt handler
dpmiSetInt      EQU   0205H            ; Set interrupt handler
dpmiGetRMCB     EQU   0303H            ; Get real mode call-back
dpmiGetVersion  EQU   0400H            ; Get version information

; Real mode call-back registers structure

realDI          EQU   (DWORD PTR 00H)
realSI          EQU   (DWORD PTR 04H)
realBP          EQU   (DWORD PTR 08H)
realBX          EQU   (DWORD PTR 10H)
realDX          EQU   (DWORD PTR 14H)
realCX          EQU   (DWORD PTR 18H)
realAX          EQU   (DWORD PTR 1CH)
realFlags       EQU   (WORD PTR 20H)
realES          EQU   (WORD PTR 22H)
realDS          EQU   (WORD PTR 24H)
realFS          EQU   (WORD PTR 26H)
realGS          EQU   (WORD PTR 28H)
realIP          EQU   (WORD PTR 2AH)
realCS          EQU   (WORD PTR 2CH)
realSP          EQU   (WORD PTR 2EH)
realSS          EQU   (WORD PTR 30H)
realRegsSize    EQU   32H

JMPS            EQU   <JMP SHORT>

; Shortcut opcodes

scSin           EQU   90ECH
scCos           EQU   90EEH
scTan           EQU   90F0H
scArcTan        EQU   90F2H
scLog           EQU   90F4H
scLog2          EQU   90F6H
scLog10         EQU   90F8H
scExp           EQU   90FAH
scExp2          EQU   90FCH
scExp10         EQU   90FEH

; XMS function codes

xmsGetVersion   EQU   00H
xmsReqHMA       EQU   01H
xmsRelHMA       EQU   02H
xmsGlobEnaA20   EQU   03H
xmsGlobDisA20   EQU   04H
xmsLocEnaA20    EQU   05H
xmsLocDisA20    EQU   06H
xmsQueryA20     EQU   07H
xmsQueryMem     EQU   08H
xmsAllocEMB     EQU   09H
xmsFreeEMB      EQU   0AH
xmsMoveEMB      EQU   0BH
xmsLockEMB      EQU   0CH
xmsUnlockEMB    EQU   0DH
xmsGetHandle    EQU   0EH
xmsReAllocEMB   EQU   0FH
xmsReqUMB       EQU   10H
xmsRelUMB       EQU   11H
xmsReAllocUMB   EQU   12H
xmsQueryMem32   EQU   88H
xmsAllocEMB32   EQU   89H
xmsGetHandle32  EQU   8EH
xmsReAllocEMB32 EQU   8FH

; Size of emulator data in stack segment

emDataSize      EQU   230

    IF DPMIVersion

emws_offset     = 10h

    ELSE

emws_offset     = 0

    ENDIF

emws_limitSP    = 0    + emws_offset
emws_initialSP  = 0C0h + emws_offset
emws_saveVector = 0CCh + emws_offset
emws_nmiVector  = 0D0h + emws_offset
emws_status     = 0D4h + emws_offset
emws_control    = 0D6h + emws_offset
emws_TOS        = 0D8h + emws_offset
emws_adjust     = 0DAh + emws_offset
emws_fixSeg     = 0DCh + emws_offset
emws_BPsafe     = 0DEh + emws_offset
emws_stamp      = 0E0h + emws_offset
emws_version    = 0E4h + emws_offset

%poplctl