; *******************************************************
; *                                                     *
; *     Turbo Pascal Runtime Library Version 6.0/7.0    *
; *     CRT Delay function                              *
; *                                                     *
; *     Copyright (C) 2000-2002 Robert AH Prins         *
; *                                                     *
; *******************************************************

        TITLE   CRTDELAY

        INCLUDE SE.ASM

        .386

; BIOS workspace equates

Timer   EQU   (DWORD PTR 6CH)

DATA    SEGMENT WORD PUBLIC USE16

        EXTRN   DelayCnt: DWORD
        EXTRN   Seg0040 : WORD

DATA    ENDS

CODE    SEGMENT BYTE PUBLIC USE16
        ASSUME  CS:CODE,DS:DATA

; Publics

        PUBLIC  Delay

;-------------------------------------------------------------------------------
; InitDelay initialises the DelayCnt variable. It is called when Delay is called
; for the very first time, thereby eliminating the code normally associated by
; the CRT initialisation code for the Delay function, saving a bit of code when
; Delay is not used at all.
;
; A small drawback of this method is the fact that the first call of Delay will
; be fractionally less accurate than specified. If this is undesired, a dummy
; Delay(1) can be inserted directly at the start of the program.
;-------------------------------------------------------------------------------

InitDelay PROC NEAR

        mov   di, offset Timer
        mov   bl, es:[di]

@@1:    cmp   bl, es:[di]
        je    @@1

        mov   bl, es:[di]

        mov   eax, -28           ; change for fine-tuning...
        call  DelayLoop
        not   eax

; Timer: 1,193,180 Hz
; PIT  : 65,536
; Clock: 54.92549321981 ms

        mov   ebx, 78196245      ; (2 ** 32 + 54.925... - eps) div 54.925...
        mul   ebx
        mov   DelayCnt, edx
        ret

InitDelay ENDP

;-------------------------------------------------------------------------------
; procedure Delay(MS: Word); far;
;
; Delay specified number of milliseconds
;-------------------------------------------------------------------------------

Delay PROC FAR

        mov   bx, sp
        mov   cx, ss:[bx + 4]
        test  cx, cx
        jz    @@3

        mov   es, Seg0040

        cmp   DelayCnt, -1
        jne   @@1

        call  InitDelay

@@1:    xor   di, di
        mov   bl, es:[di]

@@2:    mov   eax, DelayCnt
        call  DelayLoop

        dec   cx
        jnz   @@2

@@3:    ret   2

Delay ENDP

; Delay one timer tick

DelayLoop PROC NEAR

@@1:    sub   eax, 1
        jc    @@2

        cmp   bl, es:[di]
        je    @@1

@@2:    ret

DelayLoop ENDP

CODE    ENDS

        END