{*******************************************************}
{                                                       }
{       Turbo Pascal Runtime Library Version 6.0/7.0    }
{       CRT Interface Unit                              }
{                                                       }
{       Copyright (C) 1988,91   Borland International   }
{       Copyright (C) 2000-2002 Robert AH Prins         }
{                                                       }
{*******************************************************}

unit Crt;

{$I-,S-}

interface

const

{ CRT modes }

  BW40         = 0;            { 40x25 B/W on Color Adapter   }
  CO40         = 1;            { 40x25 Color on Color Adapter }
  BW80         = 2;            { 80x25 B/W on Color Adapter   }
  CO80         = 3;            { 80x25 Color on Color Adapter }
  Mono         = 7;            { 80x25 on Monochrome Adapter  }
  Font8x8      = 256;          { Add-in for ROM font          }

{ Mode constants for 3.0 compatibility }

  C40          = CO40;
  C80          = CO80;

{ Foreground and background color constants }

  Black        = 0;
  Blue         = 1;
  Green        = 2;
  Cyan         = 3;
  Red          = 4;
  Magenta      = 5;
  Brown        = 6;
  LightGray    = 7;

{ Foreground color constants }

  DarkGray     =  8;
  LightBlue    =  9;
  LightGreen   = 10;
  LightCyan    = 11;
  LightRed     = 12;
  LightMagenta = 13;
  Yellow       = 14;
  White        = 15;

{ Add-in for blinking }

  Blink        = 128;

{ Interface variables }

var CheckBreak : Boolean;   { Enable Ctrl-Break              }
    CheckEOF   : Boolean;   { Enable Ctrl-Z                  }
    DirectVideo: Boolean;   { Enable direct video addressing }
    CheckSnow  : Boolean;   { Enable snow filtering          }
    LastMode   : Word;      { Current text mode              }
    TextAttr   : Byte;      { Current text attribute         }
    WindMin    : Word;      { Window upper left coordinates  }
    WindMax    : Word;      { Window lower right coordinates }

{ Interface procedures }

procedure AssignCrt(var F: Text);          { CRT.ASM      }
function  KeyPressed: Boolean;             { CRTKEYP.ASM  }
function  ReadKey: Char;                   { CRT.ASM      }
procedure TextMode(Mode: Integer);         { CRTTMODE.ASM }
procedure Window(X1,Y1,X2,Y2: Byte);       { CRTWIND.ASM  }
procedure GotoXY(X,Y: Byte);               { CRTGOXY.ASM  }
function  WhereX: Byte;                    { CRTWHERX.ASM }
function  WhereY: Byte;                    { CRTWHERY.ASM }
procedure ClrScr;                          { CRTCLSCR.ASM }
procedure ClrEol;                          { CRTCLEOL.ASM }
procedure InsLine;                         { CRTIDLIN.ASM }
procedure DelLine;                         { CRTIDLIN.ASM }
procedure TextColor(Color: Byte);          { CRTTCOL.ASM  }
procedure TextBackground(Color: Byte);     { CRTTBACK.ASM }
procedure LowVideo;                        { CRTLOW.ASM   }
procedure HighVideo;                       { CRTHIGH.ASM  }
procedure NormVideo;                       { CRTNORM.ASM  }
procedure Delay(MS: Word);                 { CRTDELAY.ASM }
procedure Sound(Hz: Word);                 { CRTSOUND.ASM }
procedure NoSound;                         { CRTNOSND.ASM }

implementation

var CurCrtSize: word;
var NormAttr  : byte;
var ScanCode  : byte;
var BreakFlag : byte;
var PageNo    : byte;

const DelayCnt: longint = -1;

{$IFNDEF VER70}
const Seg0040 : word = $0040;
const SegB000 : word = $B000;
const SegB800 : word = $B800;
{$ENDIF}

const Int16Enh: word = $0100;

{$IFDEF DPMI}
  {$L CRT.OBP}
{$ELSE}
  {$L CRT.OBJ}
{$ENDIF}

{$L CRTKEYP.OBJ  }
{$L CRTTMODE.OBJ }
{$L CRTWIND.OBJ  }
{$L CRTGOXY.OBJ  }
{$L CRTWHERX.OBJ }
{$L CRTWHERY.OBJ }
{$L CRTCLSCR.OBJ }
{$L CRTCLEOL.OBJ }
{$L CRTIDLIN.OBJ }
{$L CRTTCOL.OBJ  }
{$L CRTTBACK.OBJ }
{$L CRTLOW.OBJ   }
{$L CRTHIGH.OBJ  }
{$L CRTNORM.OBJ  }
{$L CRTDELAY.OBJ }
{$L CRTSOUND.OBJ }
{$L CRTNOSND.OBJ }

procedure Initialize; external;     { CRT.ASM      }
procedure AssignCrt; external;      { CRT.ASM      }
function  KeyPressed; external;     { CRTKEYP.ASM  }
function  ReadKey; external;        { CRT.ASM      }
procedure TextMode; external;       { CRTTMODE.ASM }
procedure Window; external;         { CRTWIND.ASM  }
procedure GotoXY; external;         { CRTGOXY.ASM  }
function  WhereX; external;         { CRTWHERX.ASM }
function  WhereY; external;         { CRTWHERY.ASM }
procedure ClrScr; external;         { CRTCLSCR.ASM }
procedure ClrEol; external;         { CRTCLEOL.ASM }
procedure InsLine; external;        { CRTIDLIN.ASM }
procedure DelLine; external;        { CRTIDLIN.ASM }
procedure TextColor; external;      { CRTTCOL.ASM  }
procedure TextBackground; external; { CRTTBACK.ASM }
procedure LowVideo; external;       { CRTLOW.ASM   }
procedure HighVideo; external;      { CRTHIGH.ASM  }
procedure NormVideo; external;      { CRTNORM.ASM  }
procedure Delay; external;          { CRTDELAY.ASM }
procedure Sound; external;          { CRTSOUND.ASM }
procedure NoSound; external;        { CRTNOSND.ASM }

{*****************************************************
* The following procedures are internal to the unit, *
* but TP 5.0/5.5 will not compile it if they are not *
* included here. They don't do any harm for TP6/BP7. *
*****************************************************}
procedure CrtInit; external;        { CRT.ASM      }
procedure CrtSetup; external;       { CRT.ASM      }
procedure BreakCheck; external;     { CRT.ASM      }
procedure SetCursor; external;      { CRT.ASM      }
procedure GetCursor; external;      { CRT.ASM      }
procedure Video; external;          { CRT.ASM      }

procedure Break;
begin
  Halt(255);
end;

begin
  Initialize;

  AssignCrt(Input);
  Reset(Input);

  AssignCrt(Output);
  Rewrite(Output);
end.