; *******************************************************
; * Copyright (C) 1989-1993 Norbert Juffa               *
; * Copyright (C) 2000-2002 Robert AH Prins             *
; *                                                     *
; * Routine to return the number of milliseconds        *
; * elapsed since midnight.                             *
; *******************************************************

             TITLE   CLOCK

             .386

DATA         SEGMENT WORD PUBLIC USE16

; Externals

             EXTRN   Seg0040: WORD

DATA         ENDS

CODE         SEGMENT BYTE PUBLIC USE16
             ASSUME  CS:CODE,DS:DATA

; Publics

             PUBLIC  Clock

;-------------------------------------------------------------------------------
;
; On exit:   DX:AX   time elapsed since midnight in milliseconds
;-------------------------------------------------------------------------------

Clock   PROC  FAR

        push  ds                  ; save caller's data segment

        mov   ds, Seg0040         ; access ticker counter
        mov   bx, 6ch             ; offset of ticker counter in segm.
        mov   dx, 43h             ; timer chip control port
        mov   al, 4               ; freeze timer 0
        mov   edi, [bx]           ; read BIOS ticker counter
        out   dx, al              ; latch timer 0
        mov   esi, [bx]           ; read BIOS ticker counter
        in    al, 40h             ; read latched timer 0 lo-byte
        mov   ah, al              ; save lo-byte
        in    al, 40h             ; read latched timer 0 hi-byte
        xchg  al, ah              ; correct order of hi and lo
        cmp   edi, esi            ; ticker counter updated ?
        je    @no_update          ; no

        or    ax, ax              ; update before timer freeze ?
        jns   @no_update          ; no

        mov   edi, esi            ; use second

@no_update:
        shld  ecx, edi, 16
        not   ax               ; counter counts down
        mov   bx, 36edh        ; load multiplier
        mul   bx               ; W1 * M
        mov   si, dx           ; save W1 * M (hi)
        mov   ax, bx           ; get M
        mul   di               ; W2 * M
        xchg  bx, ax           ; AX = M, BX = W2 * M (lo)
        mov   di, dx           ; DI = W2 * M (hi)
        add   bx, si           ; accumulate
        adc   di, 0            ;  result
        xor   si, si           ; load zero
        mul   cx               ; W3 * M
        add   ax, di           ; accumulate
        adc   dx, si           ;  result in DX:AX:BX
        mov   dh, dl           ; move result
        mov   dl, ah           ;  from DL:AX:BX
        mov   ah, al           ;   to
        mov   al, bh           ;    DX:AX:BH
        mov   di, dx           ; save result
        mov   cx, ax           ;  in DI:CX
        mov   ax, 25110        ; calculate correction
        mul   dx               ;  factor
        sub   cx, dx           ; subtract correction
        sbb   di, si           ;  factor
        xchg  ax, cx           ; result back
        mov   dx, di           ;  to DX:AX
        pop   ds               ; restore caller's data segment
        ret

Clock   ENDP

        INCLUDE ALIGN.ASM

CODE    ENDS

        END