UNIT RDELAY;
{ ------------------------------------------------------------------- }
{ Roger E. Donais                             <rdonais@southeast.net> }
{ Freeware - Use at your own risk!                                    }
{ =================================================================== }
{ This patch is designed to disable the CRT Unit delay initialization }
{ and vector CRT.Delay to a corrected delay procedure in this unit.   }
{ The patch is made at runtime so as not to destroy the original CRT  }
{ compatibility and to force code linking to CRT.Delay to execute     }
{ using the new delay.                                         ...red }
{ ------------------------------------------------------------------- }
{ STEPS:                                                              }
{                                                                     }
{ 1) Get UTIL.PAS at http://users.southeast.net/~rdonais/tpascal.htm  }
{    or write appropriate memory compare and type definitions.        }
{                                                                     }
{ 2) In the main program file's uses clause, place the name of this   }
{    unit *followed* by CRT.  Otherwise the patch will not be able    }
{    to kill the CRT delay initialization causing divide by 0 error.  }
{                                                                     }
{ 3) Insure that the CRT Unit is *not* overlayed                      }
{                                                                     }
{ 4) May not be necessary, but I suggest you cement the marriage by   }
{    calling this unit's delay routine, then calling CRT.Delay to     }
{    insure that you are not outsmarted by the "smart-linker". Using  }
{    RDELAY.Delay(0) and CRT.Delay(0) should be sufficient insurance. }
{ ------------------------------------------------------------------- }
{ If you prefer, you can replace the delay procedure in this unit     }
{ with another delay procedure like NEWDELAY by Frank Heckenbach,     }
{ <heckenb@mi.uni-erlangen.de> or <fn106@fim.uni-erlangen.de>,        }
{ available at <http://www.mi.uni-erlangen.de/~heckenb/programs.htm>  }
{                                                                     }
{ The code has not been designed or tested for use with protected     }
{ mode programs.  You'll have to add the necessary code (selectorInc, }
{ etc) and whatever else to make it compatible with protected mode.   }
{ =================================================================== }
{ COMPILER OPTIONS:                                                   }
{$IFNDEF VER40} {-O-} {$ENDIF}
{$F-   } { Not tested / probably shouldn't be overlayed               }
{-D+,L+} { Debug set from IDE or CommandLine, or when needed          }
{-R+,S-} { Range and Stack checking set from IDE or CommandLine       }
{$I+   } { I/O Error Checking is bracketed when needed w/in code      }
{$V+   } { Strict VAR-Strings are bracketed when needed w/in code     }
{$B-   } { Complete Boolean eval is bracketed when needed w/in code   }
{-N-   } { Math cooprocessor support not required                     }
{-E-   } { Math cooprocessor emulation not required                   }
{ =================================================================== }
INTERFACE
USES UTIL;

PROCEDURE Delay(ms:Word);

IMPLEMENTATION

{$IFDEF DPMI} Designed for use by real mode programs only!
{$ENDIF}

CONST DelayCnt: longint =  -1;
{$L RDELAY} PROCEDURE Delay; EXTERNAL;   {FAR}
{$F-}       PROCEDURE Init;  EXTERNAL;   {NEAR}

{ =================================================================== }
CONST NOP  = $90;  { x86 nop instruction }
      JMP  = $EA;  { x86 far jmp instruction }

TYPE  PtrRec = Record
         Ofs,Seg: Word;
      End;

      tpFarJump = ^FarJump;
      FarJump = RECORD
         opcode: Byte;
         target: Pointer;
      End;


{$IFDEF VER70}
PROCEDURE PatchCrt; NEAR;
{ =================================================================== }
TYPE StackFrame = RECORD
        p          : Pointer;
        oldBP      : Word;
        LocalCaller: Word;         { RDELAY (NEAR) return address }
        oldBP1     : Word;
        MainCaller : tpFarJump;    { Main progran return address }
                     { next instruction is far call to CRT init  }
     End;

CONST InitDelay: Array[0..29] of Byte
      = ($BF,$6C,$00,$26,$8A,$1D,$26,$3A,$1D,$74,$FB,$26,$8A,$1D,$B8
        ,$E4,$FF,$99,$E8,$3C,$02,$F7,$D0,$F7,$D2,$B9,$37,$00,$F7,$F1
      );

      CrtDelay: Array[0..43] of Byte
      = ($8B,$DC,$36,$8B,$4F,$04,$E3,$13,$8E,$06
        ,0, 0    {skip2 0000e - mov from Seg0040 }
        ,$33,$FF,$26,$8A,$1D,$A1
        ,0, 0    {skip2 0000r - mov from DelayCnt }
        ,$33,$D2,$E8,$05,$00,$E2,$F6,$CA,$02,$00,$2D,$01
        ,$00,$83,$DA,$00,$72,$05,$26,$3A,$1D,$74,$F3,$C3
      );

VAR p: tpByteBuffer;
    k: StackFrame absolute p;
    r: tpFarJump absolute p;
BEGIN
    p := k.MainCaller^.Target;  { next unit init should be CRT }
    Dec( PtrRec(p).Ofs, $D);

    If PtrRec(p).Ofs
    or MemComp(p^[$0075],    InitDelay, Sizeof(InitDelay))
    or MemComp(p^[$02A8],    CrtDelay,     10)
    or MemComp(p^[$02A8+12], CrtDelay[12],  6)
    or MemComp(p^[$02A8+20], CrtDelay[20], 24) = 0
    Then Begin
       { kill crt delay initialization code }
       FillChar(p^[$75], Sizeof(InitDelay), NOP);

       { Vector CRT.Delay to RDELAY.Delay }
       Inc(PtrRec(p).Ofs, $02A8);
       r^.opcode := JMP;
       r^.target := @Delay;
    End Else Begin
       Writeln(#7'TP/BP 7.0 CRT Delay patch failed!');
       Halt(69);
    End;
END;
{$ENDIF}


{$IFDEF VER60}
PROCEDURE PatchCrt; NEAR;
{ =================================================================== }
TYPE StackFrame = RECORD
        LocalVar   : Pointer;
        oldBP      : Word;
        LocalCaller: Word;         { RDELAY (NEAR) return address }
        oldBP1     : Word;
        MainCaller : tpFarJump;    { Main progran return address }
                     { next instruction is far call to CRT init  }
     End;

CONST InitDelay: Array[0..29] of Byte
      = ($BF,$6C,$00,$26,$8A,$05,$26,$3A,$05,$74,$FB,$26,$8A,$05,$B9
        ,$FF,$FF,$E8,$75,$02,$B8,$37,$00,$91,$F7,$D0,$33,$D2,$F7,$F1
      );

      CrtDelay: Array[0..44] of Byte
      = ($8B,$DC,$36,$8B,$57,$04,$0B,$D2,$74,$14,$B8
        ,$40,$00,$8E,$C0,$33,$FF,$26,$8A,$05,$8B,$0E
        ,0, 0    {skip2 0000r - mov from DelayCnt }
        ,$E8,$06,$00,$4A,$75,$F6,$CA,$02,$00,$BB,$04
        ,$00,$4B,$75,$FD,$26,$3A,$05,$E1,$F5,$C3
      );

VAR p: tpByteBuffer;
    k: StackFrame absolute p;
    r: ^FarJump absolute p;
BEGIN
    p := k.MainCaller^.Target;  { next unit init should be CRT! }

    If PtrRec(p).Ofs
    or MemComp(p^[$006C   ], InitDelay, Sizeof(InitDelay))
    or MemComp(p^[$02D4   ], CrtDelay,  22)
    or MemComp(p^[$02D4+24], CrtDelay[24], 21) = 0
    Then Begin
       { kill crt delay initialization code }
       FillChar(p^[$6C], Sizeof(InitDelay), NOP);

       { Vector CRT.Delay to RDELAY.Delay }
       r := AddPtr(p, $02D4);
       r^.opcode := JMP;
       r^.target := @Delay;
    End Else Begin
       Writeln(#7'TP 6.0 CRT Delay patch failed!');
       Halt(69);
    End;
END;
{$ENDIF}


{$IFDEF VER55} {$F-}
PROCEDURE PatchCrt;
{ =================================================================== }
TYPE StackFrame = RECORD
        p          : Pointer;
        oldBP      : Word;
        LocalCaller: Word;         { RDELAY (NEAR) return address }
        oldBP1     : Word;
        MainCaller : tpFarJump;    { Main progran return address }
                     { next instruction is far call to CRT init  }
     End;

CONST InitDelay: Array[0..29] of Byte
      = ($BF,$6C,$00,$26,$8A,$05,$26,$3A,$05,$74,$FB,$26,$8A,$05,$B9
        ,$FF,$FF,$E8,$3F,$02,$B8,$37,$00,$91,$F7,$D0,$33,$D2,$F7,$F1
      );

      CrtDelay: Array[0..39] of Byte
      = ($8B,$DC,$36,$8B,$57,$04,$0B,$D2,$74,$13
        ,$33,$FF,$8E,$C7,$26,$8A,$05,$8B,$1E
        ,0, 0    {skip2 0000r - mov from DelayCnt }
        ,$8B,$CB,$E8,$06,$00,$4A,$75,$F8,$CA,$02
        ,$00,$26,$3A,$05,$75,$02,$E2,$F9,$C3
      );

VAR p: tpByteBuffer;
    k: StackFrame absolute p;
    r: tpFarJump absolute p;
BEGIN
    p := k.MainCaller^.Target;  { next unit init should be CRT! }

    If PtrRec(p).Ofs
    or MemComp(p^[$006B   ], InitDelay, Sizeof(InitDelay))
    or MemComp(p^[$029E   ], CrtDelay,  19)
    or MemComp(p^[$029E+21], CrtDelay[21], 19) = 0
    Then Begin

       { kill crt delay initialization code }
       FillChar(p^[$6B], Sizeof(InitDelay), NOP);

       { Vector CRT.Delay to RDELAY.Delay }
       Inc(PtrRec(p).Ofs, $029E);
       r^.opcode := JMP;
       r^.target := @Delay;
    End Else Begin
       Writeln(#7'TP 5.5 CRT Delay patch failed!');
       Halt(69);
    End;
END;
{$ENDIF}


{$IFDEF VER50}  {$F-}
PROCEDURE PatchCrt;
{ =================================================================== }
TYPE StackFrame = RECORD
        p          : Pointer;
        oldBP      : Word;
        LocalCaller: Word;         { RDELAY (NEAR) return address }
        oldBP1     : Word;
        MainCaller : tpFarJump;    { Main progran return address }
                     { next instruction is far call to CRT init  }
     End;

CONST InitDelay: Array[0..29] of Byte
      = ($BF,$6C,$00,$26,$8A,$05,$26,$3A,$05,$74,$FB,$26,$8A,$05,$B9
        ,$FF,$FF,$E8,$3F,$02,$B8,$37,$00,$91,$F7,$D0,$33,$D2,$F7,$F1
      );

      CrtDelay: Array[0..39] of Byte
      = ($8B,$DC,$36,$8B,$57,$04,$0B,$D2,$74,$13
        ,$33,$FF,$8E,$C7,$26,$8A,$05,$8B,$1E
        ,0, 0    {skip2 0000r - mov from DelayCnt }
        ,$8B,$CB,$E8,$06,$00,$4A,$75,$F8,$CA,$02
        ,$00,$26,$3A,$05,$75,$02,$E2,$F9,$C3
      );

VAR p: tpByteBuffer;
    k: StackFrame absolute p;
    r: tpFarJump absolute p;
BEGIN
    p := k.MainCaller^.Target;  { next unit init should be CRT! }

    If PtrRec(p).Ofs
    or MemComp(p^[$006B   ], InitDelay, Sizeof(InitDelay))
    or MemComp(p^[$029E   ], CrtDelay,  19)
    or MemComp(p^[$029E+21], CrtDelay[21], 19) = 0
    Then Begin

       { kill crt delay initialization code }
       FillChar(p^[$6B], Sizeof(InitDelay), NOP);

       { Vector CRT.Delay to RDELAY.Delay }
       Inc(PtrRec(p).Ofs, $029E);
       r^.opcode := JMP;
       r^.target := @Delay;
    End Else Begin
       Writeln(#7'TP 5.0 CRT Delay patch failed!');
       Halt(69);
    End;
END;
{$ENDIF}


{$IFDEF VER40}  {$F-}
PROCEDURE PatchCrt;
{ =================================================================== }
TYPE StackFrame = RECORD
        p          : Pointer;      { our first local variable }
        oldBP      : Word;
        LocalCaller: Word;         { RDELAY (NEAR) return address }
        MainCaller : tpFarJump;    { Main progran return address }
                     { next instruction is far call to CRT init  }
     End;

CONST InitDelay: Array[0..29] of Byte
      = ($BF,$6C,$00,$26,$8A,$05,$26,$3A,$05,$74,$FB,$26,$8A,$05,$B9
        ,$FF,$FF,$E8,$8C,$02,$B8,$37,$00,$91,$F7,$D0,$33,$D2,$F7,$F1
      );

      CrtDelay: Array[0..39] of Byte
      = ($8B,$DC,$36,$8B,$57,$04,$0B,$D2,$74,$13
        ,$33,$FF,$8E,$C7,$26,$8A,$05,$8B,$1E
        ,0, 0    {skip2 0000r - mov from DelayCnt }
        ,$8B,$CB,$E8,$06,$00,$4A,$75,$F8,$CA,$02
        ,$00,$26,$3A,$05,$75,$02,$E2,$F9,$C3
      );

VAR p: tpByteBuffer;
    k: StackFrame absolute p;
    r: tpFarJump absolute p;
BEGIN
    p := k.MainCaller^.Target;  { next unit init should be CRT! }

    If PtrRec(p).Ofs
    or MemComp(p^[$0069   ], InitDelay, Sizeof(InitDelay))
    or MemComp(p^[$02E9   ], CrtDelay,  19)
    or MemComp(p^[$02E9+21], CrtDelay[21], 19) = 0
    Then Begin

       { kill crt delay initialization code }
       FillChar(p^[$69], Sizeof(InitDelay), NOP);

       { Vector CRT.Delay to RDELAY.Delay }
       r := AddPtr(p, $02E9);
       r^.opcode := JMP;
       r^.target := @Delay;
    End Else Begin
       Writeln(#7'TP 4.0 CRT Delay patch failed!');
       Halt(69);
    End;
END;
{$ENDIF}

BEGIN
    PatchCrt;
    Init;
END.
