%{
{*

Pascal lexical analyzer

*}
%}

NQUOTE    [^']
DQUOTE    [^}]

%%

%{
var
  kw : integer;
  Stop : Boolean;
%}

[a-zA-Z_]([a-zA-Z0-9_])*  begin
                            yytext := UpStr(yytext);
                            if is_keyword(yytext, kw)
                             then  return(kw)
                             else  return(IDENTIFIER);
                          end;


[-]?[0-9]+([.][0-9])?[E](([-]|[+])?[0-9]+)? |
[0-9]+"."[0-9]+           |
[$]([0-9a-fA-F])+         |
[0-9]+                    return(NUMBER);

"#"([0-9])+               |
"#$"([0-9a-fA-F])+        return(_CHAR);


":"                       return(COLON);
";"			  return(SEMICOLON);
"."			  return(DOT);
".."			  return(DOTDOT);
":="                      return(ASSIGNMENT);
"="                       return(EQUAL);
"("			  return(LPAREN);
")"                       return(RPAREN);
"["                       return(LBRAC);
"]"                       return(RBRAC);
","                       return(COMMA);
">="			  return(GE);
"<="			  return(LE);
"<>"			  return(NOTEQUAL);

"^"			  return(UPARROW);

'({NQUOTE}|'')*'          return(CHARACTER_STRING);

"{$"({DQUOTE})*"}"        return(DIRECTIVE);

"(*"                      begin
                            Stop := FALSE;
                            repeat
                              if (get_char = '*') and (get_char = ')') then
                                Stop := TRUE;
                            until Stop;
                          end;

"{"                       begin
			    repeat
                            until get_char = '}';
                          end;

[ \t\f]			  ;

\n                        begin
                            if Random(50) = 25 then
                              WriteProgress;
                          end;

\0                        ;

.                         return(OTHER);

%%