
(* lexical analyzer template (TP Lex V3.0), V1.0 3-2-91 AG *)

(* global definitions: *)
{*  Assembler parsing for Mangler, see MANGLER.L
    Copyright (C) 1993  Berend de Boer

    This program is free software for noncommercial users; you can
    redistribute it and/or modify it under the terms of the license,
    stated in de accompanying file LICENSE.TXT.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    license for more details.

    See the accompanying READ.ME file for information on contacting the
    author.


$Author: Berend_de_Boer $
$Date: 93/04/29 07:52:25 $
$Revision: 1.2 $

Last changes:
93-04-19  Fixed the & identifier override bug
*}

procedure ParseAsm;




function yylex : Integer;

procedure yyaction ( yyruleno : Integer );
  (* local definitions: *)

  function is_keyword(const id : string) : Boolean;
  {**}
  const
    id_len = 6;
  type
    Ident = string[id_len];
  const
    (* table of assembler keywords: *)
    no_of_keywords = 192;
    keyword : array [1..no_of_keywords] of Ident = (
      'AAA', 'AAD', 'AAM', 'AAS', 'ADC', 'ADD', 'AH', 'AL', 'AND', 'AND',
      'AX', 'BH', 'BL', 'BOUND', 'BP', 'BX', 'BYTE', 'CALL', 'CBW', 'CH',
      'CL', 'CLC', 'CLD', 'CLI', 'CMC', 'CMP', 'CMPS', 'CMPSB', 'CMPSD',
      'CMPSW', 'CS', 'CX', 'DAA', 'DAS', 'DEC', 'DH', 'DI', 'DIV', 'DL', 'DS',
      'DWORD', 'DX', 'ENTER', 'ES', 'FAR', 'HIGH', 'HLT', 'IDIV', 'IMUL',
      'IN', 'INC', 'INS', 'INSB', 'INSD', 'INSW', 'INT', 'INTO', 'IRET', 'JA',
      'JAE', 'JB', 'JBE', 'JC', 'JCXZ', 'JE', 'JG', 'JGE', 'JL', 'JLE', 'JMP',
      'JNA', 'JNAE', 'JNB', 'JNBE', 'JNC', 'JNE', 'JNG', 'JNGE', 'JNL',
      'JNLE', 'JNO', 'JNP', 'JNS', 'JNZ', 'JO', 'JP', 'JPE', 'JPO', 'JS',
      'JZ', 'JZ', 'LAHF', 'LAR', 'LDS', 'LEA', 'LEAVE', 'LES', 'LGDT', 'LIDT',
      'LLDT', 'LMSW', 'LOCK', 'LODS', 'LODSB', 'LODSW', 'LOOP', 'LOOPE',
      'LOOPNE', 'LOOPNZ', 'LOOPZ', 'LOW', 'LSL', 'LTR', 'MOD', 'MOV', 'MOVS',
      'MOVSB', 'MOVSW', 'MUL', 'NEAR', 'NEG', 'NOP', 'NOT', 'NOT', 'OFFSET',
      'OR', 'OR', 'OUT', 'OUTS', 'OUTSB', 'OUTSW', 'POP', 'POPA', 'POPF',
      'PTR', 'PUSH', 'PUSHA', 'PUSHF', 'QWORD', 'RCL', 'RCR', 'REP', 'REPE',
      'REPNE', 'REPNZ', 'REPZ', 'RET', 'ROL', 'ROR', 'SAHF', 'SAL', 'SAR',
      'SBB', 'SCAS', 'SCASB', 'SCASW', 'SEG', 'SEGDS', 'SEGES', 'SEGSS', 'SGDT', 'SHL', 'SHL', 'SHR',
      'SHR', 'SI', 'SIDT', 'SLDT', 'SMSW', 'SP', 'SS', 'ST', 'STC', 'STD',
      'STI', 'STOS', 'STOSB', 'STOSW', 'STR', 'SUB', 'TBYTE', 'TEST', 'TYPE',
      'VERR', 'VERW', 'WAIT', 'WORD', 'XCHG', 'XLAT', 'XLATB', 'XOR', 'XOR');
  var m, n, k : integer;
  begin
    m := 1; n := no_of_keywords;
    while m<=n do  begin
      k := m+(n-m) div 2;
      if id=keyword[k]
       then  begin
         is_keyword := true;
         Exit;
       end
       else  if id>keyword[k]
              then  m := k+1
              else  n := k-1
    end;  { of while }
    is_keyword := false
  end;

var
  Stop : Boolean;




begin
  (* actions: *)
  case yyruleno of
  1:
                          begin
                            yytext := UpStr(yytext);
                            if is_keyword(yytext)
                             then  return(KEYWORD)
                             else  begin
                               if yytext = 'END'
                                then  return(_END)
                                else  return(IDENTIFIER);
                             end;
                          end;

  2:
                          begin
                            yytext := UpStr(yytext);
                            return(IDENTIFIER);
                          end;

  3:
                          return(AMPERSAND);

  4:
                          return(_LABEL);

  5:
   			  return(SEMICOLON);
  6:
   			  return(DOT);

  7:
                          return(CHARACTER_STRING);

  8,
  9,
  10:
                          return(NUMBER);

  11:
                          return(DIRECTIVE);

  12:
                          begin
                            Stop := FALSE;
                            repeat
                              if (get_char = '*') and (get_char = ')') then
                                Stop := TRUE;
                            until Stop;
                          end;

  13:
                          begin
			    repeat
                            until get_char = '}';
                          end;

  14:
       			  ;

  15:
                          begin
                            if Random(50) = 25 then
                              WriteProgress;
                            return(NEWLINE);
                          end;

  16:
                          return(OTHER);

  end;
end(*yyaction*);

(* DFA table: *)

type YYTRec = record
                cc : set of Char;
                s  : Integer;
              end;

const

yynmarks   = 33;
yynmatches = 33;
yyntrans   = 58;
yynstates  = 29;

yyk : array [1..yynmarks] of Integer = (
  { 0: }
  { 1: }
  { 2: }
  1,
  2,
  16,
  { 3: }
  2,
  16,
  { 4: }
  3,
  16,
  { 5: }
  16,
  { 6: }
  5,
  16,
  { 7: }
  6,
  16,
  { 8: }
  16,
  { 9: }
  10,
  16,
  { 10: }
  16,
  { 11: }
  13,
  16,
  { 12: }
  16,
  { 13: }
  14,
  16,
  { 14: }
  15,
  { 15: }
  16,
  { 16: }
  1,
  2,
  { 17: }
  2,
  { 18: }
  { 19: }
  4,
  { 20: }
  { 21: }
  7,
  { 22: }
  { 23: }
  8,
  { 24: }
  10,
  { 25: }
  9,
  { 26: }
  { 27: }
  12,
  { 28: }
  11
);

yym : array [1..yynmatches] of Integer = (
{ 0: }
{ 1: }
{ 2: }
  1,
  2,
  16,
{ 3: }
  2,
  16,
{ 4: }
  3,
  16,
{ 5: }
  16,
{ 6: }
  5,
  16,
{ 7: }
  6,
  16,
{ 8: }
  16,
{ 9: }
  10,
  16,
{ 10: }
  16,
{ 11: }
  13,
  16,
{ 12: }
  16,
{ 13: }
  14,
  16,
{ 14: }
  15,
{ 15: }
  16,
{ 16: }
  1,
  2,
{ 17: }
  2,
{ 18: }
{ 19: }
  4,
{ 20: }
{ 21: }
  7,
{ 22: }
{ 23: }
  8,
{ 24: }
  10,
{ 25: }
  9,
{ 26: }
{ 27: }
  12,
{ 28: }
  11
);

yyt : array [1..yyntrans] of YYTrec = (
{ 0: }
  ( cc: [ #1..#8,#11,#13..#31,'!'..'#','%',')'..'-',
            '/',':','<'..'?','['..'^','`','|'..#255 ]; s: 15),
  ( cc: [ #9,#12,' ' ]; s: 13),
  ( cc: [ #10 ]; s: 14),
  ( cc: [ '$' ]; s: 10),
  ( cc: [ '&' ]; s: 4),
  ( cc: [ '''' ]; s: 8),
  ( cc: [ '(' ]; s: 12),
  ( cc: [ '.' ]; s: 7),
  ( cc: [ '0'..'9' ]; s: 9),
  ( cc: [ ';' ]; s: 6),
  ( cc: [ '@' ]; s: 5),
  ( cc: [ 'A'..'Z','a'..'z' ]; s: 2),
  ( cc: [ '_' ]; s: 3),
  ( cc: [ '{' ]; s: 11),
{ 1: }
  ( cc: [ #1..#8,#11,#13..#31,'!'..'#','%',')'..'-',
            '/',':','<'..'?','['..'^','`','|'..#255 ]; s: 15),
  ( cc: [ #9,#12,' ' ]; s: 13),
  ( cc: [ #10 ]; s: 14),
  ( cc: [ '$' ]; s: 10),
  ( cc: [ '&' ]; s: 4),
  ( cc: [ '''' ]; s: 8),
  ( cc: [ '(' ]; s: 12),
  ( cc: [ '.' ]; s: 7),
  ( cc: [ '0'..'9' ]; s: 9),
  ( cc: [ ';' ]; s: 6),
  ( cc: [ '@' ]; s: 5),
  ( cc: [ 'A'..'Z','a'..'z' ]; s: 2),
  ( cc: [ '_' ]; s: 3),
  ( cc: [ '{' ]; s: 11),
{ 2: }
  ( cc: [ '0'..'9','_' ]; s: 17),
  ( cc: [ 'A'..'Z','a'..'z' ]; s: 16),
{ 3: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 17),
{ 4: }
{ 5: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 19),
  ( cc: [ '@' ]; s: 18),
{ 6: }
{ 7: }
{ 8: }
  ( cc: [ #1..'&','('..#255 ]; s: 20),
  ( cc: [ '''' ]; s: 21),
{ 9: }
  ( cc: [ '-','A'..'F','a'..'f' ]; s: 22),
  ( cc: [ '0'..'9' ]; s: 24),
  ( cc: [ 'H','h' ]; s: 23),
{ 10: }
  ( cc: [ '0'..'9','A'..'F','a'..'f' ]; s: 25),
{ 11: }
  ( cc: [ '$' ]; s: 26),
{ 12: }
  ( cc: [ '*' ]; s: 27),
{ 13: }
{ 14: }
{ 15: }
{ 16: }
  ( cc: [ '0'..'9','_' ]; s: 17),
  ( cc: [ 'A'..'Z','a'..'z' ]; s: 16),
{ 17: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 17),
{ 18: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 19),
  ( cc: [ '@' ]; s: 18),
{ 19: }
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 19),
{ 20: }
  ( cc: [ #1..'&','('..#255 ]; s: 20),
  ( cc: [ '''' ]; s: 21),
{ 21: }
  ( cc: [ '''' ]; s: 20),
{ 22: }
  ( cc: [ '-','0'..'9','A'..'F','a'..'f' ]; s: 22),
  ( cc: [ 'H','h' ]; s: 23),
{ 23: }
{ 24: }
  ( cc: [ '-','A'..'F','a'..'f' ]; s: 22),
  ( cc: [ '0'..'9' ]; s: 24),
  ( cc: [ 'H','h' ]; s: 23),
{ 25: }
  ( cc: [ '0'..'9','A'..'F','a'..'f' ]; s: 25),
{ 26: }
  ( cc: [ #1..'&','('..'|','~'..#255 ]; s: 26),
  ( cc: [ '}' ]; s: 28)
{ 27: }
{ 28: }
);

yykl : array [0..yynstates-1] of Integer = (
{ 0: } 1,
{ 1: } 1,
{ 2: } 1,
{ 3: } 4,
{ 4: } 6,
{ 5: } 8,
{ 6: } 9,
{ 7: } 11,
{ 8: } 13,
{ 9: } 14,
{ 10: } 16,
{ 11: } 17,
{ 12: } 19,
{ 13: } 20,
{ 14: } 22,
{ 15: } 23,
{ 16: } 24,
{ 17: } 26,
{ 18: } 27,
{ 19: } 27,
{ 20: } 28,
{ 21: } 28,
{ 22: } 29,
{ 23: } 29,
{ 24: } 30,
{ 25: } 31,
{ 26: } 32,
{ 27: } 32,
{ 28: } 33
);

yykh : array [0..yynstates-1] of Integer = (
{ 0: } 0,
{ 1: } 0,
{ 2: } 3,
{ 3: } 5,
{ 4: } 7,
{ 5: } 8,
{ 6: } 10,
{ 7: } 12,
{ 8: } 13,
{ 9: } 15,
{ 10: } 16,
{ 11: } 18,
{ 12: } 19,
{ 13: } 21,
{ 14: } 22,
{ 15: } 23,
{ 16: } 25,
{ 17: } 26,
{ 18: } 26,
{ 19: } 27,
{ 20: } 27,
{ 21: } 28,
{ 22: } 28,
{ 23: } 29,
{ 24: } 30,
{ 25: } 31,
{ 26: } 31,
{ 27: } 32,
{ 28: } 33
);

yyml : array [0..yynstates-1] of Integer = (
{ 0: } 1,
{ 1: } 1,
{ 2: } 1,
{ 3: } 4,
{ 4: } 6,
{ 5: } 8,
{ 6: } 9,
{ 7: } 11,
{ 8: } 13,
{ 9: } 14,
{ 10: } 16,
{ 11: } 17,
{ 12: } 19,
{ 13: } 20,
{ 14: } 22,
{ 15: } 23,
{ 16: } 24,
{ 17: } 26,
{ 18: } 27,
{ 19: } 27,
{ 20: } 28,
{ 21: } 28,
{ 22: } 29,
{ 23: } 29,
{ 24: } 30,
{ 25: } 31,
{ 26: } 32,
{ 27: } 32,
{ 28: } 33
);

yymh : array [0..yynstates-1] of Integer = (
{ 0: } 0,
{ 1: } 0,
{ 2: } 3,
{ 3: } 5,
{ 4: } 7,
{ 5: } 8,
{ 6: } 10,
{ 7: } 12,
{ 8: } 13,
{ 9: } 15,
{ 10: } 16,
{ 11: } 18,
{ 12: } 19,
{ 13: } 21,
{ 14: } 22,
{ 15: } 23,
{ 16: } 25,
{ 17: } 26,
{ 18: } 26,
{ 19: } 27,
{ 20: } 27,
{ 21: } 28,
{ 22: } 28,
{ 23: } 29,
{ 24: } 30,
{ 25: } 31,
{ 26: } 31,
{ 27: } 32,
{ 28: } 33
);

yytl : array [0..yynstates-1] of Integer = (
{ 0: } 1,
{ 1: } 15,
{ 2: } 29,
{ 3: } 31,
{ 4: } 32,
{ 5: } 32,
{ 6: } 34,
{ 7: } 34,
{ 8: } 34,
{ 9: } 36,
{ 10: } 39,
{ 11: } 40,
{ 12: } 41,
{ 13: } 42,
{ 14: } 42,
{ 15: } 42,
{ 16: } 42,
{ 17: } 44,
{ 18: } 45,
{ 19: } 47,
{ 20: } 48,
{ 21: } 50,
{ 22: } 51,
{ 23: } 53,
{ 24: } 53,
{ 25: } 56,
{ 26: } 57,
{ 27: } 59,
{ 28: } 59
);

yyth : array [0..yynstates-1] of Integer = (
{ 0: } 14,
{ 1: } 28,
{ 2: } 30,
{ 3: } 31,
{ 4: } 31,
{ 5: } 33,
{ 6: } 33,
{ 7: } 33,
{ 8: } 35,
{ 9: } 38,
{ 10: } 39,
{ 11: } 40,
{ 12: } 41,
{ 13: } 41,
{ 14: } 41,
{ 15: } 41,
{ 16: } 43,
{ 17: } 44,
{ 18: } 46,
{ 19: } 47,
{ 20: } 49,
{ 21: } 50,
{ 22: } 52,
{ 23: } 52,
{ 24: } 55,
{ 25: } 56,
{ 26: } 58,
{ 27: } 58,
{ 28: } 58
);


var yyn : Integer;

label start, scan, action;

begin

start:

  (* initialize: *)

  yynew;

scan:

  (* mark positions and matches: *)

  for yyn := yykl[yystate] to     yykh[yystate] do yymark(yyk[yyn]);
  for yyn := yymh[yystate] downto yyml[yystate] do yymatch(yym[yyn]);

  if yytl[yystate]>yyth[yystate] then goto action; (* dead state *)

  (* get next character: *)

  yyscan;

  (* determine action: *)

  yyn := yytl[yystate];
  while (yyn<=yyth[yystate]) and not (yyactchar in yyt[yyn].cc) do inc(yyn);
  if yyn>yyth[yystate] then goto action;
    (* no transition on yyactchar in this state *)

  (* switch to new state: *)

  yystate := yyt[yyn].s;

  goto scan;

action:

  (* execute action: *)

  if yyfind(yyrule) then
    begin
      yyaction(yyrule);
      if yyreject then goto action;
    end
  else if not yydefault and yywrap then
    begin
      yyclear;
      return(0);
    end;

  if not yydone then goto start;

  yylex := yyretval;

end(*yylex*);


(**)

  function GiveEncodingFor(s : string) : string;
  {* DO NOT MAKE s a const string!!! *}
  {* should be equal to function in MANGLER.PAS *}
  { PRE -
    POST - contents of yytext is destroyed
  }
  var
    p,d : PScopeCol;
    e : string;
    Index : integer;
  begin
    if yylex = DOT
     then  begin
     {* a dot was used to select a different scope *}
       p := GetScope(s, Index);
       if p = nil
        then  begin     {* an unknown scope was selected *}
          e := s + '.';
          while (yylex = IDENTIFIER) do  begin
            e := e + yytext;
            if yylex = DOT
             then  e := e + '.'
             else  Break;
          end;
          yyless(0);
        end
        else  begin
          PushScope(CurrentScope);
          CurrentScope := p^.AtScope(Index);
          e := p^.AtHashedName(Index) + '.';
          while (yylex = IDENTIFIER) do  begin
            if CurrentScope = nil
             then  begin
               e := e + yytext;
(* why this source??? if nil you don't know anything it seems
               d := GetScope(yytext, Index);
               if d <> nil
                then  e := e + GiveEncodingFor(yytext)
                else  e := e + yytext;
*)
             end
             else  begin
               if CurrentScope^.Search(@yytext, Index)
                then  e := e + CurrentScope^.AtHashedName(Index)
                else  e := e + yytext;
             end;
            if yylex = DOT
             then  begin
               if CurrentScope <> nil then
                 if CurrentScope^.Count = 0
                  then  CurrentScope := nil
                  else  CurrentScope := CurrentScope^.AtScope(Index);
               e := e + '.';
             end
             else  break;
          end;  { of while }
          yyless(0);
          CurrentScope := PopScope;
        end;
       GiveEncodingFor := e;
     end
     else  begin
       yyless(0);
       p := GetScope(s, Index);
       if p = nil
        then  GiveEncodingFor := s
        else  GiveEncodingFor := p^.AtHashedName(Index)
     end;
  end;


begin
  write(yyoutput, yytext, ' ');
  while yylex <> _END do  begin
    case yyretval of
      IDENTIFIER : begin
          write(yyoutput, GiveEncodingFor(yytext));
        end;
      NEWLINE : writeln(yyoutput, '{}');
      AMPERSAND : begin
          write(yyoutput, yytext);
          yylex;
          write(yyoutput, GiveEncodingFor(yytext));
        end;
    else  write(yyoutput, yytext, ' ');
    end; { of case }
  end; { of while }
  writeln(yyoutput);
  write(yyoutput, yytext);
  if AssemblerSection then  begin
    Section := PopSection;
    CurrentScope := PopScope;
    if ObjectImpl then  begin
      CurrentScope := PopScope;
      ObjectImpl := FALSE;
    end;
    AssemblerSection := FALSE;
  end;
end;
