{$N+,E+}
PROGRAM cdemo;

  USES ComplexOps;

  VAR
    a      :  ARRAY[1..22] OF Complex;
    csave  :  ARRAY[1..22] OF Complex;
    k,m    :  WORD;
    n      :  INTEGER;
    x,y    :  RealType;
    z,z1,z2:  Complex;

BEGIN

  WRITELN ('Demo ComplexOPs PROCEDUREs and FUNCTIONs');
  WRITELN;
  WRITELN ('  Notes:  1.  CIS(w) = COS(w) + i*SIN(w), w = 0..2*PI');
  WRITELN ('          2.  z = x + i*y');
  WRITELN;
  WRITELN;

  CSet (a[ 1],  0.0,  0.0, rectangular);
  CSet (a[ 2],  0.5,  0.5, rectangular);
  CSet (a[ 3], -0.5,  0.5, rectangular);
  CSet (a[ 4], -0.5, -0.5, rectangular);
  CSet (a[ 5],  0.5, -0.5, rectangular);
  CSet (a[ 6],  1.0,  0.0, rectangular);
  CSet (a[ 7],  1.0,  1.0, rectangular);
  CSet (a[ 8],  0.0,  1.0, rectangular);
  CSet (a[ 9], -1.0,  1.0, rectangular);
  CSet (a[10], -1.0,  0.0, rectangular);
  CSet (a[11], -1.0, -1.0, rectangular);
  CSet (a[12],  0.0, -1.0, rectangular);
  CSet (a[13],  1.0, -1.0, rectangular);
  CSet (a[14],   5.,   0., rectangular);
  CSet (a[15],   5.,   3., rectangular);
  CSet (a[16],   0.,   3., rectangular);
  CSet (a[17],  -5.,   3., rectangular);
  CSet (a[18],  -5.,   0., rectangular);
  CSet (a[19],  -5.,  -3., rectangular);
  CSet (a[20],   0.,  -3., rectangular);
  CSet (a[21],  -5.,  -3., rectangular);
  CSet (a[22], -20.,  20., rectangular);

  WRITELN ('Complex number definition/conversion/output:  CSet/CConvert/CStr');
  WRITELN;
  WRITELN ('   z rectangular':25,'z polar':28);
  WRITELN ('     ---------------------------   ',
    '-----------------------------');
  FOR k := 1 TO 21 DO
    WRITELN (k:3,'  ',CStr(a[k],12,8,rectangular),'  ',
                     CStr(a[k],12,8,polar));
  WRITELN;
  WRITELN;

  WRITELN ('Complex arithmetic:  CAdd, CSub, CMult, CDiv');
  WRITELN;

  CSet (z1,  1, 1, rectangular);
  WRITELN ('Let z1 = ':12,CStr(z1,8,3,rectangular):20,' or ',
                      CStr(z1,8,3,polar));
  CSet (z2, SQRT(3), -1, rectangular);
  WRITELN ('z2 = ':12,CStr(z2,8,3,rectangular):20,' or ',
                      CStr(z2,8,3,polar));
  WRITELN;

  CAdd  (z,z1,z2);
  WRITELN ('z1 + z2 = ':12,CStr(z,8,3,rectangular):20,' or ',
                           CStr(z,8,3,polar));

  CSub  (z,z1,z2);
  WRITELN ('z1 - z2 = ':12,CStr(z,8,3,rectangular):20,' or ',
                           CStr(z,8,3,polar));

  CMult (z,z1,z2);
  WRITELN ('z1 * z2 = ':12,CStr(z,8,3,rectangular):20,' or ',
                           CStr(z,8,3,polar));

  CDiv  (z,z1,z2);
  WRITELN ('z1 / z2 = ':12,CStr(z,8,3,rectangular):20,' or ',
                           CStr(z,8,3,polar));
  WRITELN;
  WRITELN;

  WRITELN ('Complex natural logarithm:  CLn = LN(z)');
  WRITELN;
  WRITELN ('  Notes:  1.  LN(z) is multivalued.');
  WRITELN (' ':9,' 2.  Any multiple of 2*PI*i could be added to/',
    'subtracted from LN(z).');
  WRITELN (' ':9,' 3.  LN(1)=0; LN(-1)=PI*i; LN(+/-i)=+/-0.5*PI*i.');
  WRITELN;
  WRITELN ('LN(z)':35);
  WRITELN ('z':11,'rectangular':27,'EXP( LN(z) ) = z':32);
  WRITELN ('     ------------  ---------------------------  ',
    '---------------------------');
  FOR k := 1 TO 22 DO BEGIN
    WRITE (k:3,' ',CStr(a[k],5,1,rectangular),'  ');
    IF   CAbs(a[k]) = 0.0
    THEN WRITELN ('undefined':18)
    ELSE BEGIN
      CLn (z,a[k]);
      CExp (z1,z);
      WRITELN (CStr(z,12,9,rectangular),'  ',CStr(z1,12,9,rectangular))
    END
  END;
  WRITELN;
  WRITELN;

  WRITELN ('Complex exponential:  CExp = EXP(z)');
  WRITELN;
  WRITELN ('EXP(z)':35);
  WRITELN ('z':11,'rectangular':27,'LN( EXP(z) ) = z':32);
  WRITELN ('     ------------  ---------------------------  ',
    '---------------------------');
  FOR k := 1 TO 22 DO BEGIN
    WRITE (k:3,' ',CStr(a[k],5,1,rectangular),'  ');
    CExp (z,a[k]);
    CLn (z1,z);
    IF   CAbs(z) > 10.0
    THEN m := 7
    ELSE m := 9;
    WRITELN (CStr(z,12,m,rectangular),'  ',CStr(z1,12,m,rectangular))
  END;
  WRITELN;
  WRITELN;

  WRITELN ('Complex power:  CPwr = z1^z2');
  WRITELN;
  WRITELN ('z^(-1+i)':36,'z^(-1+i)':29);
  WRITELN ('z':11,'rectangular':27,'polar':26);
  WRITELN ('     ------------  ---------------------------  ',
    '-----------------------------');
  CSet (z1, -1,1, rectangular);
  FOR k := 1 TO 21 DO BEGIN
    WRITE (k:3,' ',CStr(a[k],5,1,rectangular),'  ');
    IF   CAbs(a[k]) = 0.0
    THEN WRITELN ('undefined':18)
    ELSE BEGIN
      CPwr (z,a[k],z1);
      WRITELN (CStr(z,12,9,rectangular),' ',CStr(z,12,9,polar))
    END
  END;
  WRITELN;
  WRITELN;

  WRITELN ('Complex cosine:  CCos = COS(z)');
  WRITELN;
  WRITELN ('COS(z)':35,'COS(z)':29);
  WRITELN ('z':11,'rectangular':27,'polar':26);
  WRITELN ('     ------------  ---------------------------  ',
    '-----------------------------');
  FOR k := 1 TO 21 DO BEGIN
    WRITE (k:3,' ',CStr(a[k],5,1,rectangular),'  ');
    CCos (z,a[k]);
    CIntPwr (csave[k], z,2);  {save COS^2}
    IF   CAbs(z) > 10.0
    THEN m := 7
    ELSE m := 9;
    WRITELN (CStr(z,12,m,rectangular),' ',CStr(z,12,m,polar))
  END;
  WRITELN;
  WRITELN;

  WRITELN ('Complex sine:  CSin = SIN(z)');
  WRITELN;
  WRITELN ('SIN(z)':35);
  WRITELN ('z':11,'rectangular':27,'SIN^2(z)+COS^2(z)=1':32);
  WRITELN ('     ------------  ---------------------------  ',
    '---------------------------');
  FOR k := 1 TO 21 DO BEGIN
    WRITE (k:3,' ',CStr(a[k],5,1,rectangular),'  ');
    CSin (z,a[k]);
    CIntPwr (z1, z,2);      {SIN^2}
    CAdd (z1, z1,csave[k]); {SIN^2 + COS^2}
    IF   CAbs(z) > 10.0
    THEN m := 7
    ELSE m := 9;
    WRITELN (CStr(z,12,m,rectangular),'  ',CStr(z1,12,9,rectangular))
  END;
  WRITELN;
  WRITELN;

  WRITELN ('Complex tangent:  CTan = TAN(z)');
  WRITELN;
  WRITELN ('TAN(z)':35,'TAN(z)':29);
  WRITELN ('z':11,'rectangular':27,'polar':26);
  WRITELN ('     ------------  ---------------------------  ',
    '-----------------------------');
  FOR k := 1 TO 21 DO BEGIN
    WRITE (k:3,' ',CStr(a[k],5,1,rectangular),'  ');
    CTan (z,a[k]);
    IF   CAbs(z) > 10.0
    THEN m := 7
    ELSE m := 9;
    WRITELN (CStr(z,12,m,rectangular),' ',CStr(z,12,m,polar))
  END;
  WRITELN;
  WRITELN;

  WRITELN ('Complex hyperbolic cosine:  CCosh = COSH(z)');
  WRITELN;
  WRITELN ('COSH(z)':36,'COSH(z)':29);
  WRITELN ('z':11,'rectangular':27,'polar':26);
  WRITELN ('     ------------  ---------------------------  ',
    '-----------------------------');
  FOR k := 1 TO 21 DO BEGIN
    WRITE (k:3,' ',CStr(a[k],5,1,rectangular),'  ');
    CCosh (z,a[k]);
    CIntPwr (csave[k], z,2);  {save COSH^2}
    IF   CAbs(z) > 10.0
    THEN m := 7
    ELSE m := 9;
    WRITELN (CStr(z,12,m,rectangular),' ',CStr(z,12,m,polar))
  END;
  WRITELN;
  WRITELN;

  WRITELN ('Complex hyperbolic sine:  CSinh = SINH(z)');
  WRITELN;
  WRITELN ('SINH(z)':36);
  WRITELN ('z':11,'rectangular':27,'COSH^2(z)-SINH^2(z)=1':34);
  WRITELN ('     ------------  ---------------------------  ',
    '---------------------------');
  FOR k := 1 TO 21 DO BEGIN
    WRITE (k:3,' ',CStr(a[k],5,1,rectangular),'  ');
    CSinh (z,a[k]);
    CIntPwr (z1, z,2);      {SINH^2}
    CSub (z1, csave[k],z1); {COSH^2 - SINH^2}
    IF   CAbs(z) > 10.0
    THEN m := 7
    ELSE m := 9;
    WRITELN (CStr(z,12,m,rectangular),'  ',CStr(z1,12,9,rectangular))
  END;
  WRITELN;
  WRITELN;

  WRITELN ('Complex hyperbolic tangent:  CTanh = TANH(z)');
  WRITELN;
  WRITELN ('TANH(z)':36,'TANH(z)':29);
  WRITELN ('z':11,'rectangular':27,'polar':26);
  WRITELN ('     ------------  ---------------------------  ',
    '-----------------------------');
  FOR k := 1 TO 21 DO BEGIN
    WRITE (k:3,' ',CStr(a[k],5,1,rectangular),'  ');
    CTanh (z,a[k]);
    IF   CAbs(z) > 10.0
    THEN m := 4
    ELSE m := 9;
    WRITELN (CStr(z,12,m,rectangular),' ',CStr(z,12,m,polar))
  END;
  WRITELN;
  WRITELN;

  WRITELN ('Absolute value of complex number:  CAbs = ABS(z)');
  WRITELN;
  WRITELN ('z':11,'ABS(z)':17);
  WRITELN ('     ------------  ------------');
  FOR k := 1 TO 21 DO BEGIN
    WRITELN (k:3,' ',CStr(a[k],5,1,rectangular),'  ',CAbs(a[k]):12:9)
  END;
  WRITELN;

  WRITELN ('Complex integer power:  CIntPwr = z^n  ',
    '(using DeMoivre''s Theorem)');
  WRITELN;
  WRITELN ('z^3':34,'z^3':29);
  WRITELN ('z':11,'rectangular':27,'polar':26);
  WRITELN ('     ------------  ---------------------------  ',
    '-----------------------------');
  FOR k := 1 TO 21 DO BEGIN
    WRITE (k:3,' ',CStr(a[k],5,1,rectangular),'  ');
    IF   CAbs(a[k]) = 0.0
    THEN WRITELN ('undefined':18)
    ELSE BEGIN
      CIntPwr (z,a[k],3);
      IF   CAbs(z) > 10.0
      THEN m := 7
      ELSE m := 9;
      WRITELN (CStr(z,12,m,rectangular),' ',CStr(z,12,m,polar))
    END
  END;
  WRITELN;
  WRITELN;

  WRITELN ('Complex conjugate:  CConjugate = z*');
  WRITELN;
  WRITELN ('z*':35,'z*':29);
  WRITELN ('z':11,'rectangular':28,'polar':26);
  WRITELN ('     ------------  ---------------------------  ',
    '-----------------------------');
  FOR k := 1 TO 21 DO BEGIN
    WRITE (k:3,' ',CStr(a[k],5,1,rectangular),'  ');
    CConjugate (z,a[k]);
    WRITELN (CStr(z,12,8,rectangular),' ',CStr(z,12,8,polar))
  END;
  WRITELN;
  WRITELN;

  WRITELN ('Complex square root:  CSqrt = SQRT(z)');
  WRITELN;
  WRITELN ('SQRT(z)':36,'SQRT(z)':28);
  WRITELN ('z':11,'root 1':25,'root 2':28);
  WRITELN ('     ------------  ---------------------------  ',
    '---------------------------');
  FOR k := 1 TO 21 DO BEGIN
    WRITE (k:3,' ',CStr(a[k],5,1,rectangular),'  ');
    CSqrt (z,a[k]);       {same as CRoot (z,a[k],0,2)}
    CRoot (z1,a[k],1,2);
    WRITELN (CStr(z,12,9,rectangular),'  ',CStr(z1,12,9,rectangular))
  END;
  WRITELN;
  WRITELN;

  WRITELN ('The three cube roots of -1+i:  (-1+i)^(1/3)');
  WRITELN ('(See Schaum''s Outline Series "Complex Variables", 1964, ',
    'p. 18, problem 29.)');
  WRITELN;
  WRITELN ('z^(1/3)':35,'z^(1/3)':29);
  WRITELN ('z':11,'rectangular':27,'polar':26);
  WRITELN ('     ------------  ---------------------------  ',
    '-----------------------------');
  CSet (z1, -1,1, rectangular);
  FOR k := 0 TO 2 DO BEGIN
    WRITE (k:3,' ',CStr(z1,5,1,rectangular),'  ');
    CRoot (z,z1,k,3);
    WRITELN (CStr(z,12,9,rectangular),' ',CStr(z,12,9,polar))
  END;
  WRITELN;
  WRITELN;

  WRITELN ('Complex Bessel function:  CI0 = I0(z)');
  WRITELN;
  WRITELN ('I0(z)':36,'I0(z)':29);
  WRITELN ('z':11,'rectangular':27,'polar':26);
  WRITELN ('     ------------  ---------------------------  ',
    '-----------------------------');
  FOR k := 1 TO 21 DO BEGIN
    WRITE (k:3,' ',CStr(a[k],5,1,rectangular),'  ');
    CI0 (z,a[k]);
    IF   CAbs(z) > 10.0
    THEN m := 7
    ELSE m := 9;
    WRITELN (CStr(z,12,m,rectangular),' ',CStr(z,12,m,polar))
  END;
  WRITELN;
  WRITELN;

  WRITELN ('Complex Bessel function:  CJ0 = J0(z)');
  WRITELN;
  WRITELN ('J0(z)':36,'J0(z)':29);
  WRITELN ('z':11,'rectangular':27,'polar':26);
  WRITELN ('     ------------  ---------------------------  ',
    '-----------------------------');
  FOR k := 1 TO 21 DO BEGIN
    WRITE (k:3,' ',CStr(a[k],5,1,rectangular),'  ');
    CJ0 (z,a[k]);
    IF   CAbs(z) > 10.0
    THEN m := 7
    ELSE m := 9;
    WRITELN (CStr(z,12,m,rectangular),' ',CStr(z,12,m,polar))
  END;
  WRITELN;
  WRITELN;

  WRITELN ('Removing "Fuzz" from real numbers for zero test:');
  WRITELN;  {Note:  CStr calls CConvert that calls CDefuzz}
  CSet (z, -3.21E-14,7.65E-14, rectangular);
  WRITELN ('  Before:  ',z.x:18:15,' +',z.y:18:15,'i');
  CDeFuzz (z);
  WRITELN ('   After:  ',CStr(z,18,15,rectangular));
  WRITELN;
  CSet (z, -3.21E-14,PI, polar);
  WRITELN ('  Before:  ',z.r:18:15,'*CIS(',z.theta:18:15,')');
  CDeFuzz (z);
  WRITELN ('   After:  ',CStr(z,18,15,polar));
  WRITELN;
  WRITELN;

  WRITELN ('Miscellaneous:  FixAngle -- keep angle in interval (-PI..PI)');
  WRITELN;

  WRITELN ('     radians FixAngle');
  WRITELN ('    -------- --------');
  FOR n := -4 TO 8 DO BEGIN
    x := n*PI/2.0;
    y := FixAngle(x);
    WRITELN (n:3,' ',x:8:5,' ',y:8:5)
  END;
  WRITELN;
  WRITELN;

  WRITELN ('Real power function:  Pwr = x^y');
  WRITELN;
  WRITELN ('        x        y         x^y');
  WRITELN ('    -------- -------- ------------');
  WRITELN (' ':4,2.1:8:5,' ',-2.5:8:5,Pwr(2.1,-2.5):12:9);
  WRITELN (' ':4,2.1:8:5,' ', 2.5:8:5,Pwr(2.1, 2.5):12:9);
  WRITELN (' ':4,1.4:8:5,' ', 8.9:8:5,Pwr(1.2, 8.9):12:9);
  WRITELN (' ':4,0.0:8:5,' ', 2.0:8:5,Pwr(0.0, 2.0):12:9);
  WRITELN (' ':4,4.2:8:5,' ', 0.0:8:5,Pwr(4.2, 0.0):12:9);
  WRITELN;

END {cdemo}.
