{Full Name Unit : TextGraph
                               version 1.2
                        -- Dutch Coding Version --

 Last Update : Friday 9 december 1994
 release     : Monday 12 december 1994
 Length      : 1670 lines.

      Code by Rene "__Lowlevel__" Veerman --- Syntax Terror Software Inc

                   ***********************************
                   *      FOR HELP - SEE TPH FILE    *
                   ***********************************

 Rules : - Donated to Public Domain.
         - Modifications may be made, but then distributing is no longer
           allowed!
         - if you know how to make these routinez faster, you should tell me.

 Greetinx : Haij Bait - MegaHard Software - Hacktic NL - Hackers all over
            the world

 For suggestions/improvements/requests :

 Lowlevel
 Calkoengracht 21
 1131 ZM Volendam
 Holland
 +31-2993-63417 (call between 7-8 pm)

 Internet E-mail :
  Lowlevel@Xs4all.hacktic.nl
}


unit TxtGra12;
(**) Interface (**)

uses LowMouse,types,crt,dos,asciiset,stunit,scancode;
const {Scancodes van het toetsenbord}
      Space                = 57;  PgUp          = 73;
      Return               = 28;  PgDn          = 81;
      CursorUp             = 72;  Home          = 71;
      CursorLeft           = 75;  End_Key       = 79;
      CursorRight          = 77;
      CursorDown           = 80;
      {andere constanten}
      TextGraphVersion = 'Unit Text Graph Version 1.2';
      MaxScreenSaverBuffers = 4;
      WSRandom               = 1;
      WSVertical_Open        = 2;
      WSHorizontal_Open      = 3;
      WSAsciiUp              = 4;
      Normal                 = 0;
      Zoom                   = 1;
      Filled                 = 2;
      Shadow                 = 4;
      SmoothEdged            = 8;
      Computer               = 1;
      Rond                   = 2;
      Military               = 3;
      Weird                  = 4;
      SmallCute              = 5;

Type
 TScreen   = object
              ScreenSaverXY : array [0..(25*160),1..MaxScreenSaverBuffers] of byte;
              ScreenSaverX1,ScreenSaverX2,
              ScreenSaverY1,ScreenSaverY2 : array [1..MaxScreenSaverBuffers] of byte;
              Procedure Save (x1,y1,x2,y2,buffernr: byte);
              Procedure get (buffernr : byte; restore : byte);
             end;
 Tmenu   = object
              item : array [1..24] of string[80];
              itemPointer,
              x,y,
              OutColorFor,OutColorBack,InColorFor,
              InColorBack,SpColorFor,SpcolorBack             : byte;
              header                                         : string;
              ssbuff,
              headerasciiset,bodyasciiset,
              defaultitem                                    : byte;
              Centered,Zoom                        : boolean;
              constructor init;
              Procedure AddItem (invoer : string);
              Function Choice : integer;
             end;
 TPickScrollBox = Object
                       {vars}
                        Y1, Y2                     : Byte;
                        Item                       : Array[1..100] of String;
                        LastItem                   : Byte;
                        Zooming                    : Boolean;
                        Smoothedges                : boolean;
                        InFor, InBack,
                        OutFor, OutBack,
                        TitleFor, TitleBack,
                        ItemFor, ItemBack,
                        SelectedFor, SelectedBack  : Byte;
                        Ssbuff                     : byte;
                        Title                      : String;
                        Centered                   : Boolean;
                        DefaultItem                : byte;

                        Constructor Init;
                        Procedure AddItem (AddedItem : String);
                        Function Choice : Byte;
                        Destructor Done;
                       end;

 RadioButtonObj = object
                      BeginAsciiRadioButton : word;
                      constructor Make (BeginAscii : word);
                      procedure   PrintEmpty (x,y : byte);
                      procedure   PrintFull  (x,y : byte);
                     end;
 PushButtonObj  = object
                      BeginAsciiPushButton : word;
                      constructor Make (BeginAscii : word);
                      procedure   PrintEmpty (x,y : byte);
                      procedure   PrintFull  (x,y : byte);
                  end;

var     VideoPageSegment : Word;
        KleurenKaart     : boolean;
        KleurKnipperend  : boolean;
        Screen           : ^TScreen;
        Menu             : ^Tmenu;
        PickScrollBox    : ^TPickScrollBox;
        RadioButton      : ^RadioButtonObj;
        PushButton       : ^PushButtonObj;
        LegeRegel        : String;


procedure msgbox (Msg: string; boxvoor,boxachter,txtvoor,txtachter,
                               eruit: byte; eruittxt: string;
                               ssbuff : byte);
function GetTxtAscii (x,y : byte): byte;
Function GetTXtColorFor (x,y:byte): byte;
Function GetTxtColorBack (x,y:byte):byte;
Procedure PutTxtColorFor (x,y,color : byte);
procedure PutTxtColorBack (x,y,color : byte);
Procedure PutTxtAscii (x,y : byte; ascii : char);
Procedure PutTxtBlockColorFor (x1,y1,x2,y2,color : byte);
Procedure PutTxtBlockColorBack (x1,y1,x2,y2,color : byte);
Procedure PutTxtBlockColor (x1,y1,x2,y2,colorFor,ColorBack : Byte);
procedure Color (Front,Back: byte);
Procedure Cls (Soort : byte);
Procedure FillScreen (Ascii : char);
procedure FillScreenRandom (Gray : boolean);
Procedure RestoreOriginalStuff;
Procedure CursorOff;
Procedure CursorOn;
Procedure WinFill (x1,y1,x2,y2,asciis,colorFor,ColorBack : byte);
procedure TextInKader (x,y,outcolor,incolor,txtcolorout,txtcolorin: integer; intext : string; lengte: integer);
{not implemented in TPH file!}
procedure WritePos (X,Y: byte; Inp : string);
procedure Palette (kleur : word; r,g,b : byte);
procedure Fade (kleurnr : word; c1r,c1g,c1b,c2r,c2g,c2b,steps,wacht: byte;
                                aantalkeer : byte;
                                cursormoetuit : boolean);
Procedure Box (X1,Y1,X2,Y2,Taip            : Byte;
               Header                      : String;
               OutFor,OutBack,InFor,InBack : Byte;
               SsBuff                      : Byte);

procedure PrintRGB (x,y : byte; kl: word );
procedure DumpCurrentColors (x,y : byte);
Procedure WaitForScreenRefresh;
procedure Write25thLine (x:byte; input : string);
procedure CentreText (Y : byte; S: string);
{centreer een string op y positie Y
 hij schrijft 't direct naar VRAM, en kan ook op 25e regel schrijven.}

procedure IWant16BackGroundColors;
procedure IDontWant16BackGroundColors;
procedure SetCharacter (AsciiWaarde,k1,k2,k3,k4,k5,k6,k7,k8,k9,k10,k11,k12,k13,k14,k15,k16 : byte);

procedure beep;
{Laat een beepje horen}
Procedure FWrite (x,y : byte; S : String; colfor,colback : byte);
procedure Nop;
Function GetInput (maxLength : byte; Titel : string; smoothedges: boolean; outfor,outback,
                   infor,inback,titfor,titback,ssbuff : byte) : String;
Procedure WriteHelp (S: string);
Procedure ErrorMessage (Str : string; ssbuff : byte);
Procedure Coloroff;
Procedure Coloron;
{Next 6 procedures were done by MEGA HARD SOFTWARE}
{089N} procedure CapsLock_On;
{090N} procedure CapsLock_Off;
{091N} procedure NumLock_On;
{092N} procedure NumLock_Off;
{093N} procedure ScrollLock_On;
{094N} procedure ScrollLock_Off;

(**) implementation (**)
{---------------------------------------------------------------------------}
Procedure TextGraphInit;

var regs : registers;

begin
 {zoek naar kleurenkaart}
 regs.ah:=15;
 intr($10,regs);
 if regs.al=7 then begin
                    VideoPageSegment:=$b000;
                    KleurenKaart:=False;
                   end
              else begin
                    VideoPageSegment:=$b800;
                    KleurenKaart:=True;
                   end;
 {maak een string aan met 80 spaties.}
 KleurKnipperend:=true;
 Fillchar (LegeRegel,80,' ');
 LegeRegel[0]:=#80;
end;

{----------------------------------------------------------------------------}
procedure WachtOpSchermRefresh;

begin
 repeat until port[$3da] and 8 = 8;
end;

{---------------------------------------------------------------------------}
procedure TextInKader (x,y,outcolor,incolor,txtcolorout,txtcolorin:
                       integer; intext : string; lengte: integer);

var a,troep : integer;

begin
 textcolor (outcolor);
 textbackground (incolor);
 if (x=0) and (y=0) then x:=40; y:=12;
 x:=x-trunc(lengte/2);
 box (x,y-1,x-1+lengte,2,0,'',outcolor,incolor,0,0,0);
 textcolor (txtcolorout); textbackground (txtcolorin);
 gotoxy (x+1,y); writeln (intext);
end;
{---------------------------------------------------------------------------}
procedure msgbox (Msg: string; boxvoor,boxachter,txtvoor,txtachter,
                               eruit: byte; eruittxt: string;
                               ssbuff : byte);

var X,y,lengteX : byte;
    check : char;

begin
 {Bepaal breedte van het kader}
 if length(Msg) > (length('Hit ')+length(EruitTxt)+length(' to continue'))
  then lengteX:=length (Msg)
  else LengteX:=(length('Hit ')+length(EruitTxt)+length(' to continue'));
 lengteX:=lengteX+2;

 X:=round(40-(lengteX/2)); Y:=12;


 {Maak boxje}
 Box (x,y,x+lengteX,y+4,Filled+shadow,'',boxvoor,boxachter,txtvoor,txtachter,ssbuff);

 {zet txt erin}
 gotoxy (40-round(length(Msg)/2),y+1); write (Msg);
 gotoxy (40-round((length('Hit ')+length(EruitTxt)+length(' to continue'))/2)+1,y+3);
 write ('Hit ',eruitTxt,' to continue');

 if Eruit=0
  then readkey {iedere toets toegestaan om eruit te gaan}
  else begin {checken op een bepaalde toets}
        check:='';
        repeat
         check:=readkey;
        until check=chr(eruit);
       end;
end;

{----------------------------------------------------------------------------}
Function GetTxtAscii (x,y : byte) : byte;

var adres: integer;

begin
 adres:=(((y-1)*160)+((x-1)*2));
 GetTxtAscii:=mem[VideoPageSegment:adres];
end;

{----------------------------------------------------------------------------}
Function GetTxtColorBack (x,y: byte): byte;

var Waarde,adres: integer;

begin
 adres:=(((y-1)*160)+((x-1)*2))+1;
 waarde:=mem[VideoPageSegment:adres]; {vraag colorbyte op}
 waarde:=waarde and $70 div $10; {high nibble filteren}
 GetTxtColorback := Waarde;
end;

{----------------------------------------------------------------------------}
Function GetTxtColorFor (x,y: byte): byte;

var blinkbit,Waarde,adres : integer;

begin
 adres:=(((y-1)*160)+((x-1)*2))+1;
 waarde:=mem[VideoPageSegment:adres];
 waarde:=waarde and $0f;
 blinkbit:=mem[VideoPageSegment:adres] and $f0 div $10; {filter het msb eruit.}
 blinkbit:=blinkbit and $8 div 8;                  {msb = blinkbit}
 GetTxtColorFor:=waarde + (blinkbit*blink);
end;

{----------------------------------------------------------------------------}
Procedure PutTxtColorFor (x,y,color : byte);

var Waarde,adres : integer;
    blink        : boolean;

begin
 adres:=(((y-1)*160)+((x-1)*2))+1;
 if kleurknipperend then mem[VideoPageSegment:Adres]:=
                         (Mem[VideoPageSegment:adres] and $80) or color
                    else mem[VideoPageSegment:adres]:=
                         (Mem[VideoPageSegment:adres] and $F0) or color;
end;

{----------------------------------------------------------------------------}
procedure PutTxtColorBack (x,y,color : byte);
begin

 if KleurKnipperend
 then
  mem[VideoPageSegment:(((y-1)*160)+((x-1)*2))+1]:=
   (mem[VideoPageSegment:(((y-1)*160)+((x-1)*2))+1] and $8f) or (Color * 16)
 else
  mem[VideoPageSegment:(((y-1)*160)+((x-1)*2))+1]:=
   (mem[VideoPageSegment:(((y-1)*160)+((x-1)*2))+1] and $0F) or (Color * 16);
end;

{----------------------------------------------------------------------------}
Procedure PutTxtAscii (x,y : byte; ascii : char);

var adres,waarde : integer;

begin
 adres:=(((y-1)*160)+((x-1)*2))+1; mem[VideoPageSegment:adres]:=ord(Ascii);
end;


{----------------------------------------------------------------------------}
Procedure PutTxtBlockColorFor (x1,y1,x2,y2,color : byte);

var x,y : byte;

begin
 for y:=y1 to y2 do
  begin
   for x:=x1 to x2 do PutTxtColorFor (x,y,color);
  end;
end;

{----------------------------------------------------------------------------}
Procedure PutTxtBlockColorBack (x1,y1,x2,y2,color : byte);

var x,y : byte;

begin
 for x:=x1 to x2 do
  begin
   for y:=y1 to y2 do PutTxtColorBack (x,y,color);
  end;
end;

{----------------------------------------------------------------------------}
Procedure PutTxtBlockColor (x1,y1,x2,y2,colorFor,ColorBack : Byte);
var x,y : byte;
    adres : word;
    c     : byte;
begin
 c:=(colorback*16)+Colorfor;
 for x:=x1 to x2 do
  begin
   for y:=y1 to y2 do begin
                       Adres:=((y-1)*160)+(X*2)-1;
                       Mem[VideoPageSegment:Adres]:=c;
                      end;
  end;
end;

{----------------------------------------------------------------------------}
Procedure RestoreOriginalStuff;
 {Procedure done by Bas "Haij Bait" Heerschop}
 Begin
   Asm
     Mov AH,$00
     Mov AL,$02
     Or AL,10000000B
     Int ($10)
   End;
 End;

{----------------------------------------------------------------------------}
procedure WritePos (X,Y: byte; Inp : string);
begin
 gotoxy (x,y); write (inp);
end;

{----------------------------------------------------------------------------}
Procedure TScreen.save (x1,y1,x2,y2,buffernr: byte);

var adres : integer;
    x,y   : byte;

begin
 ScreenSaverX1 [Buffernr]:=X1;
 ScreenSaverY1 [Buffernr]:=Y1;
 ScreenSaverX2 [Buffernr]:=X2;
 ScreenSaverY2 [Buffernr]:=Y2;
 for x:=x1 to x2 do
  begin
   for y:=y1 to y2 do
    begin
     adres:=((y-1)*160+(x*2))-1;
     ScreenSaverXY [adres,buffernr]:=memw[VideoPageSegment:adres];
     dec(adres);
     ScreenSaverXY [adres,buffernr]:=memw[VideoPageSegment:adres];
    end;
  end;
end;

{----------------------------------------------------------------------------}
Procedure TScreen.get (buffernr : byte; restore : byte);

var adres,adres2,
    Adres3,Adres4    : integer;
    x,x1,x2,y,y1,y2,
    xc,yc,tel,teller : byte;
 procedure Restore0;
  var x,y : byte;
  begin
   for x:=x1 to x2 do
    begin
     for y:=y1 to y2 do
      begin
       adres:=((y-1)*160+(x*2))-1;
       mem[VideoPageSegment:adres]:=ScreenSaverXY [adres,buffernr];
       dec(adres);
       mem[VideoPageSegment:adres]:=ScreenSaverXY [adres,buffernr];
      end;
    end;
  end;

begin
 cursoroff;
 x1:=ScreenSaverX1 [Buffernr];
 X2:=ScreenSaverX2 [Buffernr];
 y1:=ScreenSaverY1 [Buffernr];
 y2:=ScreensaverY2 [Buffernr];
 if restore=normal then
  restore0;
 if restore=zoom then
  begin
   xc:=x1+round((x2-x1)/2);
   yc:=y1+round((y2-y1)/2);
   teller:=y2+1;
   for tel:=y1 to yc-2 do {10 stapjes}
    begin
     teller:=teller-1;
     y:=tel;
     for x:=x1 to x2 do
      begin
       adres2:=((teller-1)*160+(X*2))-1;
       adres:=((y-1)*160+(x*2))-1;
       mem[VideoPageSegment:adres+160]:=Mem[VideoPageSegment:Adres];
       mem[VideoPageSegment:Adres]:=ScreenSaverXY [adres,buffernr];
       mem[VideoPageSegment:adres2-160]:=Mem[VideoPageSegment:Adres2];
       mem[VideoPageSegment:Adres2]:=ScreenSaverXY [adres2,buffernr];
       dec (adres); dec(adres2);
       mem[VideoPageSegment:adres+160]:=Mem[VideoPageSegment:Adres];
       mem[VideoPageSegment:Adres]:=ScreenSaverXY [adres,buffernr];
       mem[VideoPageSegment:adres2-160]:=Mem[VideoPageSegment:Adres2];
       mem[VideoPageSegment:Adres2]:=ScreenSaverXY [adres2,buffernr];
      end;
     delay (10);
    end;
    y:=y+1;
    for x:=x1 to x2 do begin
     adres:=((y-1)*160+(x*2))-1;
     mem[VideoPageSegment:adres+160]:=Mem[VideoPageSegment:Adres];
     mem[VideoPageSegment:Adres]:=ScreenSaverXY [adres,buffernr];
     dec (adres); dec(adres2);
     mem[VideoPageSegment:adres+160]:=Mem[VideoPageSegment:Adres];
     mem[VideoPageSegment:Adres]:=ScreenSaverXY [adres,buffernr];
    end;
   delay (60);
   teller:=x2+1;
   for tel:=x1 to xc-2 do {10 stapjes}
    begin
     teller:=teller-1;
     y:=tel;
     for x:=yc to yc+1 do
      begin
       adres2:=((x-1)*160+(teller*2))-1;
       adres:=((x-1)*160+(y*2))-1;
       mem[VideoPageSegment:adres+2]:=Mem[VideoPageSegment:Adres];
       mem[VideoPageSegment:Adres]:=ScreenSaverXY [adres,buffernr];
       mem[VideoPageSegment:adres2-2]:=Mem[VideoPageSegment:Adres2];
       mem[VideoPageSegment:Adres2]:=ScreenSaverXY [adres2,buffernr];
       dec (adres); dec(adres2);
       mem[VideoPageSegment:adres+2]:=Mem[VideoPageSegment:Adres];
       mem[VideoPageSegment:Adres]:=ScreenSaverXY [adres,buffernr];
       mem[VideoPageSegment:adres2-2]:=Mem[VideoPageSegment:Adres2];
       mem[VideoPageSegment:Adres2]:=ScreenSaverXY [adres2,buffernr];
      end;
     delay (10);
    end;
   restore0;
  end; {if restore=1}
 cursoron;
end;
{----------------------------------------------------------------------------}
procedure FillScreenRandom (Gray : boolean);

var x : integer;
    r : byte;

begin
 randomize;
 for x:=0 to round((160*24)/2) do
  begin
   mem[VideoPageSegment:(X*2)-2]:=random(255);
  end;
 If not gray then
              for x:=0 to round((160*24)/2)  do
               begin
                mem[VideoPageSegment:(X*2)-1]:=random(128);
               end
             else
              for x:=0 to round((160*24)/2) do
               begin
                Mem[VideoPageSegment:(X*2)-1]:=7;
               end;
end;

{----------------------------------------------------------------------------}
Procedure Cls (Soort : byte);

const BytesOnScreen  = 80*24*2;
var Bk,Rx,Ry         : byte;
    Teller           : Integer;
    Regs             : Registers;
    Wachtjijmaareffe : byte;
    r,g,b            : array [0..15] of byte;
    tel,tel1         : integer;

begin
  cursoroff;
  if Soort=wsRANDOM then
       begin
        teller:=0;
        Randomize;
        While Teller<20000 do
         begin
          RX:=Random(81); RY:=Random(25);
          for wachtjijmaareffe:=1 to 40 do
           begin
            mem[VideoPageSegment:((ry-1)*160+(rx*2))-1]:=0;
            mem[VideoPageSegment:((ry-1)*160+(rx*2))]:=0;
           end;
          teller:=teller+1;
         end;
        clrscr;
       end; {'RANDOM'}
  if Soort=wsVERTICAL_OPEN then
     {this part was done by Bas Heerschop, april 1994}
       begin
        Gotoxy(1,13);Writeln ('                                                                                ');
        For Tel:=0 to 11 do
         Begin
          With Regs do
            Begin
             AH:=6; AL:=1; CH:=0; CL:=0; DH:=11; DL:=79; Intr ($10,Regs);
             Gotoxy(1,12);Writeln ('                                                                                ');
             AH:=7; CH:=13; DH:=24; Intr ($10,Regs);
             Gotoxy(1,14);Writeln ('                                                                                ');
            End;
        Delay (40);
        End; {For do.....}
       end;  {'VERTICAL OPEN'}
  if soort=wsHORIZONTAL_OPEN then
   begin
    for rx:=1 to 80 do
     begin
      for ry:=0 to 11 do
       begin
        for WachtJijMaarEffe:=1 to 3 do
         begin
          gotoxy (rx,ry*2); write (' ');
          gotoxy (81-rx,(ry*2)+1); write (' ');
          gotoxy (rx,24); write (' ');
         end;
       end;
     end;
   end; {WsHorizontal_open}
  if soort=wsAsciiUp then
   begin
    For Tel1:=1 to 256-32 do
     For tel:=-1 to BytesOnScreen do
      begin
       inc(tel);
       If (Mem[videoPageSegment:tel]<255) and not (Mem[videoPageSegment:tel]=32)
         then Inc(Mem[VideoPageSegment:Tel]);
      end;
   end; {wsAsciiUp}
 cursoron;
end; {Procedure Cls}
{----------------------------------------------------------------------------}

Procedure CursorOff; assembler;
 asm
  push BP
  xor  AX, AX
  mov  ES, AX
  mov  BH, Byte Ptr ES:[462h]
  mov  AH, 3
  int  10h
  or   CH, 32
  mov  AH, 1
  int  10h
  pop  BP
 End; {Procedure CursorOff}
{----------------------------------------------------------------------------}
Procedure CursorOn; assembler;
 asm
  push BP
  xor  AX, AX
  mov  ES, AX
  mov  BH, Byte Ptr ES:[462h]
  mov  AH, 3
  int  10h
  and  CH, 31
  mov  AH, 1
  int  10h
  pop  BP
 End; {Procedure CursorOn}
{----------------------------------------------------------------------------}
Procedure FillScreen (Ascii : char);

var y : integer;
    charstuff : string;

begin
 Fillchar (charstuff,81,ascii);
 Charstuff[0]:=#81;
 for y:=1 to 25 do
  begin
   gotoxy (1,y); write (charstuff);
  end;
 Write25thLine (1,charstuff);
end; {Procedure FillScreen^}
{----------------------------------------------------------------------------}
procedure Palette (kleur : word; r,g,b : byte); assembler;

asm
 mov Ah,$10
 mov AL,$10
 mov bx,kleur
 mov ch,g
 mov dh,R
 mov cl,b
 int $10
end;

{----------------------------------------------------------------------------}
procedure Fade (kleurnr : word; c1r,c1g,c1b,c2r,c2g,c2b,steps,wacht: byte;
                                aantalkeer : byte;
                                cursormoetuit : boolean);

var hoofd,tel: byte;
    r,g,b : byte;
    rr,rg,rb : real;

begin
 hoofd:=1;
 rr:=c1r;
 rg:=c1g;
 rb:=c1b;

 while hoofd<=aantalkeer do
  begin
   for tel:=1 to steps do
    begin
     if c1r>c2r then rr:=rr-((c1r-c2r)/steps)
      else if c2r>c1r then rr:=rr+((c2r-c1r)/steps);
     if c1g>c2g then rg:=rg-((c1g-c2g)/steps)
      else if c2g>c1g then rg:=rg+((c2g-c1g)/steps);
     if c1b>c2b then rb:=rb-((c1b-c2b)/steps)
      else if c2b>c1b then rb:=rb+((c2b-c1b)/steps);
     r:=trunc(rr); g:=trunc(rg); b:=trunc(rb);
     palette (kleurnr,r,g,b);
     if cursormoetuit then cursoroff;
     if wacht>0 then delay (wacht);
    end;

    hoofd:=hoofd+1;
    while hoofd<=aantalkeer do
     begin
      for tel:=1 to steps do
       begin
        if c1r>c2r then rr:=rr+((c1r-c2r)/steps)
         else if c2r>c1r then rr:=rr-((c2r-c1r)/steps);
        if c1g>c2g then rg:=rg+((c1g-c2g)/steps)
         else if c2g>c1g then rg:=rg-((c2g-c1g)/steps);
        if c1b>c2b then rb:=rb+((c1b-c2b)/steps)
         else if c2b>c1b then rb:=rb-((c2b-c1b)/steps);
        r:=trunc(rr); g:=trunc(rg); b:=trunc(rb);
        palette (kleurnr,r,g,b);
        if cursormoetuit then cursoroff;
        if wacht>0 then delay (wacht);
       end;
      hoofd:=hoofd+1
     end; {tweede while-do}
  end; {eerste while-do}
end; {Procedure FADE}

{----------------------------------------------------------------------------}
procedure Color (Front,Back: byte);

begin
 if kleurknipperend=true then
  begin
   TextColor (Front); TextBackGround (Back);
  end;
 if kleurknipperend=false then
  begin
   if Back>7 then Textcolor (front+128) else TextColor (front);
   textbackground (back);
  end;
end;

{----------------------------------------------------------------------------}
procedure DumpCurrentColors (x,y : byte);
var t: byte;
begin
 for t:=1 to 15 do
  begin
   textcolor (t); textbackground (t);
   gotoxy (x+t,y); write ('');
  end;
end;

{----------------------------------------------------------------------------}
procedure PrintRGB (x,y : byte; kl: word );

var r,g,b : byte;
    regs : registers;

begin
 gotoxy (x,y);
 regs.AX:=$1015;
 regs.bl:=kl;
 intr ($10,regs);
 r:=regs.dh;
 g:=regs.ch;
 b:=regs.cl;
 writeln ('R : ',r);
 gotoxy (x,y+1); Writeln ('G : ',g);
 gotoxy (x,y+2); Writeln ('B : ',b);
end;

{----------------------------------------------------------------------------}
constructor Tmenu.Init;

begin
 itemPointer   :=0;
 X             :=0;    Y           :=0;
 OutColorFor   :=15;   OutColorBack:=1;
 InColorFor    :=7;    IncolorBack :=1;
 SpColorFor    :=0;    SpColorBack :=7;
 header        :='';
 ssbuff        :=0;
 HeaderAsciiSet:=0;    BodyAsciiSet:=0;
 DefaultItem   :=1;
 Centered:=true; Zoom:=False;
end;

{----------------------------------------------------------------------------}
Procedure Tmenu.AddItem (invoer : string);

begin
 itemPointer:=itemPointer+1;
 item[itemPointer]:=invoer;
end;

{----------------------------------------------------------------------------}
Function Tmenu.Choice : integer;

label einde;

var adres                                                   : integer;
    SchaduwWaarde                                           : byte;
    hulp,inkey2,inkey,CurItm,lengthX,teller,teller2,lengthY : byte;
    TitelSchaduw                                            : byte;
    mouse                                                   : boolean;
    x1,x2,y1,y2,Xc,Yc                                       : byte;

begin
 {bepaal de langste string in horizontale richting}
 lengthX:=length(Header);
 for teller:=1 to itemPointer do
  begin
   if length(item[teller])>lengthX then lengthX:=length(item[teller]);
  end;
 lengthX:=lengthX; LengthY:=itemPointer+1;
 {Als je bij x / y 0 meegeeft, dan wordt ie Centered op de desbetreffende
  as}
 If x=0 then x:=40-ROUND(lengthX/2);
 if y=0 then y:=12-ROUND(itemPointer/2);
 {Indien nodig, bewaar scherm}
 if (header<>'') and (SSBuff<>0) then
  Screen^.Save (x,y-2,x+lengthX+3,y+LengthY+1,SSbuff);
 If (Header='') and (SSBuff<>0) then
  Screen^.Save (x,y,x+LengthX+3,Y+LengthY+1,ssbuff);
 {opkomen Menu}
 xc:=x+round(lengthX/2); yc:=y+round(ItemPointer/2);
 if not Zoom then
  begin
   teller:=1;
   if header='' then
    begin
     while teller<10 do
      begin
       Box     (round(xc+teller*(x-xc)/10),round(yc+teller*(y-yc)/10),
                round(xc+teller*(x+lengthX-xc)/10),round(yc+teller*(y+ItemPointer-yc)/10),
                filled,'',
                OutColorFor,OutColorBack,InColorFor,Incolorback,0);
       teller:=teller+1;
       delay (25);
      end;
    end;
   if header<>'' then
    begin
     while teller<10 do
      begin
       Box     (round(xc+teller*(x-xc)/10),round(yc+teller*((y-2)-yc)/10),
                round(xc+teller*(x+lengthX-xc)/10),round(yc+teller*(y+ItemPointer-yc)/10),
                filled,'',
                OutColorFor,OutColorBack,InColorFor,Incolorback,0);
       teller:=teller+1;
      end;
    end;
  end; {Zoom?}
 {maak box voor menu zelf}
 Box (x,y,x+lengthX+1,y+itemPointer+1,filled+shadow,'',OutColorFor,OutColorBack,incolorFor,incolorBack,0);
 {maak box voor titel van menu (als ie nodig is)}
 if header<>'' then begin
                     box (x,y-2,x+lengthX+1,y,0,'',OutColorFor,OutColorBack,0,0,0);
                     gotoxy (x,y); write (''); {ascii 195}
                     gotoxy (x+1+lengthX,y); write (''); {ascii 180}
                     for teller:=1 to lengthX do begin
                                                 gotoxy (x+teller,y-1);
                                                 write (' ');
                                                end;
                     gotoxy ((x+(trunc(lengthX/2)))-trunc(length(header)/2)+1,y-1);
                     if headerasciiset<>0 then begin
                                                SetSpecialAsciiSet (HeaderAsciiSet,1);
                                                spwriteln (header,1)
                                               end
                      else writeln (header);
                    end;
 {Schrijf de items in het menu}
 Color (InColorFor,InColorBack);
 If BodyAsciiSet<>Normal then SetSpecialAsciiSet (BodyAsciiSet,2);
  for teller:=1 to itemPointer do
  begin
   if Centered
    then gotoxy (round(X+(lengthX)/2-(length(Item[teller])/2))+1,y+teller)
    else gotoxy (x+1,y+teller);
   if bodyasciiset<>0 then spwriteln (item[Teller],2)
    else write (item[teller]);
   {maak in het hele menu de boel schoon & de juiste kleur}
  end;
 {schaduwrand}
 If KleurKnipperend then SchaduwWaarde:=$07 else SchaduwWaarde:=$87;
 if header<>'' then TitelSchaduw:=2 else TitelSchaduw:=0;
 for teller:=y+1-titelSchaduw to y do
  begin
   adres:=((teller-1)*160+(x+lengthX+1)*2)+1;
   mem [VideoPageSegment:Adres]:=Mem[VideoPageSegment:adres] and SchaduwWaarde;
   adres:=adres+2;
   mem [VideoPageSegment:Adres]:=Mem[VideoPageSegment:adres] and SchaduwWaarde;
  end;

 CursorOff;

 {en nu de keuze bepalen....}
 CurItm:=DefaultItem; inkey:=255; inkey2:=255; mouse:=false;
 while (inkey<>return) and (inkey<>Space) and (not mouse) do
 begin
  PutTxtBlockColor (X+1,y+CurItm,X+LengthX,y+CurItm,SpColorFor,SpColorBack);
  {zorg ervoor dat de boel niet gaat knipperen}
  repeat
   inkey:=port[$60];
   mouse:=TestTmouse (x+1,y+1,x+lengthX,y+LengthY-1);
   KillKeyboardBuffer;
   if mouse then inkey:=0;
  until inkey<>inkey2;
  inkey2:=inkey;
  if inkey2=1 then begin
                    Choice:=-1;
                    goto einde;
                   end;

  {Pijltje omhoog ingedrukt?}
  If inkey=Cursorup then
   begin
    WachtOpSchermRefresh;
    PutTxtBlockColor (X+1,y+CurItm,X+LengthX,y+CurItm,InColorFor,InColorBack);
    CurItm:=CurItm-1;
   end;
  {Nee? Pijltje omlaag dan?}
  If inkey=CursorDown then
   begin
    WachtOpSchermRefresh;
    PutTxtBlockColor(X+1,y+CurItm,X+LengthX,y+CurItm,InColorFor,InColorBack);
    CurItm:=CurItm+1;
   end;
  {voor wrapping around van het menu-balkje}
  if CurItm=0 then CurItm:=itemPointer;
  If CurItm>itemPointer then CurItm:=1;
 end; {do while}
 choice:=curItm; {vanuitgaan dat het met het toetsenbord is gekozen}
 if (mousebuttonY>y) and (MousebuttonY<Y+LengthY)
          then begin
                {Keuze gemaakt door muis, niet door toetsenbord}
                hulp:=MouseButtonY-y;
                choice:=Hulp;
                PutTxtBlockColorBack (X+1,y+CurItm,X+LengthX,y+CurItm,InColorBack);
                PutTxtBlockColorFor (X+1,y+CurItm,X+LengthX,y+CurItm,InColorFor);
                PutTxtBlockColorBack (X+1,y+hulp,X+LengthX,y+hulp,SpColorBack);
                PutTxtBlockColorFor (X+1,y+hulp,X+LengthX,y+hulp,SpColorFor);
               end;
Einde:
 KillKeyboardBuffer;
 Cursoron;
end; {Function Menu_choice}
{----------------------------------------------------------------------------}

constructor RadioButtonobj.Make (BeginAscii : word);

begin
 BeginAsciiRadioButton:=BeginAscii;
 asm
  (* made with a lot of help from JEROIIN & HAIJ BAIT *)
  (* place BP & ES on stack *)
  Push BP
  Push ES
  jmp @prog

 @AsciiStuff: (* Ascii code data *)

  DB $00,$00,$3c,$42,$81,$81,$81,$81,$81,$42,$3c,$00,$00,$00,$00,$00
  DB $00,$00,$3c,$42,$99,$bd,$bd,$bd,$99,$42,$3c,$00,$00,$00,$00,$00

 @Prog:
  (* change AsciiSet *)
  mov dx,BeginAscii
  mov BX,Seg[@AsciiStuff] (* Segment adress of data *)
  mov Es,BX
  mov BP,OffSet[@AsciiStuff] (* OffSet Adress of data *)
  mov cx,$2
  mov ax,$1110
  mov bx,$1000
  int $10

  (* get BP & ES from stack *)
  pop Bp
  pop Es
 end;
end;

{----------------------------------------------------------------------------}
procedure RadioButtonobj.PrintEmpty (x,y : byte);
begin
 mem[VideoPageSegment:(((Y-1)*160)+(X*2)-2)]:=BeginAsciiRadioButton;
end;

{----------------------------------------------------------------------------}
procedure RadioButtonobj.PrintFull (x,y : byte);
begin
 mem[VideoPageSegment:(((Y-1)*160)+(X*2)-2)]:=BeginAsciiRadioButton+1;
end;

{----------------------------------------------------------------------------}
constructor PushButtonobj.Make (BeginAscii : word);
begin
 BeginAsciiPushButton:=BeginAscii;
 asm
  (* made with a lot of help from JEROIIN & HAIJ BAIT *)

  (* place BP & ES on stack *)
  Push BP
  Push ES
  jmp @prog

 @AsciiStuff: (* Ascii code data *)

  DB $00,$00,$3c,$42,$81,$81,$81,$81,$81,$42,$3c,$00,$00,$00,$00,$00
  DB $00,$01,$3E,$42,$85,$85,$C9,$A9,$91,$42,$3c,$00,$00,$00,$00,$00

 @Prog:
  (* change AsciiSet *)
  mov dx,BeginAscii
  mov BX,Seg[@asciiStuff] (* Segment adress of data *)
  mov Es,BX
  mov BP,OffSet[@asciistuff] (* OffSet Adress of data *)
  mov cx,$2
  mov ax,$1110
  mov bx,$1000
  int $10

  (* get BP & ES from stack *)
  pop Bp
  pop Es
 end;
end;

{----------------------------------------------------------------------------}
procedure PushButtonobj.PrintEmpty (x,y : byte);
begin
 mem[VideoPageSegment:(((Y-1)*160)+(X*2)-2)]:=BeginAsciiPushButton;
end;

{----------------------------------------------------------------------------}
procedure PushButtonobj.PrintFull (x,y : byte);
begin
 mem[VideoPageSegment:(((Y-1)*160)+(X*2)-2)]:=BeginAsciiPushButton+1;
end;

{----------------------------------------------------------------------------}
procedure Write25thLine (x:byte; input : string);
var tel,adres,waarde : integer;
begin
 tel:=1;
 while tel<=length(input) do
  begin
   adres:=3838+((x+tel)*2)-2;
   waarde:=byte(input[tel]);
   mem [VideoPageSegment:Adres]:=waarde;
   mem [VideoPageSegment:Adres+1]:=textattr;
   tel:=tel+1;
  end;
end;

{---------------------------------------------------------------------------}
procedure CentreText (Y : byte; S: string);
var adrestxt,AdresCol : word;
    X,teller :byte;

begin
 if length(S)>80
 then
  begin
   {Fout!!!! je mag geen string langer dan 80 invoeren!}
   beep;
   color (7,0); Clrscr;
   Writeln (TextGraphVersion,' reports an error :');
   Writeln;
   Writeln ('Procedure CentreText : You can''t pass along a string longer');
   Writeln ('                         than 80 characters');
   Writeln;
   Writeln ('Text Graph code by __Lowlevel__ - (c) 1994 Syntax Terror Software Inc.');
   halt(1);
  end
 else
  begin
   X := 40-round(length(S)/2);
   AdresTxt:=((y-1)*160)+((X-1)*2);
   AdresCol:=AdresTXT+1;
   for teller:=1 to length (s) do
    begin
     mem [VideoPageSegment:AdresTXT]:=Byte(s[teller]);
     mem [VideoPageSegment:AdresCol]:=TextAttr;
     AdresTxt:=AdresTxt+2; AdresCol:=AdresCol+2;
    end;
  end;
end;

{---------------------------------------------------------------------------}
procedure IWant16BackGroundColors;
begin
kleurknipperend:=false;
asm
 mov ax,$1003
 mov bx,$0000
 int $10;
end;
end;

procedure IDontWant16BackGroundColors;
begin
kleurknipperend:=true;
asm
 mov ax,$1003
 mov bx,$0001
 int $10
end;
end;

procedure beep;
begin
 sound (500); delay (20);
 nosound;
end;

procedure SetCharacter (AsciiWaarde,k1,k2,k3,k4,k5,k6,k7,k8,k9,k10,k11,k12,k13,k14,k15,k16 : byte);
var reg: registers;
    k  : array [1..16] of byte;
begin
 k[1]:=k1; k[4]:=k4; k[7]:=k7; k[10]:=k10; k[13]:=k13; k[16]:=k16;
 k[2]:=k2; k[5]:=k5; k[8]:=k8; k[11]:=k11; k[14]:=k14;
 k[3]:=k3; k[6]:=k6; k[9]:=k9; k[12]:=k12; k[15]:=k15;
 reg.dx:=AsciiWaarde;
 reg.BX:=Seg(k); (* Segment adress of data *)
 reg.Es:=reg.BX;
 reg.BP:=OfS(k); (* OffSet Adress of data *)
 reg.cx:=$1;
 reg.ax:=$1110;
 reg.bx:=$1000;
 intr ($10,reg);
end;

Procedure WinFill (x1,y1,x2,y2,asciis,colorFor,ColorBack : byte);
var x,y,attr,tel  : byte;
    Adres         : integer;
begin
 attr:=ColorFor OR (ColorBack *8);
 for y:=y1 to y2 do
  begin
   tel:=(x2-x1)+1;
   Adres:=((y-1)*160+(X1-1)*2);
   repeat
    mem[VideoPageSegment:Adres]:=asciis;
    inc(adres);
    mem[VideoPageSegment:Adres]:=Attr;
    inc(adres); Dec(Tel);
   until tel=0
  end;
end;

{---------------------------------------------------------------------------}
procedure Nop;
begin
end;

{---------------------------------------------------------------------------}
Function GetInput (maxLength : byte; Titel : string; smoothedges: boolean; outfor,outback,
                   infor,inback,titfor,titback,ssbuff : byte) : String;
var x1,y1,x2,y2,x : byte;
    kar           : char;
    ok            : byte; {voor Ord(Kar)}
    InputTotNuToe : string;
begin
 Color (infor,inback);
 y1:=11; y2:=13;
 x1:=40-round(maxlength/2)-5; x2:=x1+maxlength+10;
 if smoothedges then Box (x1,y1-1,x2,y2,filled+shadow+zoom+Smoothedged,titel,outfor,outback,infor,inback,ssbuff)
                else Box (x1,y1,x2,y2,filled+shadow+zoom,titel,outfor,outback,infor,inback,ssbuff);
 gotoxy (x1+1,y1+1); write ('Input : ',stringetje('',MaxLength));
 x:=x1+9; kar:='N'; InputTotNuToe:=''; Color (infor,inBack);
 while kar<>chr(13) do
  begin
   gotoxy (x,y1+1);
   kar:=readkey;
   ok:=ord(kar);
   if (ok<32) or (ok>254) then begin
                                if (ok<>8) and (ok<>13) then beep;
                               end
                          else begin
                                if x-x1-9>maxlength then begin
                                                          beep;
                                                         end
                                                    else begin
                                                          color (infor,inback);
                                                          write (kar);
                                                          InputTotNuToe:=InputTotNuToe+Kar;
                                                          inc(x);
                                                         end;

                               end;
   if ok=8 then begin
                 {Hee, een backspace!}
                 x:=x-1;
                 if x<x1+9 then begin
                                 beep;
                                 inc(x);
                                end
                           else begin
                                 Color (infor,inback);
                                 writepos (x,y1+1,chr(176));
                                 gotoxy (x,y1+1);
                                 delete(InputTotNuToe,Length(InputTotNuToe),1);
                                end;
                end;
 end;
Getinput:=InputTotNuToe;
If SSbuff<>0 then Screen^.Get (SSbuff,Zoom);
end;

{---------------------------------------------------------------------------}
Procedure WriteHelp (S: string);
var adres : word;
begin
 {Wissen ouwe txt}
 adres:=3846;
 while adres<3846+(75*2) do
  begin
   mem [VideoPageSegment:adres]:=0;
   adres:=adres+2;
  end;
 {Zet nieuwe Txt neer}
 CentreText (25,S);
end;
{---------------------------------------------------------------------------}
Procedure ErrorMessage (Str : string; ssbuff : byte);
begin
 if ssbuff=0 then begin
                   clrscr; write ('error in procedure ErrorMessage : you can''t '+
                                  'give 0 for ssbuff!');
                   halt(1);
                  end;
 Box (40-round(length(str)/2)-2,10,40+round(length(str)/2)+2,
      12,filled+shadow+zoom,'',15,1,11,1,ssbuff);
 Color (15,1);
 gotoxy (36,10); write (''); color (13,1); write ('Error :');
 color (15,1); write ('');
 color (14,1);
 gotoxy (40-round(length(str)/2),11); write (str);
 cursoroff;
 readkey;
 cursoron;
 Screen^.get (ssbuff,1);
end;

{---------------------------------------------------------------------------}
procedure ColorOn;
begin
  mem[0:1040]:=(mem[0:1040] and 207) or 32;    {to color monitor}
end;

{---------------------------------------------------------------------------}
procedure ColorOff;
begin
  mem[0:1040]:=(mem[0:1040] and 207) or 48;      {to mono monitor}
end;

{---------------------------------------------------------------------------}
Procedure WaitForScreenRefresh;
begin
WachtOpSchermRefresh;
end;

{---------------------------------------------------------------------------}
procedure CapsLock_On;
begin
 MemW[$0041:$0007] := MemW[$0041:$0007] or $0040;
end;

{---------------------------------------------------------------------------}
procedure CapsLock_Off;
begin
 MemW[$0041:$0007] := MemW[$0041:$0007] xor $0040;
end;

{---------------------------------------------------------------------------}
procedure NumLock_On;
begin
 MemW[$0041:$0007] := MemW[$0041:$0007] or $0020;
end;

{---------------------------------------------------------------------------}
procedure NumLock_Off;
begin
 MemW[$0041:$0007] := MemW[$0041:$0007] xor $0020;
end;

{---------------------------------------------------------------------------}
procedure ScrollLock_On;
begin
 MemW[$0041:$0007] := MemW[$0041:$0007] or $0010;
end;

{---------------------------------------------------------------------------}
procedure ScrollLock_Off;
begin
 MemW[$0041:$0007] := MemW[$0041:$0007] xor $0010;
end;

{---------------------------------------------------------------------------}
Procedure FWrite (x,y : byte; S : String; colfor,colback : byte);
var adres : word;
    Color : byte;
    Tel,
    Tel1  : Word;
Begin
 color := colfor or (colback shl 4);
 adres:=((y-1)*160)+((x-1)*2);
 Tel1:=1;
 Tel:=adres;
 While Tel<=Adres+(length(s)*2)-2 do
  begin
   Mem [VideoPageSegment:Tel]:=Ord(S[tel1]);
   Inc(Tel1); inc(tel);
   Mem [VideoPageSegment:Tel]:=Color;
   Inc(tel);
  end;
end;

{---------------------------------------------------------------------------}
Constructor TPickScrollBox.Init;
Var Tel : byte;
begin
 for tel:=1 to 100 do Item[tel]:='';
 LastItem    := 0;
 Zooming        := true;
 InFor       := 10;       InBack       :=  1;
 OutFor      := 15;       OutBack      :=  1;
 SelectedFor := 14;       SelectedBack :=  0;
 TitleFor    := 10;       TitleBack    :=  1;
 ItemFor     := 14;       ItemBack     :=  1;
 Y1          := 14;       Y2           := 20;
 SmoothEdges := True;
 SsBuff      :=  0;
 Title       := '';
end;

{---------------------------------------------------------------------------}
Procedure TPickScrollBox.AddItem;
begin
 Inc(LastItem);
 Item[LastItem]:=AddedItem;
end;

{---------------------------------------------------------------------------}
Function TPickScrollBox.Choice;
Var LengthLongestItem : Byte;
    tel               : byte;
    Halfway           : byte;
    ItemPointerTop,
    ItemPointerBottom : Byte;
    X1,X2             : Byte;
    key,key1          : byte;
    MenuPointer       : Byte;
    Options           : Byte;
    Procedure UpdateListOfChoices;
    var tel                : byte;
        tel1               : byte;
        LengthLeft         : integer;
        LengteBalk         : Byte; {vertical length!}
        x,target           : integer;
        temp               : string;
    begin
    {Calculate the side-bar's position}
     LengteBalk:=(Y2-1)-(y1+1);
     x:=round((((MenuPointer+ItemPointerTop-1)*100)/LastItem));
     if menupointer=lastitem then x:=100;
     target:=Round(((LengteBalk*x)/100));
     if target=0 then target:=1;
     If target+y1+1=y2-1 then dec(target);
     If menupointer=1 then target:=1;
     FWrite (x2,y1+1,chr(30),Outfor,Outback);
     FWrite (x2,y2-1,chr(31),Outfor,Outback);
     For Tel:=Y1+2 to Y2-2 do
       FWrite (X2,tel,chr(177),Outfor,Outback);
     Fwrite (x2,y1+1+target,chr(254),Outfor,Outback);
    {Write the items on screen}
     tel1:=0;
     For Tel:=ItemPointertop to ItemPointerBottom do
       begin
         inc(tel1);
         LengthLeft:=(x2-(x1+length(Item[tel])))-2;
         if LengthLeft<0 then LengthLeft:=0;
         Temp:=Gecentreerd(Item[tel],(x2-1)-(X1+1));
         If Centered then Fwrite (X1+1,Y1+tel1,temp,itemfor,itemback)
                     else Fwrite (X1+1,Y1+tel1,Item[tel]+Stringetje (' ',LengthLeft),itemfor,itemback);
       end;
    end;

begin
{Put off the cursor}
 CursorOff;

{get the length of the longest Item/Title}
 LengthLongestItem:=0;
 For Tel:=1 to LastItem do
  If length(Item[tel])>LengthLongestItem then LengthLongestItem:=Length(Item[tel]);
 If Length(Title)>LengthLongestItem then LengthLongestItem:=Length(title);

{it can not be longer than 75}
 If LengthLongestItem>75 then Begin
                              clrscr;
                              Writeln ('Error : TPickScrollBox, Unit Txtgra11.');
                              Writeln ('        One of the items is longer than 75 chars.');
                              halt(1);
                             end;
{Draw the screen}
 HalfWay := Round(lengthlongestitem/2);
 X1      := 40-halfway;
 X2      := 40+halfway;
 repeat
  If (X1+LengthLongestItem)>=X2 then Inc(x2);
 until (X1+LengthLongestItem)<=X2;
 inc(x2);
 options:=0;
 If Zooming then Inc(options,zoom);
 if Smoothedges then inc(options,smoothedged);
 Box (x1,y1,x2,y2,Filled+shadow+options,title,outfor,outback,itemfor,itemback,ssbuff);

{Initialise pointers}
 ItemPointerTop    := 1;
 ItemPointerBottom := Y2-Y1-1;
 MenuPointer       := DefaultItem;
 If MenuPointer>ItemPointerBottom then begin
                                        Inc (ItemPointerBottom,(menupointer-itempointertop));
                                        tel:=MenuPointer;
                                        MenuPointer:=1;
                                        Inc (ItemPointerTop,(Tel-ItemPointerTop));
                                       end;
{Update screen}
 UpdateListOfChoices;

{Print menubar}
 PutTXTBlockColor (x1+1,y1+MenuPointer,x2-1,Y1+MenuPointer,
                   SelectedFor,SelectedBack);

{Main loop}
 key:=port[$60]; key1:=key;
 While (key<>scEsc) and (Key<>scEnter) do
  begin
   cursoroff;
  {read new character from keyboard.}
   While Key=Key1 do
   Key1:=port[$60];
   key:=key1;
   KillKeyboardBuffer;

  {Erase old menubar}
   WaitForScreenRefresh;
   PutTXTBlockColor (x1+1,y1+MenuPointer,x2-1,Y1+MenuPointer,
                     ItemFor,ItemBack);

  {process keyboard data}
   Case Key of
    ScEnter    : Key:=ScEsc;
    ScCursUp   : case (MenuPointer=1) of
                   True  : If ItemPointerTop>1 then begin
                                                     Dec(ItemPointerTop);
                                                     Dec(ItemPointerBottom);
                                                    end;
                   False : dec(MenuPointer);
                  end;

    ScCursDown : if menupointer<LastItem then
                  Case (MenuPointer>(Y2-Y1-2)) of
                   true  : If ItemPointerBottom<LastItem then
                              begin
                               Inc(ItemPointerTop);
                               Inc(ItemPointerBottom);
                              end;
                   False : Inc(MenuPointer);
                  end;
   end;
  {Update screen}
   UpdateListOfChoices;

  {Print new menubar}
   PutTXTBlockColor (x1+1,y1+MenuPointer,x2-1,Y1+MenuPointer,
                     SelectedFor,SelectedBack);

  end; {Main loop}

{determine choice}
 Choice:=ItemPointerTop+MenuPointer-1;

{Put the cursor back on}
 CursorOn;
end; {function TPickScrollBox.Run}

{---------------------------------------------------------------------------}
Destructor TPickScrollBox.Done;
begin
 cursoroff;
 If SSBuff<>0 then if Zooming then Screen^.Get (Ssbuff,Zoom)
                              else Screen^.Get (SSbuff,normal);
 cursoron;
end;

{---------------------------------------------------------------------------}
Procedure Box (X1,Y1,X2,Y2,Taip            : Byte;
               Header                      : String;
               OutFor,OutBack,InFor,InBack : Byte;
               SsBuff                      : Byte);
var {Main Box} x,y,xc,yc : byte;
               teller : integer;
               xx1,yy1,yy2,xx2 : byte;
               AsciiDown,AsciiUp,AsciiLeft,AsciiRight: byte;

 {local} Function TestTaip (Value : Byte):boolean;
         begin
          If (Taip AND Value) > 0 then TestTaip:=true
                                  else TestTaip:=false;
         end;
 {local} Procedure FuckUpAsciiSet;
         begin
          Setcharacter (AsciiDown,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$ff,$ff,$ff);
          SetCharacter (AsciiLeft,$e0,$e0,$e0,$e0,$e0,$e0,$e0,$e0,$e0,$e0,$e0,$e0,$e0,$e0,$e0,$e0);
          SetCharacter (AsciiRight,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03);
          Setcharacter (195,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$03,$ff,$ff,$ff);
          Setcharacter (194,$e0,$e0,$e0,$e0,$e0,$e0,$e0,$e0,$e0,$e0,$e0,$e0,$e0,$ff,$ff,$ff);
         end; {fuck up asciiset}
 {local} Procedure SetAsciiValues;
         Begin
          Case TestTaip (smoothedged) of
           true  : begin
                    AsciiUp:=219;
                    AsciiDown:=210;
                    AsciiLeft:=215;
                    AsciiRight:=208;
                    FuckUpAsciiSet;
                   end;
           False : begin
                    AsciiUp:=196;
                    AsciiDown:=196;
                    AsciiLeft:=179;
                    AsciiRight:=179;
                   end;
          end; {case}
         end; {setasciivalues}
         Procedure WriteBox (x1,y1,x2,y2 : byte);
         Var Loopje       : Integer;
             DataAsc1    : Word;
             DataAsc2  : Word;
         Begin
          Color (OutFor,OutBack);
          {horizontal}
          loopje:=x1;
          DataAsc1:=AsciiUp+(Textattr shl 8);
          DataAsc2:=AsciiDown+(TextAttr shl 8);
          While Loopje<x2 do
           begin
            Memw [VideoPageSegment:((y1-1)*160)+(loopje*2)]:=DataAsc1;
            Memw [VideoPageSegment:((y2-1)*160)+(Loopje*2)]:=DataAsc2;
            Inc(loopje);
           end;
          {adjustment}
          Case TestTaip (SmoothEdged) of
           True : begin
                   DataAsc1:=195+(textattr shl 8);
                   DataAsc2:=194+(textattr shl 8);
                  end;
           False : begin
                    DataAsc1:=217+(textattr shl 8);
                    DataAsc2:=192+(textattr shl 8);
                   end;
          end; {case}
          MemW [VideoPageSegment:((y2-1)*160)+(x2-1)*2]:=dataAsc1;
          MemW [VideoPageSegment:((y2-1)*160)+(x1-1)*2]:=dataAsc2;
          {vertical}
          Loopje:=y1;
          DataAsc1:=AsciiLeft+(Textattr shl 8);
          DataAsc2:=AsciiRight+(Textattr shl 8);
          while loopje<y2 do
           begin
            Memw [VideoPageSegment:((loopje-1)*160)+((x1-1)*2)]:=DataAsc1;
            Memw [VideoPageSegment:((loopje-1)*160)+((x2-1)*2)]:=DataAsc2;
            inc(loopje);
           END;
          {adjustment}
          Case TestTaip (SmoothEdged) of
           True : begin
                   DataAsc1:=AsciiUp+(textattr shl 8);
                   DataAsc2:=AsciiUp+(textattr shl 8);
                  end;
           False : begin
                    DataAsc1:=218+(textattr shl 8);
                    DataAsc2:=191+(textattr shl 8);
                   end;
          end; {case}
          MemW [VideoPageSegment:((y1-1)*160)+(x1-1)*2]:=dataAsc1;
          MemW [VideoPageSegment:((y1-1)*160)+(x2-1)*2]:=dataAsc2;
         end;
         Procedure FillBox (x1,y1,x2,y2 : byte);
         Var Loopje,Loopje1 : byte;
             Data           : Integer;
         Begin
          Color (InFor,InBack);
          Loopje:=y1+1;
          Data:=32+(textattr shl 8);
          While Loopje<y2 do
           begin
            loopje1:=x1;
            while loopje1<x2-1 do begin
                                   memw [VideoPageSegment:((loopje-1)*160)+(loopje1*2)]:=Data;
                                   inc(loopje1);
                                  end;
            inc(loopje);
           end;
         end;
         Procedure ShadowBox;
         var adres : integer;
         x,y : byte;
         AgBit : byte; {AchterGrond Bit}
         begin
          {schaduwrand}
          if KleurKnipperend then AGBit:=$07 else AGBit:=$87;
          y:=y2+1;
          for x:=x1+1 to x2+2 do
           begin
            adres:=((y-1)*160+(x-1)*2)+1;
            Mem[VideoPageSegment:Adres]:=mem[VideoPageSegment:Adres] and AGBit;
           end;
          for x:=x2+1 to x2+2 do
           begin
            for y:=y1+1 to y2 do
             begin
              adres:=((y-1)*160+(x-1)*2)+1;
              Mem[VideoPageSegment:Adres]:=mem[VideoPageSegment:Adres] and AGBit;
             end;
           end;
         end; {shadowbox}

Begin
 SetasciiValues;
 if testTaip (zoom)
  then begin
        if ssbuff<>0 then Screen^.Save (x1,y1,x2+2,y2+1,ssbuff);
        xc:=x1+round((x2-x1)/2); yc:=y1+round((y2-y1)/2);
        teller:=1;
        while teller<10 do
         begin
          WriteBox (round(xc+teller*(x1-xc)/10),
                    round(yc+teller*(y1-yc)/10),
                    round(xc+teller*(x1+(X2-x1)-xc)/10),
                    round(yc+teller*(y1+(y2-y1)-yc)/10));
          If TestTaip (Filled) then
             FillBox (round(xc+teller*(x1-xc)/10),
                      round(yc+teller*(y1-yc)/10),
                      round(xc+teller*(x1+(X2-x1)-xc)/10),
                      round(yc+teller*(y1+(y2-y1)-yc)/10));
           delay(20);
          inc(teller);
         end;
        WriteBox (x1,y1,x2,y2);
        If TestTaip (Filled) then FillBox (x1,y1,x2,y2);
       end
  else begin
        If TestTaip (Filled) then FillBox (x1,y1,x2,y2);
        WriteBox (x1,y1,x2,y2);
       end;
 If TestTaip (Shadow) then Shadowbox;
 if testTaip(Smoothedged) then FWrite((x1+round((x2-x1)/2))-round(length(headeR)/2),y1,header,outback,outfor)
                          else FWrite((x1+round((x2-x1)/2))-round(length(headeR)/2),y1,header,outfor,outBack);
end;


BEGIN
TextGraphInit; {Bij een uses, doe dan ALTIJD automatisch TextGraphInit;}
end. {Unit TXTGRAPH  v1.0  (C) 1994 SYNTAX TERROR SOFTWARE INC.}