{$IFDEF VER70}
{$A+,B+,D-,E-,F-,G+,I-,L-,N-,O+,P+,Q-,R-,S-,T-,V-,X+,Y-}
{$ELSE}
{$A+,B+,D-,E-,F-,G+,I-,L-,N-,O+,R-,S-,V-,X+}
{$ENDIF}
{****************************************************************************
 * Author   : Stefan Goehler,Germany (only the extended version)            *
 * Version  : official 1.0                                                  *
 * Task     : Decompress Zipped files                                       *
 * Copyright: Do what u want to do with this, but mention me!               *
 *                                                                          *
 * Converted to Turbo Pascal (tm) V4.0 March, 1988 by J.R.Louvau            *
 * COPYRIGHT (C) 1986 Gary S. Brown.  You may use this program, or          *
 * code or tables extracted from it, as desired without restriction.        *
 ********                                                                   *
 * This unit isn't very fast. That's because most parts are not written in  *
 * asm. I think I'll rewrite the LZW-Part to asm the next time. But since   *
 * LZW is not really used in this time, because the huffmann compression    *
 * returns better results, I don't know if this would be a good idea.       *
 * Further extensions: maybe I write a unit to handle Zipfiles instead this *
 * whole program. Please note that directories in the Zipfiles won't be     *
 * written, so that a dir. already has to exist. I will remove this         *
 * limitation in the next weeks.                                            *
 ********                                                                   *
 * my homepage: http://www.geocities.com/SiliconValley/Bay/9553             *
 * ^^^note that you can get there always the actual version of this unit    *
 * if you have additions, tips or sth. else, mail to stefan.goehler@gmx.de  *
 ********                                                                   *
 * the following files you should get with this Proggy:                     *
 * strprocs.pas : a unit which contains some stringprocedures               *
 * inflate .pas : a unit which inflates huffmann compression                *
 * crc32   .pas : 32 bit crc checking for the huffmann compression          *
 ********                                                                   *
 * History                                                                  *
 * Version 1.0  : first public availible Version (Oct. 10th 1997)           *
 ****************************************************************************}
uses dos,crt,strprocs,inflate,crc32;

{ Stuff needed generically by all uncompression methods }

const
  MAXNAMES = 20;

var
  InFileSpecs :  array[1..MAXNAMES] of string;   { Input file specifications }
  MaxSpecs    :  word;        { Total number of entries in InFileSpecs array }
  OutPath     :  string;      { Output path specification                    }

  TenPercent  :  longInt;

{ Define ZIP file header types }

const
  LOCAL_FILE_HEADER_SIGNATURE = $04034B50;

type
  Local_File_Header_Type = record
                            { Signature              :  LongInt; }
                             Extract_Version_Reqd   :  Word;
                             Bit_Flag               :  Word;
                             Compress_Method        :  Word;
                             Last_Mod_Time          :  Word;
                             Last_Mod_Date          :  Word;
                             Crc32                  :  LongInt;
                             Compressed_Size        :  LongInt;
                             Uncompressed_Size      :  LongInt;
                             Filename_Length        :  Word;
                             Extra_Field_Length     :  Word;
                           end;

const
  CENTRAL_FILE_HEADER_SIGNATURE = $02014B50;

type
  Central_File_Header_Type = record
                              { Signature            :  LongInt; }
                               MadeBy_Version       :  word;
                               Extract_Version_Reqd :  word;
                               Bit_Flag             :  word;
                               Compress_Method      :  word;
                               Last_Mod_Time        :  word;
                               Last_Mod_Date        :  word;
                               Crc32                :  longint;
                               Compressed_Size      :  longint;
                               Uncompressed_Size    :  longint;
                               Filename_Length      :  word;
                               Extra_Field_Length   :  word;
                               File_Comment_Length  :  word;
                               Starting_Disk_Num    :  word;
                               Internal_Attributes  :  word;
                               External_Attributes  :  longint;
                               Local_Header_Offset  :  longint;
                             end;

const
  END_OF_CENTRAL_DIR_SIGNATURE = $06054B50;

type
  End_of_Central_Dir_Type =  record
                               { Signature               :  LongInt; }
                               Disk_Number             :  word;
                               Central_Dir_Start_Disk  :  word;
                               Entries_This_Disk       :  word;
                               Total_Entries           :  word;
                               Central_Dir_Size        :  longint;
                               Start_Disk_Offset       :  longint;
                               ZipFile_Comment_Length  :  word;
                             end;

const
   CRC_32_TAB : array[0..255] of longint = (
$00000000, $77073096, $ee0e612c, $990951ba, $076dc419, $706af48f, $e963a535, $9e6495a3,
$0edb8832, $79dcb8a4, $e0d5e91e, $97d2d988, $09b64c2b, $7eb17cbd, $e7b82d07, $90bf1d91,
$1db71064, $6ab020f2, $f3b97148, $84be41de, $1adad47d, $6ddde4eb, $f4d4b551, $83d385c7,
$136c9856, $646ba8c0, $fd62f97a, $8a65c9ec, $14015c4f, $63066cd9, $fa0f3d63, $8d080df5,
$3b6e20c8, $4c69105e, $d56041e4, $a2677172, $3c03e4d1, $4b04d447, $d20d85fd, $a50ab56b,
$35b5a8fa, $42b2986c, $dbbbc9d6, $acbcf940, $32d86ce3, $45df5c75, $dcd60dcf, $abd13d59,
$26d930ac, $51de003a, $c8d75180, $bfd06116, $21b4f4b5, $56b3c423, $cfba9599, $b8bda50f,
$2802b89e, $5f058808, $c60cd9b2, $b10be924, $2f6f7c87, $58684c11, $c1611dab, $b6662d3d,
$76dc4190, $01db7106, $98d220bc, $efd5102a, $71b18589, $06b6b51f, $9fbfe4a5, $e8b8d433,
$7807c9a2, $0f00f934, $9609a88e, $e10e9818, $7f6a0dbb, $086d3d2d, $91646c97, $e6635c01,
$6b6b51f4, $1c6c6162, $856530d8, $f262004e, $6c0695ed, $1b01a57b, $8208f4c1, $f50fc457,
$65b0d9c6, $12b7e950, $8bbeb8ea, $fcb9887c, $62dd1ddf, $15da2d49, $8cd37cf3, $fbd44c65,
$4db26158, $3ab551ce, $a3bc0074, $d4bb30e2, $4adfa541, $3dd895d7, $a4d1c46d, $d3d6f4fb,
$4369e96a, $346ed9fc, $ad678846, $da60b8d0, $44042d73, $33031de5, $aa0a4c5f, $dd0d7cc9,
$5005713c, $270241aa, $be0b1010, $c90c2086, $5768b525, $206f85b3, $b966d409, $ce61e49f,
$5edef90e, $29d9c998, $b0d09822, $c7d7a8b4, $59b33d17, $2eb40d81, $b7bd5c3b, $c0ba6cad,
$edb88320, $9abfb3b6, $03b6e20c, $74b1d29a, $ead54739, $9dd277af, $04db2615, $73dc1683,
$e3630b12, $94643b84, $0d6d6a3e, $7a6a5aa8, $e40ecf0b, $9309ff9d, $0a00ae27, $7d079eb1,
$f00f9344, $8708a3d2, $1e01f268, $6906c2fe, $f762575d, $806567cb, $196c3671, $6e6b06e7,
$fed41b76, $89d32be0, $10da7a5a, $67dd4acc, $f9b9df6f, $8ebeeff9, $17b7be43, $60b08ed5,
$d6d6a3e8, $a1d1937e, $38d8c2c4, $4fdff252, $d1bb67f1, $a6bc5767, $3fb506dd, $48b2364b,
$d80d2bda, $af0a1b4c, $36034af6, $41047a60, $df60efc3, $a867df55, $316e8eef, $4669be79,
$cb61b38c, $bc66831a, $256fd2a0, $5268e236, $cc0c7795, $bb0b4703, $220216b9, $5505262f,
$c5ba3bbe, $b2bd0b28, $2bb45a92, $5cb36a04, $c2d7ffa7, $b5d0cf31, $2cd99e8b, $5bdeae1d,
$9b64c2b0, $ec63f226, $756aa39c, $026d930a, $9c0906a9, $eb0e363f, $72076785, $05005713,
$95bf4a82, $e2b87a14, $7bb12bae, $0cb61b38, $92d28e9b, $e5d5be0d, $7cdcefb7, $0bdbdf21,
$86d3d2d4, $f1d4e242, $68ddb3f8, $1fda836e, $81be16cd, $f6b9265b, $6fb077e1, $18b74777,
$88085ae6, $ff0f6a70, $66063bca, $11010b5c, $8f659eff, $f862ae69, $616bffd3, $166ccf45,
$a00ae278, $d70dd2ee, $4e048354, $3903b3c2, $a7672661, $d06016f7, $4969474d, $3e6e77db,
$aed16a4a, $d9d65adc, $40df0b66, $37d83bf0, $a9bcae53, $debb9ec5, $47b2cf7f, $30b5ffe9,
$bdbdf21c, $cabac28a, $53b39330, $24b4a3a6, $bad03605, $cdd70693, $54de5729, $23d967bf,
$b3667a2e, $c4614ab8, $5d681b02, $2a6f2b94, $b40bbe37, $c30c8ea1, $5a05df1b, $2d02ef8d
);

const
  BUFSIZE       = 32768;           { Size of buffers for I/O }

type
  BufPtr        = ^BufType;
  BufType       = array[1..BUFSIZE] of byte;

var
  ZipName       :  string;         { Name of Zip file to be processed       }
  ZipFile       :  file;           { Zip file variable                      }
  EndFile       :  boolean;        { End of file indicator for ZipFile      }
  ZipBuf        :  BufPtr;         { Input buffer for ZipFile               }
  ZipPtr        :  word;           { Index for ZipFile input buffer         }
  ZipCount      :  word;           { Count of bytes in ZipFile input buffer }

  ExtFile       :  file;           { Output file variable                   }
  ExtBuf        :  BufPtr;         { Output buffer for ExtFile              }
  ExtPtr        :  word;           { Index for ExtFile output buffer        }
  ExtCount      :  longint;        { Count of characters written to output  }

  LocalHdr       : Local_File_Header_Type;  { Storage for a local file hdr  }
  Hdr_FileName   : string;
  Hdr_ExtraField : string;
  Hdr_Comment    : string;

  Crc32Val       : longint;        { Running CRC (32 bit) value             }
  Bytes_To_Go    : longint;        { Bytes left to process in compressed file}
  x,y            : byte;


{ Stuff needed for unSHRINKing }

const
  MINCODESIZE    =    9;
  MAXCODESIZE    =   13;
  SPECIAL        =  256;
  FIRSTFREE      =  257;
  LZW_TABLE_SIZE =  (1 shl MAXCODESIZE) - 1;      { 0..8191 }
  LZW_STACK_SIZE =  (1 shl MAXCODESIZE) - 1;      { 0..8191 }

type
  LZW_Table_Rec  =  record
                      Prefix      :  integer;
                      Suffix      :  byte;
                      ChildCount  :  word;  { If ChildCount = 0 then leaf node }
                    end;
  LZW_Table_Ptr  =  ^LZW_Table_Type;
  LZW_Table_Type =  array[0..LZW_TABLE_SIZE] of LZW_Table_Rec;

  FreeListPtr    =  ^FreeListArray;
  FreeListArray  =  array[FIRSTFREE..LZW_TABLE_SIZE] of Word;

  StackPtr       =  ^StackType;
  StackType      =  array[0..LZW_STACK_SIZE] of word;

var
  LZW_Table   :  LZW_Table_Ptr; { Code table for LZW decoding               }
  FreeList    :  FreeListPtr;   { List of free table entries                }
  NextFree    :  word;          { Index for free list array                 }
                                {   FreeList^[NextFree] always contains the }
                                {   index of the next available entry in    }
                                {   the LZW Prefix:Suffix table (LZW_Table^)}
  LZW_Stack   :  StackPtr;      { A stack used to build decoded strings     }
  StackIdx    :  word;          { Stack array index variable                }
                                {   StackIdx always points to the next      }
                                {   available entry in the stack            }
  SaveByte    :  byte;          { Our input code buffer - 1 byte long       }
  BitsLeft    :  byte;          { Unprocessed bits in the input code buffer }
  FirstCh     :  boolean;       { Flag indicating first char being processed}


{ Stuff needed for unREDUCEing }

type
  FollowerSet    =  record
                      SetSize  :  word;
                      FSet     :  array[0..31] of byte;
                    end;
  FollowerPtr    =  ^FollowerArray;
  FollowerArray  =  array[0..255] of FollowerSet;

  StreamPtr      =  ^StreamArray;
  StreamArray    =  array[0..4095] of byte;

var
  Followers   :  FollowerPtr;
  Stream      :  StreamPtr;     { The output stream                        }
  StreamIdx   :  word;          { Always points to next pos. to be filled  }
  State       :  byte;
  Len         :  word;
  V           :  byte;


procedure abort(Msg : string);
begin
 writeln(' ');
 writeln(Msg);
 writeln('Returning to DOS');
 writeln;
 halt;
end {Abort};


procedure syntax;
begin
 writeln('usage:  unzip [ZIPFile] [OutPath] [Files]');
 writeln;
 writeln('Optional files may contain DOS wildcard characters.');
 writeln;
 writeln('If no files are entered, *.* is assumed.');
 writeln;
 halt;
end;


function HexLInt(L : LongInt) : string;
const
  HexChar : array[0..15] of char = ('0','1','2','3','4','5','6','7',
                                    '8','9','A','B','C','D','E','F');
begin
 HexLInt  := HexChar[(L and $F0000000) shr 28] +
             HexChar[(L and $0F000000) shr 24] +
             HexChar[(L and $00F00000) shr 20] +
             HexChar[(L and $000F0000) shr 16] +
             HexChar[(L and $0000F000) shr 12] +
             HexChar[(L and $00000F00) shr  8] +
             HexChar[(L and $000000F0) shr  4] +
             HexChar[(L and $0000000F)       ] +
             'h';
end {HexLInt};


function IO_Test : boolean;
var
  ErrorCode   :  word;
  CodeStr     :  string;
  Ok          :  boolean;
begin
 Ok := TRUE;
 ErrorCode := IOResult;
 if ErrorCode <> 0 then begin
   Ok := FALSE;
   case ErrorCode of
     2   : writeln('File Not Found');
     3   : writeln('Path Not Found');
     5   : writeln('Access Denied');
     101 : writeln('Disk Full');
     else  writeln('I/O Error # ', ErrorCode);
  end {Case};
 end {if};
 IO_Test := Ok;
end {IO_Test};


procedure Load_Parms;
var
  I      : word;
  Name   : string;
  DosDTA : searchrec;
begin
 if ParamCount = 0 then syntax;

 ZipName := ParamStr(1);
 for I := 1 to Length(ZipName) do ZipName[I] := UpCase(ZipName[I]);
 if pos('.', ZipName) = 0 then ZipName := ZipName + '.ZIP';

 MaxSpecs := 0;
 OutPath := '';
 I := 1;
 while I < ParamCount do begin
   inc(I);
   Name := ParamStr(I);
   if Name[length(Name)] = '\' then delete(Name,length(Name),1);
   FindFirst(Name,DIRECTORY,DosDTA);     { outpath spec? }
   if DosError = 0 then begin
     if (DosDTA.Attr and DIRECTORY) <> 0 then begin   { yup }
       OutPath := Name;
       if OutPath[Length(OutPath)] <> '\' then OutPath := OutPath + '\';
     end {then}
     else begin
       if MaxSpecs < MAXNAMES then begin
         inc(MaxSpecs);
         InFileSpecs[MaxSpecs] := Name;
       end {if};
     end {if};
   end {then}
   else begin
     if MaxSpecs < MAXNAMES then begin
       inc(MaxSpecs);
       InFileSpecs[MaxSpecs] := Name;
     end {if};
   end {if}
 end {while};

 if MaxSpecs = 0 then begin
   MaxSpecs := 1;
   InFileSpecs[1] := '*.*';
  end {if};
end {Load_Parms};


procedure Initialize;
begin
 getmem(ZipBuf, SizeOf(ZipBuf^));
 getmem(ExtBuf, SizeOf(ExtBuf^));
 if (zipbuf = nil) or (extbuf = nil) then
   abort('Not enough memory');
end {Initialize};


 { Converted to Turbo Pascal (tm) V4.0 March, 1988 by J.R.Louvau            }
 { Extended for huffmann decompression in October, 1997 by Stefan Goehler   }
 { stefan.goehler@gmx.de                                                    }
 { ...                                                                      }
 { COPYRIGHT (C) 1986 Gary S. Brown.  You may use this program, or          }
 { code or tables extracted from it, as desired without restriction.        }
 {                                                                          }
 { First, the polynomial itself and its table of feedback terms.  The       }
 { polynomial is                                                            }
 { X^32+X^26+X^23+X^22+X^16+X^12+X^11+X^10+X^8+X^7+X^5+X^4+X^2+X^1+X^0      }
 {                                                                          }
 { Note that we take it "backwards" and put the highest-order term in       }
 { the lowest-order bit.  The X^32 term is "implied"; the LSB is the        }
 { X^31 term, etc.  The X^0 term (usually shown as "+1") results in         }
 { the MSB being 1.                                                         }
 {                                                                          }
 { Note that the usual hardware shift register implementation, which        }
 { is what we're using (we're merely optimizing it by doing eight-bit       }
 { chunks at a time) shifts bits into the lowest-order term.  In our        }
 { implementation, that means shifting towards the right.  Why do we        }
 { do it this way?  Because the calculated CRC must be transmitted in       }
 { order from highest-order term to lowest-order term.  UARTs transmit      }
 { characters in order from LSB to MSB.  By storing the CRC this way,       }
 { we hand it to the UART in the order low-byte to high-byte; the UART      }
 { sends each low-bit to hight-bit; and the result is transmission bit      }
 { by bit from highest- to lowest-order term without requiring any bit      }
 { shuffling on our part.  Reception works similarly.                       }
 {                                                                          }
 { The feedback terms table consists of 256, 32-bit entries.  Notes:        }
 {                                                                          }
 {     The table can be generated at runtime if desired; code to do so      }
 {     is shown later.  It might not be obvious, but the feedback           }
 {     terms simply represent the results of eight shift/xor opera-         }
 {     tions for all combinations of data and CRC register values.          }
 {                                                                          }
 {     The values must be right-shifted by eight bits by the "updcrc"       }
 {     logic; the shift must be unsigned (bring in zeroes).  On some        }
 {     hardware you could probably optimize the shift in assembler by       }
 {     using byte-swap instructions.                                        }
 {     polynomial $edb88320                                                 }

procedure Read_Zip_Block;
begin
 blockread(ZipFile,ZipBuf^,BUFSIZE,ZipCount);
 If ZipCount = 0 then
   EndFile := true;
 ZipPtr := 1;
end {Read_Zip_Block};


procedure Write_Ext_Block;
begin
 if ExtPtr > 1 then begin
   blockwrite(ExtFile,ExtBuf^,Pred(ExtPtr));
   if not IO_Test then halt;
   ExtPtr := 1;
 end {if};
end {Write_Ext_Block};


procedure Open_Zip;
begin
 assign(ZipFile,ZipName);
 FileMode := 64;  { Read Only / Deny None }
 {$I-}reset(ZipFile,1);{$I+}
 if not IO_Test then halt;
 EndFile := false;
 Read_Zip_Block;
end {Open_Zip};


function Open_Ext : boolean;
begin
 assign(ExtFile, OutPath + Hdr_FileName);
 FileMode := 66;  { Read & Write / Deny None }
 {$I-}Rewrite(ExtFile,1);{$I+}
 if not IO_Test then Open_Ext := false
 else begin
   ExtPtr := 1;
   Open_Ext := true;
 end {if};
end {Open_Ext};


function Get_Zip : Integer;
begin
 if ZipPtr > ZipCount then Read_Zip_Block;

 if EndFile then Get_Zip := -1
 else begin
   Get_Zip := ZipBuf^[ZipPtr];
   inc(ZipPtr);
 end {if};
end {Get_Zip};


procedure Put_Ext(C : Byte);
begin
 UpdateCRC32(CRC32val,c,1);
 ExtBuf^[ExtPtr] := C;
 inc(ExtPtr);
 inc(ExtCount);
 If ExtPtr > BUFSIZE then Write_Ext_Block;
end {Put_Ext};


procedure Close_Zip;
begin
 {$I-}Close(Zipfile);{$I+}
 IO_Test;
end {Close_Zip};


procedure Close_Ext;
type
  TimeDateRec = record
    Time : word;
    Date : word;
  end {record};
var
  TimeDate      : TimeDateRec;
  TimeDateStamp : longInt Absolute TimeDate;
begin
 Write_Ext_Block;
 TimeDate.Time := LocalHdr.Last_Mod_Time;
 TimeDate.Date := LocalHdr.Last_Mod_Date;
 SetFTime(ExtFile,TimeDateStamp);
 {$I-}close(ExtFile);{$I+}
 IO_Test;
 gotoxy(1,wherey);
 write(ExtCount);
 gotoxy(1,wherey);
end {Close_Ext};


procedure FSkip(Offset : longInt);
var
 Rec : longInt;
begin
 if (Offset + ZipPtr) <= ZipCount then inc(ZipPtr, Offset)
 else begin
   Rec := FilePos(ZipFile) + (Offset - (ZipCount - ZipPtr) - 1);
   {$I-}Seek(ZipFile, Rec);{$I+}
   if not IO_Test then halt;
   Read_Zip_Block;
 end {if};
end {FSkip};


procedure FRead(var Buf; RecLen : word);
var
 I  :  word;
 B  :  array[1..MaxInt] of byte absolute Buf;
begin
 for I := 1 to RecLen do B[I] := Get_Zip;
end {FRead};


function Read_Local_Hdr : boolean;
var
  Sig : longInt;
begin
 if EndFile then Read_Local_Hdr := false
 else begin
   FRead(Sig, SizeOf(Sig));
   if Sig = CENTRAL_FILE_HEADER_SIGNATURE then begin
     Read_Local_Hdr := false;
     EndFile        := true;
   end {then}
   else begin
     if Sig <> LOCAL_FILE_HEADER_SIGNATURE then
       abort('Missing or invalid local file header in ' + ZipName);
     fread(LocalHdr, SizeOf(LocalHdr));
     with LocalHdr do begin
     if FileName_Length > 255 then
       abort('Filename of compressed file exceeds 255 characters!');
       fread(Hdr_FileName[1], FileName_Length);
       Hdr_FileName[0] := Chr(FileName_Length);
       if Extra_Field_Length > 255 then
         abort('Extra field of compressed file exceeds 255 characters!');
       fread(Hdr_ExtraField[1], Extra_Field_Length);
       Hdr_ExtraField[0] := Chr(Extra_Field_Length);
     end {with};
     Read_Local_Hdr := true;
   end {if};
 end {if};
end {Read_Local_Hdr};


function Get_Compressed : integer;
var
  PctDone,i : integer;

begin
 if Bytes_To_Go = 0 then
   Get_Compressed := -1
 else begin
   Get_Compressed := Get_Zip;
   if Bytes_To_Go mod TenPercent = 0 then begin
{     PctDone := 100 - Round( 100 * (Bytes_To_Go / LocalHdr.Compressed_Size));
     gotoxy(WhereX - 4, WhereY);
     write(PctDone:3, '%');
   end; {if}
 gotoxy(x,y);
 for i := 1 to 10-Bytes_To_Go*10 div LocalHdr.Compressed_Size do write('');
 for i := 1 to Bytes_To_Go*10 div LocalHdr.Compressed_Size do write('');
end;
   Dec(Bytes_To_Go);
 end {if};
end {Get_Compressed};


function LZW_Init : boolean;
var
  I : word;
begin
 new(LZW_Table);
 If lzw_table = nil then begin
   LZW_Init := false;
   exit;
 end;
 for I := 0 to LZW_TABLE_SIZE do begin
   with LZW_Table^[I] do begin
     Prefix     := -1;
     if I < 256 then Suffix := i else Suffix  := 0;
     ChildCount := 0;
   end {with};
 end {for};

 getmem(FreeList, SizeOf(FreeList^));
 if FreeList = nil then begin
   LZW_Init := FALSE;
   exit;
 end;
 for I := FIRSTFREE to LZW_TABLE_SIZE do FreeList^[I] := I;
 NextFree := FIRSTFREE;

 { Initialize the LZW Character Stack }
 new(LZW_Stack);
 if lzw_stack = nil then begin
   LZW_Init := false;
   exit;
 end;
 StackIdx := 0;
 LZW_Init := true;
end {LZW_Init};


procedure LZW_Cleanup;
begin
 freemem(LZW_Table,sizeof(LZW_Table^));
 freemem(FreeList,sizeof(FreeList^));
 freemem(LZW_Stack,sizeof(LZW_Stack^));
end {LZW_Cleanup};


procedure Clear_LZW_Table;
var
 i :  word;
begin
 StackIdx := 0;
 for i := FIRSTFREE to LZW_TABLE_SIZE do begin      { Find all leaf nodes }
   if LZW_Table^[I].ChildCount = 0 then begin
     LZW_Stack^[StackIdx] := i;                     { and put each on stack }
     inc(StackIdx);
   end {if};
 end {for};

 NextFree := succ(LZW_TABLE_SIZE);

 while StackIdx > 0 do begin                        { clear all leaf nodes }
   dec(StackIdx);
   i := LZW_Stack^[StackIdx];
   with LZW_Table^[I] do begin
     if LZW_Table^[I].Prefix <> -1 then dec(LZW_Table^[Prefix].ChildCount);
     Prefix     := -1;
     Suffix     :=  0;
     ChildCount :=  0;
   end {with};
   Dec(NextFree);                         { add cleared nodes to freelist }
   FreeList^[NextFree] := I;
 end {while};
end {Clear_LZW_Table};


procedure Add_To_LZW_Table(Prefix : integer; Suffix : byte);
var
  i : word;
begin
 if NextFree <= LZW_TABLE_SIZE then begin
   i := FreeList^[NextFree];
   inc(NextFree);
   LZW_Table^[I].Prefix     := Prefix;
   LZW_Table^[I].Suffix     := Suffix;
   inc(LZW_Table^[Prefix].ChildCount);
 end {if};
end {Add_To_LZW_Table};


function Get_Code(CodeSize : Byte) : Integer;
const
  Mask   : array[1..8] of byte = ($01, $03, $07, $0F, $1F, $3F, $7F, $FF);
  TmpInt : integer = 0;
var
  BitsNeeded : byte;
  HowMany    : byte;
  HoldCode   : integer;
label
  exit;
begin
 if FirstCh then begin               { If first time through ...         }
   TmpInt := Get_Compressed;         { ... then prime the code buffer    }
   if TmpInt = -1 then begin         { If EOF on fill attempt ...        }
     Get_Code := -1;                 { ... then return EOF indicator ... }
     goto exit;                      { ... and return to caller.         }
   end {if};
   SaveByte := TmpInt;
   BitsLeft := 8;                    { there's now 8 bits in our buffer  }
   FirstCh  := false;
 end {if};

 BitsNeeded := CodeSize;
 HoldCode   := 0;
 while (BitsNeeded > 0) and (TmpInt <> -1) do begin
   if BitsNeeded >= BitsLeft
     then HowMany := BitsLeft         { HowMany <-- Min(BitsLeft, BitsNeeded) }
     else HowMany := BitsNeeded;

   HoldCode := HoldCode or ((SaveByte and Mask[HowMany]) shl (CodeSize - BitsNeeded));
   SaveByte := SaveByte shr HowMany;
   Dec(BitsNeeded, HowMany);
   Dec(BitsLeft, HowMany);

   if BitsLeft <= 0 then begin         { If no bits left in buffer ...     }
     TmpInt := Get_Compressed;         { ... then attempt to get 8 more.   }
     if TmpInt = -1 then goto exit;
     SaveByte := TmpInt;
     BitsLeft := 8;
   end {if};
 end {while};

exit:
   if (BitsNeeded = 0) then           { If we got what we came for ... }
      Get_Code := HoldCode            { ... then return it             }
   else
      Get_Code := -1;                 { ... Otherwise, return EOF      }
end {Get_Code};


procedure UnShrink;
var
  CodeSize :  byte;          { Current size (in bits) of codes coming in  }
  CurrCode :  integer;
  SaveCode :  integer;
  PrevCode :  integer;
  BaseChar :  byte;
begin
 CodeSize := MINCODESIZE;               { Start with the smallest code size }

 PrevCode := Get_Code(CodeSize);        { Get first code from file          }
 if PrevCode = -1 then                  { If EOF already, then ...          }
   exit;                                { ... just exit without further ado }
 BaseChar := PrevCode;
 Put_Ext(BaseChar);                     { Unpack the first character        }

 CurrCode := Get_Code(CodeSize);        { Get next code to prime the while loop }

 while CurrCode <> -1 do begin          { Repeat for all compressed bytes   }
   if CurrCode = SPECIAL then begin     { If we've got a "special" code ... }
     CurrCode := Get_Code(CodeSize);
     case CurrCode of
       1 :                              { ... and if followed by a 1 ...    }
              inc(CodeSize);            { ... then increase code size       }
       2 :                              { ... and if followed by a 2 ...    }
              Clear_LZW_Table;          { ... clear leaf nodes in the table }
       else begin                       { ... if neither 1 or 2, discard    }
         writeln;
         writeln('Encountered code 256 not followed by 1 or 2!');
         writeln;
         write('Press a key to continue ...');
         readkey;
         delline;
         gotoxy(1,WhereY);
       end {else};
     end {case};

   end {then}
   else begin                          { Not a "special" code              }
     SaveCode := CurrCode;             { Save this code someplace safe...  }
     if CurrCode > LZW_TABLE_SIZE then abort('Invalid code encountered!');

     if (CurrCode >= FIRSTFREE) and (LZW_Table^[CurrCode].Prefix = -1) then begin
       if StackIdx > LZW_STACK_SIZE then begin
         Write_Ext_Block;
         writeln;
         writeln('Stack Overflow (', StackIdx, ')!');
         halt;
       end {if};
       LZW_Stack^[StackIdx] := BaseChar;
       inc(StackIdx);
       CurrCode := PrevCode;
     end {if};
     while CurrCode >= FIRSTFREE do begin
       if StackIdx > LZW_STACK_SIZE then begin
         Write_Ext_Block;
         writeln;
         writeln('Stack Overflow (', StackIdx, ')!');
         halt;
       end {if};
         LZW_Stack^[StackIdx] := LZW_Table^[CurrCode].Suffix;
         inc(StackIdx);
         CurrCode := LZW_Table^[CurrCode].Prefix;
     end {while};

     BaseChar := LZW_Table^[CurrCode].Suffix; { Get last character ...   }
     Put_Ext(BaseChar);

     while (StackIdx > 0) do begin
       dec(StackIdx);
       Put_Ext(LZW_Stack^[StackIdx]);
     end {while};                             { ... until there are none left     }

     Add_to_LZW_Table(PrevCode, BaseChar);    { Add new entry to table      }
     PrevCode := SaveCode;
   end {if};
   CurrCode := Get_Code(CodeSize);            { Get next code from input stream   }
 end {while};
end {UnShrink};


function Init_UnReduce : Boolean;
begin
 getmem(Followers, SizeOf(Followers^));
 getmem(Stream, SizeOf(Stream^));
 if (followers = nil) or (stream = nil) then Init_UnReduce := false else
 Init_UnReduce := true;
end {Init_UnReduce};


procedure Cleanup_UnReduce;
begin
 freemem(Followers,sizeof(followers^));
 freemem(Stream,sizeof(stream^));
end {Cleanup_UnReduce};


function D(X, Y : byte) : word;
var
  tmp : longint;
begin
 X := X shr (8 - pred(LocalHdr.Compress_Method));
 Tmp := X * 256;
 D := Tmp + Y + 1;
end {D};


function F(X : word) : Byte;
const
  TestVal : array[1..4] of byte = (127, 63, 31, 15);
begin
 if X = TestVal[Pred(LocalHdr.Compress_Method)] then F := 2 else F := 3;
end {F};


function L(X : byte) : byte;
const
  Mask : array[1..4] of byte = ($7F, $3F, $1F, $0F);
Begin
 L := X and Mask[Pred(LocalHdr.Compress_Method)];
end {L};


procedure StreamOut(C : byte);
begin
 Put_Ext(C);
 Stream^[StreamIdx] := C;
{ StreamIdx := Succ(StreamIdx) MOD 4096;}
 StreamIdx := succ(StreamIdx) and 4095;
end {StreamOut};


procedure ScrnchInit;
begin
 State := 0;
 fillchar(stream^,4096,0);
 StreamIdx := 0;
end {ScrnchInit};


procedure UnScrnch(C : byte);
const
  DLE   =  $90;
var
  S           :  integer;
  Count       :  word;
  OneByte     :  byte;
  Tmp1        :  longint;
begin
 Case State of
   0 : if C = DLE then State := 1 else StreamOut(C);
   1 : begin
         if C = 0 then begin
           StreamOut(DLE);
           State := 0;
         end {then}
         else begin
           V     := C;
           Len   := L(V);
           State := F(Len);
         end {if};
       end {1};
   2 : begin
         inc(Len, C);
         State := 3;
       end {2};
   3 : begin
         Tmp1 := D(V, C);
         S    := StreamIdx - Tmp1;
         if S < 0 then S := S + 4096;
         Count := Len + 3;
         while Count > 0 do begin
           OneByte := Stream^[S];
           StreamOut(OneByte);
          { S := Succ(S) MOD 4096;}
           S := Succ(S) and 4095;
           dec(Count);
         end {while};
         State := 0;
       end {3};
 end {case};
end {UnScrnch};


function MinBits(Val : byte) : byte;
begin
   Dec(Val);
   case Val of
       0..1  : MinBits := 1;
       2..3  : MinBits := 2;
       4..7  : MinBits := 3;
       8..15 : MinBits := 4;
      16..31 : MinBits := 5;
      else     MinBits := 6;
   end {case};
end {MinBits};


procedure UnReduce;
var
  LastChar    :  byte;
  N           :  byte;
  I, J        :  word;
  Code        :  integer;
  Ch          :  char;
begin
 for I := 255 downto 0 do begin          { Load follower sets }
   N := Get_Code(6);                     { Get size of 1st set }
   Followers^[I].SetSize := N;
   If N > 0 then for J := 0 to Pred(N) do
                 Followers^[I].FSet[J] := Get_Code(8);
 end {for};
 ScrnchInit;

 LastChar := 0;
 repeat
   if Followers^[LastChar].SetSize = 0 then begin
     Code := Get_Code(8);
     UnScrnch(Code);
     LastChar := Code;
   end {then}
   else begin
     Code := Get_Code(1);
     if Code <> 0 then begin
       Code := Get_Code(8);
       UnScrnch(Code);
       LastChar := Code;
     end {then}
     else begin
       I := MinBits(Followers^[LastChar].SetSize);
       Code := Get_Code(I);
       UnScrnch(Followers^[LastChar].FSet[Code]);
       LastChar := Followers^[LastChar].FSet[Code];
     end {if};
   end {if};
 until (ExtCount = LocalHdr.Uncompressed_Size);
 freemem(followers,sizeof(followers^));
end {UnReduce};

var
  DecompBytes   : longint;{counts decompressed bytes}

function readbyte : byte;far;
begin
 if ZipPtr > ZipCount then Read_Zip_Block;
 if endfile then begin
   writeln('Fatal error: unexpected end of file');
   halt(20);
 end;
 ReadByte := ZipBuf^[ZipPtr];
 inc(ZipPtr);
end;

function flush(w : word) : integer;far;
var
  i : integer;
begin
 Flush  := 0;
 inc(DecompBytes,w);
{ UpdateAdler32(RunAdl,slide^,w);} {not needed}
 blockwrite(extfile,slide^,w);
 UpdateCRC32(CRC32val,slide^,w);
 gotoxy(x,y);
 if decompbytes > localhdr.uncompressed_size then
   abort('Error in Zipfile');
 for i := 1 to decompbytes*10 div LocalHdr.unCompressed_Size do write('');
 for i := 1 to 10-decompbytes*10 div LocalHdr.unCompressed_Size do write('');
end {PNG_Flush};

function MyHeapError(Size: word) : integer;far;
begin
 if Size = 0 Then
 MyHeapError := 2 {success}
 else
 MyHeapError := 1 {return NIL}
end {MyHeapErrorFunc};

function huffmann_run : byte;
begin
 getmem(slide,wsize);
 InitCRC32(crc32val);
 DecompBytes  := 0;
 InflateRead  := ReadByte;
 InflateFlush := Flush;
 huffmann_run := InflateRun;
 freemem(slide,wsize);
end;


procedure UnZip;
var
  C  :  integer;
begin
 Crc32Val    := $FFFFFFFF;
 Bytes_To_Go := LocalHdr.Compressed_Size;
 FirstCh     := true;

 ExtCount    := 0;

 TenPercent := LocalHdr.Compressed_Size DIV 10;

 Case LocalHdr.Compress_Method of
   0  : while Bytes_to_go > 0 do Put_Ext(Get_Compressed);
   1  : begin
          if LZW_Init then UnShrink
          else begin
            writeln('Not enough memory available to unshrink!');
            writeln('Skipping ', Hdr_FileName, ' ...');
            FSkip(LocalHdr.Compressed_Size);
            Crc32Val := NOT LocalHdr.Crc32;
          end {if};
          LZW_Cleanup;
        end {1 = shrunk};
2..5  : begin
          if Init_UnReduce then UnReduce
          else begin
            writeln('Not enough memory available to unreduce!');
            writeln('Skipping ', Hdr_FileName, ' ...');
            FSkip(LocalHdr.Compressed_Size);
            Crc32Val := NOT LocalHdr.Crc32;
          end {if};
          Cleanup_UnReduce;
        end {2..5};
    8 : begin
          if huffmann_run <> 0 then begin
            writeln;
            writeln('An error occured while decompressing ', Hdr_FileName, ' ...');
          end;
        end {8 = Huffmann};
   else begin
          writeln('Unknown compression method (',LocalHdr.Compress_Method,') used on ', Hdr_FileName);
          write('Skipping ', Hdr_FileName, ' ...');
          FSkip(LocalHdr.Compressed_Size);
          Crc32Val := NOT LocalHdr.Crc32;
        end {else};
 end {case};
 Crc32Val := NOT Crc32Val;
 if Crc32Val <> LocalHdr.Crc32 then begin
   writeln;
   writeln('WARNING: File ', OutPath + Hdr_FileName, ' fails CRC check!');
   writeln('   Stored CRC = ', HexLInt(LocalHdr.Crc32),
           '   Calculated CRC = ', HexLInt(Crc32Val));
 end {if};
end {UnZip};


procedure Extract_File;
var
  YesNo  : char;
  DosDTA : searchrec;
begin
 FindFirst(OutPath + Hdr_FileName, ANYFILE, DosDTA);
 if DosError = 0 then begin
   write('WARNING: ', OutPath + Hdr_FileName, ' already exists.  Overwrite (Y/N)? ');
   YesNo := ReadKey;
   writeln(YesNo);
   if UpCase(YesNo) <> 'Y' then begin
     FSkip(LocalHdr.Compressed_Size);
     exit;
   end {if};
 end {if};

 if Open_Ext then begin
   write('Extracting: ', OutPath + Hdr_FileName, ' ...    ');
   x := wherex;
   y := wherey;
   UnZip;
   gotoxy(X,Y);
   ClrEol;
   writeln(' done');
   Close_Ext;
 end {then}
 else begin
   writeln('Could not open output file ', OutPath + Hdr_FileName, '!  Skipping to next file ...');
   FSkip(LocalHdr.Compressed_Size);
 end {If};
end {Extract_File};


procedure Extract_Zip;
var
  Match : boolean;
  I     : word;
begin
 Open_Zip;
 while Read_Local_Hdr do begin
   Match := FALSE;
   I := 1;
   repeat
     if SameFile(InFileSpecs[I], Hdr_FileName) then Match := true;
     inc(I);
   until Match or (I > MaxSpecs);
   if Match then Extract_File else FSkip(LocalHdr.Compressed_Size);
 end {while};
 Close_Zip;
 gotoxy(1, WhereY);
 ClrEOL;
end;


var
  oldheaperror : pointer;
Begin
 oldheaperror := heaperror;
 heaperror := @myheaperror;
 assign(Output,'');
 rewrite(Output);
 writeln;
 writeln('UNZip Ver. 1.0');
 writeln;
 Load_Parms;   { get command line parameters }
 Initialize;   { one-time initialization     }
 Extract_Zip;  { decompress the file         }
 heaperror := oldheaperror;
end.
