{2/98:  slowed down using Clocks to make drawing dynamic}

{$N+,E+}
PROGRAM Spheres;

  USES
    Clocks,
    DOS,
    Drivers,
    ErrorHandler,
    GraphFix,
    GRAPH,
    MathLibrary,
    Primitives;

  CONST
    MinimumWindow = 1;
    MaximumWindow = 9;
    WaitPeriod    = 0.50;   {seconds}

  VAR
    a             :  matrix;
    clkDOS        :  Clock;
    ErrorCode     :  INTEGER;
    GraphicsDriver:  INTEGER;
    GraphicsMode  :  INTEGER;
    w             :  WORD;
    windows       :  ARRAY[1..9] OF GraphicsWindow;

  PROCEDURE L (x,y,z:  DOUBLE);
    VAR  w:  WORD;
  BEGIN
    FOR w := MinimumWindow TO MaximumWindow DO BEGIN
      windows[w].SetCurrent;
      windows[w].LineTo3D (x,y,z)
    END
  END {L};

  PROCEDURE M (x,y,z:  DOUBLE);
    VAR  w:  WORD;
  BEGIN
    clkDOS.Start(DOSClock);
    FOR w := MinimumWindow TO MaximumWindow DO
      windows[w].MoveTo3D (x,y,z);

    {slow down on most machines to make drawing dynamic}
    REPEAT UNTIL clkDOS.Elapsed > 0.10
  END {M};

  PROCEDURE Cube;
    VAR  w:  WORD;
  BEGIN
    SetColor (4);
    FOR w := MinimumWindow TO MaximumWindow DO BEGIN
      windows[w].SetCoordType (cartesian);
    END;

    M ( 1, 1, 1);
    L (-1, 1, 1);
    L (-1,-1, 1);
    L ( 1,-1, 1);
    L ( 1, 1, 1);

    L ( 1, 1,-1);
    L (-1, 1,-1);
    L (-1,-1,-1);
    L ( 1,-1,-1);
    L ( 1, 1,-1);

    M (-1, 1,-1);
    L (-1, 1, 1);

    M (-1,-1, 1);
    L (-1,-1,-1);

    M ( 1,-1,-1);
    L ( 1,-1, 1)
  END {Cube};

  PROCEDURE Sphere;
  VAR
    i,j  :  INTEGER;
    phi  :  DOUBLE;
    r    :  DOUBLE;
    theta:  DOUBLE;
    w    :  WORD;
  BEGIN
    SetColor (9);
    FOR w := MinimumWindow TO MaximumWindow DO BEGIN
      windows[w].SetCoordType (spherical)
    END;

    r := 1.0;
    FOR j := 1 TO 3 DO BEGIN
      phi := Radians(45 * j {degrees} );
      M (r,0,phi);
      FOR i := 1 TO 50 DO BEGIN
        theta := Radians(7.20 * i {degrees});
        L (r,theta,phi)
      END
    END;

    FOR i := 0 TO 18 DO BEGIN
      theta := Radians(20 * i {degrees});  {0..360}
      M (r,theta,0);
      FOR j := 1 TO 50 DO BEGIN
        phi := Radians(3.60 * j {degrees});
        L (r,theta,phi)
      END
    END

  END {sphere};

BEGIN
  SetExitWait (TRUE);

  DecodeDriverMode ( GetEnv('DRIVER'),GetEnv('MODE'), GraphicsDriver, GraphicsMode);

  InitGraph (GraphicsDriver, GraphicsMode, '');
  ErrorCode := GraphResult;
  IF   ErrorCode <> grOK
  THEN BEGIN
    SetErrorMessage (1,'BGI Graphics Error:  ' + GraphErrorMsg(ErrorCode));
    SetErrorMessage (2,'Program terminated.');
    HALT
  END;

  FOR w := MinimumWindow TO MaximumWindow DO
    windows[w].Init;

  windows[1].ViewPort (0.00,0.33, 0.00,0.33);
  ViewTransformMatrix (spherical,Radians(30),Radians(45),12,
        10,10,30, a);
  windows[1].SetTransform (a);

  windows[2].ViewPort (0.33,0.67, 0.00,0.33);
  ViewTransformMatrix (spherical,Radians(45),Radians(45),12,
        10,10,30, a);
  windows[2].SetTransform (a);

  windows[3].ViewPort (0.67,1.00, 0.00,0.33);
  ViewTransformMatrix (spherical,Radians(60),Radians(45),12,
        10,10,30, a);
  windows[3].SetTransform (a);

  windows[4].ViewPort (0.00,0.33, 0.33,0.67);
  ViewTransformMatrix (spherical,Radians(30),Radians(60),12,
        10,10,30, a);
  windows[4].SetTransform (a);

  windows[5].ViewPort (0.33,0.67, 0.33,0.67);
  ViewTransformMatrix (spherical,Radians(60),Radians(60),12,
        10,10,30, a);
  windows[5].SetTransform (a);

  windows[6].ViewPort (0.67,1.00, 0.33,0.67);
  ViewTransformMatrix (spherical,Radians(30),Radians(90),12,
        10,10,30, a);
  windows[6].SetTransform (a);

  windows[7].WorldCoordinatesRange (-1.25,1.25, -1.25,1.25);
  windows[7].ViewPort (0.00,0.33, 0.67,1.00);
  windows[7].SetProjectionType (orthoXY);
  windows[7].SetClipping (FALSE);

  windows[8].WorldCoordinatesRange (-1.25,1.25, -1.25,1.25);
  windows[8].ViewPort (0.33,0.67, 0.67,1.00);
  windows[8].SetProjectionType (orthoXZ);
  windows[8].SetClipping (FALSE);

  windows[9].WorldCoordinatesRange (-1.25,1.25, -1.25,1.25);
  windows[9].ViewPort (0.67,1.00, 0.67,1.00);
  windows[9].SetProjectionType (orthoYZ);
  windows[9].SetClipping (FALSE);

  Cube;
  Sphere;

  READLN;
  CloseGraph;
  SetGraph (FALSE)

END {Spheres}.
